/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dsql.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dsql.model.ClusterArnListCopier;
import software.amazon.awssdk.services.dsql.model.ClusterStatus;
import software.amazon.awssdk.services.dsql.model.DsqlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateClusterResponse
extends DsqlResponse
implements ToCopyableBuilder<Builder, UpdateClusterResponse> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(UpdateClusterResponse.getter(UpdateClusterResponse::identifier)).setter(UpdateClusterResponse.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(UpdateClusterResponse.getter(UpdateClusterResponse::arn)).setter(UpdateClusterResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateClusterResponse.getter(UpdateClusterResponse::statusAsString)).setter(UpdateClusterResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(UpdateClusterResponse.getter(UpdateClusterResponse::creationTime)).setter(UpdateClusterResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> WITNESS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("witnessRegion").getter(UpdateClusterResponse.getter(UpdateClusterResponse::witnessRegion)).setter(UpdateClusterResponse.setter(Builder::witnessRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("witnessRegion").build()}).build();
    private static final SdkField<List<String>> LINKED_CLUSTER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("linkedClusterArns").getter(UpdateClusterResponse.getter(UpdateClusterResponse::linkedClusterArns)).setter(UpdateClusterResponse.setter(Builder::linkedClusterArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linkedClusterArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deletionProtectionEnabled").getter(UpdateClusterResponse.getter(UpdateClusterResponse::deletionProtectionEnabled)).setter(UpdateClusterResponse.setter(Builder::deletionProtectionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtectionEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, ARN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, WITNESS_REGION_FIELD, LINKED_CLUSTER_ARNS_FIELD, DELETION_PROTECTION_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateClusterResponse.memberNameToFieldInitializer();
    private final String identifier;
    private final String arn;
    private final String status;
    private final Instant creationTime;
    private final String witnessRegion;
    private final List<String> linkedClusterArns;
    private final Boolean deletionProtectionEnabled;

    private UpdateClusterResponse(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.arn = builder.arn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.witnessRegion = builder.witnessRegion;
        this.linkedClusterArns = builder.linkedClusterArns;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String arn() {
        return this.arn;
    }

    public final ClusterStatus status() {
        return ClusterStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    @Deprecated
    public final String witnessRegion() {
        return this.witnessRegion;
    }

    @Deprecated
    public final boolean hasLinkedClusterArns() {
        return this.linkedClusterArns != null && !(this.linkedClusterArns instanceof SdkAutoConstructList);
    }

    @Deprecated
    public final List<String> linkedClusterArns() {
        return this.linkedClusterArns;
    }

    @Deprecated
    public final Boolean deletionProtectionEnabled() {
        return this.deletionProtectionEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.witnessRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinkedClusterArns() ? this.linkedClusterArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtectionEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterResponse)) {
            return false;
        }
        UpdateClusterResponse other = (UpdateClusterResponse)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.witnessRegion(), other.witnessRegion()) && this.hasLinkedClusterArns() == other.hasLinkedClusterArns() && Objects.equals(this.linkedClusterArns(), other.linkedClusterArns()) && Objects.equals(this.deletionProtectionEnabled(), other.deletionProtectionEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateClusterResponse").add("Identifier", (Object)this.identifier()).add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("WitnessRegion", (Object)this.witnessRegion()).add("LinkedClusterArns", this.hasLinkedClusterArns() ? this.linkedClusterArns() : null).add("DeletionProtectionEnabled", (Object)this.deletionProtectionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "witnessRegion": {
                return Optional.ofNullable(clazz.cast(this.witnessRegion()));
            }
            case "linkedClusterArns": {
                return Optional.ofNullable(clazz.cast(this.linkedClusterArns()));
            }
            case "deletionProtectionEnabled": {
                return Optional.ofNullable(clazz.cast(this.deletionProtectionEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("witnessRegion", WITNESS_REGION_FIELD);
        map.put("linkedClusterArns", LINKED_CLUSTER_ARNS_FIELD);
        map.put("deletionProtectionEnabled", DELETION_PROTECTION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterResponse, T> g) {
        return obj -> g.apply((UpdateClusterResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DsqlResponse.BuilderImpl
    implements Builder {
        private String identifier;
        private String arn;
        private String status;
        private Instant creationTime;
        private String witnessRegion;
        private List<String> linkedClusterArns = DefaultSdkAutoConstructList.getInstance();
        private Boolean deletionProtectionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterResponse model) {
            super(model);
            this.identifier(model.identifier);
            this.arn(model.arn);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.witnessRegion(model.witnessRegion);
            this.linkedClusterArns(model.linkedClusterArns);
            this.deletionProtectionEnabled(model.deletionProtectionEnabled);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClusterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Deprecated
        public final String getWitnessRegion() {
            return this.witnessRegion;
        }

        @Deprecated
        public final void setWitnessRegion(String witnessRegion) {
            this.witnessRegion = witnessRegion;
        }

        @Override
        @Deprecated
        public final Builder witnessRegion(String witnessRegion) {
            this.witnessRegion = witnessRegion;
            return this;
        }

        @Deprecated
        public final Collection<String> getLinkedClusterArns() {
            if (this.linkedClusterArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.linkedClusterArns;
        }

        @Deprecated
        public final void setLinkedClusterArns(Collection<String> linkedClusterArns) {
            this.linkedClusterArns = ClusterArnListCopier.copy(linkedClusterArns);
        }

        @Override
        @Deprecated
        public final Builder linkedClusterArns(Collection<String> linkedClusterArns) {
            this.linkedClusterArns = ClusterArnListCopier.copy(linkedClusterArns);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder linkedClusterArns(String ... linkedClusterArns) {
            this.linkedClusterArns(Arrays.asList(linkedClusterArns));
            return this;
        }

        @Deprecated
        public final Boolean getDeletionProtectionEnabled() {
            return this.deletionProtectionEnabled;
        }

        @Deprecated
        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        @Deprecated
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        @Override
        public UpdateClusterResponse build() {
            return new UpdateClusterResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DsqlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateClusterResponse> {
        public Builder identifier(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(ClusterStatus var1);

        public Builder creationTime(Instant var1);

        @Deprecated
        public Builder witnessRegion(String var1);

        @Deprecated
        public Builder linkedClusterArns(Collection<String> var1);

        @Deprecated
        public Builder linkedClusterArns(String ... var1);

        @Deprecated
        public Builder deletionProtectionEnabled(Boolean var1);
    }
}

