/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dsql.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output of a created cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClusterResponse extends DsqlResponse implements
        ToCopyableBuilder<CreateClusterResponse.Builder, CreateClusterResponse> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(CreateClusterResponse::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateClusterResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateClusterResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(CreateClusterResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<MultiRegionProperties> MULTI_REGION_PROPERTIES_FIELD = SdkField
            .<MultiRegionProperties> builder(MarshallingType.SDK_POJO).memberName("multiRegionProperties")
            .getter(getter(CreateClusterResponse::multiRegionProperties)).setter(setter(Builder::multiRegionProperties))
            .constructor(MultiRegionProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiRegionProperties").build())
            .build();

    private static final SdkField<EncryptionDetails> ENCRYPTION_DETAILS_FIELD = SdkField
            .<EncryptionDetails> builder(MarshallingType.SDK_POJO).memberName("encryptionDetails")
            .getter(getter(CreateClusterResponse::encryptionDetails)).setter(setter(Builder::encryptionDetails))
            .constructor(EncryptionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionDetails").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("deletionProtectionEnabled")
            .getter(getter(CreateClusterResponse::deletionProtectionEnabled)).setter(setter(Builder::deletionProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtectionEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, ARN_FIELD,
            STATUS_FIELD, CREATION_TIME_FIELD, MULTI_REGION_PROPERTIES_FIELD, ENCRYPTION_DETAILS_FIELD,
            DELETION_PROTECTION_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final String arn;

    private final String status;

    private final Instant creationTime;

    private final MultiRegionProperties multiRegionProperties;

    private final EncryptionDetails encryptionDetails;

    private final Boolean deletionProtectionEnabled;

    private CreateClusterResponse(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.arn = builder.arn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.multiRegionProperties = builder.multiRegionProperties;
        this.encryptionDetails = builder.encryptionDetails;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
    }

    /**
     * <p>
     * The ID of the created cluster.
     * </p>
     * 
     * @return The ID of the created cluster.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The ARN of the created cluster.
     * </p>
     * 
     * @return The ARN of the created cluster.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the created cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the created cluster.
     * @see ClusterStatus
     */
    public final ClusterStatus status() {
        return ClusterStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the created cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the created cluster.
     * @see ClusterStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time of when created the cluster.
     * </p>
     * 
     * @return The time of when created the cluster.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The multi-Region cluster configuration details that were set during cluster creation
     * </p>
     * 
     * @return The multi-Region cluster configuration details that were set during cluster creation
     */
    public final MultiRegionProperties multiRegionProperties() {
        return multiRegionProperties;
    }

    /**
     * <p>
     * The encryption configuration for the cluster that was specified during the creation process, including the KMS
     * key identifier and encryption state.
     * </p>
     * 
     * @return The encryption configuration for the cluster that was specified during the creation process, including
     *         the KMS key identifier and encryption state.
     */
    public final EncryptionDetails encryptionDetails() {
        return encryptionDetails;
    }

    /**
     * <p>
     * Whether deletion protection is enabled on this cluster.
     * </p>
     * 
     * @return Whether deletion protection is enabled on this cluster.
     */
    public final Boolean deletionProtectionEnabled() {
        return deletionProtectionEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(multiRegionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterResponse)) {
            return false;
        }
        CreateClusterResponse other = (CreateClusterResponse) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(arn(), other.arn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(multiRegionProperties(), other.multiRegionProperties())
                && Objects.equals(encryptionDetails(), other.encryptionDetails())
                && Objects.equals(deletionProtectionEnabled(), other.deletionProtectionEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateClusterResponse").add("Identifier", identifier()).add("Arn", arn())
                .add("Status", statusAsString()).add("CreationTime", creationTime())
                .add("MultiRegionProperties", multiRegionProperties()).add("EncryptionDetails", encryptionDetails())
                .add("DeletionProtectionEnabled", deletionProtectionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "multiRegionProperties":
            return Optional.ofNullable(clazz.cast(multiRegionProperties()));
        case "encryptionDetails":
            return Optional.ofNullable(clazz.cast(encryptionDetails()));
        case "deletionProtectionEnabled":
            return Optional.ofNullable(clazz.cast(deletionProtectionEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("multiRegionProperties", MULTI_REGION_PROPERTIES_FIELD);
        map.put("encryptionDetails", ENCRYPTION_DETAILS_FIELD);
        map.put("deletionProtectionEnabled", DELETION_PROTECTION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterResponse, T> g) {
        return obj -> g.apply((CreateClusterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DsqlResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateClusterResponse> {
        /**
         * <p>
         * The ID of the created cluster.
         * </p>
         * 
         * @param identifier
         *        The ID of the created cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The ARN of the created cluster.
         * </p>
         * 
         * @param arn
         *        The ARN of the created cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the created cluster.
         * </p>
         * 
         * @param status
         *        The status of the created cluster.
         * @see ClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the created cluster.
         * </p>
         * 
         * @param status
         *        The status of the created cluster.
         * @see ClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterStatus
         */
        Builder status(ClusterStatus status);

        /**
         * <p>
         * The time of when created the cluster.
         * </p>
         * 
         * @param creationTime
         *        The time of when created the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The multi-Region cluster configuration details that were set during cluster creation
         * </p>
         * 
         * @param multiRegionProperties
         *        The multi-Region cluster configuration details that were set during cluster creation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionProperties(MultiRegionProperties multiRegionProperties);

        /**
         * <p>
         * The multi-Region cluster configuration details that were set during cluster creation
         * </p>
         * This is a convenience method that creates an instance of the {@link MultiRegionProperties.Builder} avoiding
         * the need to create one manually via {@link MultiRegionProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultiRegionProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #multiRegionProperties(MultiRegionProperties)}.
         * 
         * @param multiRegionProperties
         *        a consumer that will call methods on {@link MultiRegionProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiRegionProperties(MultiRegionProperties)
         */
        default Builder multiRegionProperties(Consumer<MultiRegionProperties.Builder> multiRegionProperties) {
            return multiRegionProperties(MultiRegionProperties.builder().applyMutation(multiRegionProperties).build());
        }

        /**
         * <p>
         * The encryption configuration for the cluster that was specified during the creation process, including the
         * KMS key identifier and encryption state.
         * </p>
         * 
         * @param encryptionDetails
         *        The encryption configuration for the cluster that was specified during the creation process, including
         *        the KMS key identifier and encryption state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionDetails(EncryptionDetails encryptionDetails);

        /**
         * <p>
         * The encryption configuration for the cluster that was specified during the creation process, including the
         * KMS key identifier and encryption state.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionDetails.Builder} avoiding the
         * need to create one manually via {@link EncryptionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionDetails(EncryptionDetails)}.
         * 
         * @param encryptionDetails
         *        a consumer that will call methods on {@link EncryptionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionDetails(EncryptionDetails)
         */
        default Builder encryptionDetails(Consumer<EncryptionDetails.Builder> encryptionDetails) {
            return encryptionDetails(EncryptionDetails.builder().applyMutation(encryptionDetails).build());
        }

        /**
         * <p>
         * Whether deletion protection is enabled on this cluster.
         * </p>
         * 
         * @param deletionProtectionEnabled
         *        Whether deletion protection is enabled on this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled);
    }

    static final class BuilderImpl extends DsqlResponse.BuilderImpl implements Builder {
        private String identifier;

        private String arn;

        private String status;

        private Instant creationTime;

        private MultiRegionProperties multiRegionProperties;

        private EncryptionDetails encryptionDetails;

        private Boolean deletionProtectionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterResponse model) {
            super(model);
            identifier(model.identifier);
            arn(model.arn);
            status(model.status);
            creationTime(model.creationTime);
            multiRegionProperties(model.multiRegionProperties);
            encryptionDetails(model.encryptionDetails);
            deletionProtectionEnabled(model.deletionProtectionEnabled);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClusterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final MultiRegionProperties.Builder getMultiRegionProperties() {
            return multiRegionProperties != null ? multiRegionProperties.toBuilder() : null;
        }

        public final void setMultiRegionProperties(MultiRegionProperties.BuilderImpl multiRegionProperties) {
            this.multiRegionProperties = multiRegionProperties != null ? multiRegionProperties.build() : null;
        }

        @Override
        public final Builder multiRegionProperties(MultiRegionProperties multiRegionProperties) {
            this.multiRegionProperties = multiRegionProperties;
            return this;
        }

        public final EncryptionDetails.Builder getEncryptionDetails() {
            return encryptionDetails != null ? encryptionDetails.toBuilder() : null;
        }

        public final void setEncryptionDetails(EncryptionDetails.BuilderImpl encryptionDetails) {
            this.encryptionDetails = encryptionDetails != null ? encryptionDetails.build() : null;
        }

        @Override
        public final Builder encryptionDetails(EncryptionDetails encryptionDetails) {
            this.encryptionDetails = encryptionDetails;
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        @Override
        public CreateClusterResponse build() {
            return new CreateClusterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
