/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dsql.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output of a cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetClusterResponse extends DsqlResponse implements
        ToCopyableBuilder<GetClusterResponse.Builder, GetClusterResponse> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(GetClusterResponse::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetClusterResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetClusterResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(GetClusterResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("deletionProtectionEnabled")
            .getter(getter(GetClusterResponse::deletionProtectionEnabled)).setter(setter(Builder::deletionProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtectionEnabled").build())
            .build();

    private static final SdkField<MultiRegionProperties> MULTI_REGION_PROPERTIES_FIELD = SdkField
            .<MultiRegionProperties> builder(MarshallingType.SDK_POJO).memberName("multiRegionProperties")
            .getter(getter(GetClusterResponse::multiRegionProperties)).setter(setter(Builder::multiRegionProperties))
            .constructor(MultiRegionProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiRegionProperties").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetClusterResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<EncryptionDetails> ENCRYPTION_DETAILS_FIELD = SdkField
            .<EncryptionDetails> builder(MarshallingType.SDK_POJO).memberName("encryptionDetails")
            .getter(getter(GetClusterResponse::encryptionDetails)).setter(setter(Builder::encryptionDetails))
            .constructor(EncryptionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, ARN_FIELD,
            STATUS_FIELD, CREATION_TIME_FIELD, DELETION_PROTECTION_ENABLED_FIELD, MULTI_REGION_PROPERTIES_FIELD, TAGS_FIELD,
            ENCRYPTION_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final String arn;

    private final String status;

    private final Instant creationTime;

    private final Boolean deletionProtectionEnabled;

    private final MultiRegionProperties multiRegionProperties;

    private final Map<String, String> tags;

    private final EncryptionDetails encryptionDetails;

    private GetClusterResponse(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.arn = builder.arn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
        this.multiRegionProperties = builder.multiRegionProperties;
        this.tags = builder.tags;
        this.encryptionDetails = builder.encryptionDetails;
    }

    /**
     * <p>
     * The ID of the retrieved cluster.
     * </p>
     * 
     * @return The ID of the retrieved cluster.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The ARN of the retrieved cluster.
     * </p>
     * 
     * @return The ARN of the retrieved cluster.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the retrieved cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the retrieved cluster.
     * @see ClusterStatus
     */
    public final ClusterStatus status() {
        return ClusterStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the retrieved cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the retrieved cluster.
     * @see ClusterStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time of when the cluster was created.
     * </p>
     * 
     * @return The time of when the cluster was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Whether deletion protection is enabled in this cluster.
     * </p>
     * 
     * @return Whether deletion protection is enabled in this cluster.
     */
    public final Boolean deletionProtectionEnabled() {
        return deletionProtectionEnabled;
    }

    /**
     * <p>
     * Returns the current multi-Region cluster configuration, including witness region and linked cluster information.
     * </p>
     * 
     * @return Returns the current multi-Region cluster configuration, including witness region and linked cluster
     *         information.
     */
    public final MultiRegionProperties multiRegionProperties() {
        return multiRegionProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The current encryption configuration details for the cluster.
     * </p>
     * 
     * @return The current encryption configuration details for the cluster.
     */
    public final EncryptionDetails encryptionDetails() {
        return encryptionDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(multiRegionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(encryptionDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClusterResponse)) {
            return false;
        }
        GetClusterResponse other = (GetClusterResponse) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(arn(), other.arn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(deletionProtectionEnabled(), other.deletionProtectionEnabled())
                && Objects.equals(multiRegionProperties(), other.multiRegionProperties()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(encryptionDetails(), other.encryptionDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetClusterResponse").add("Identifier", identifier()).add("Arn", arn())
                .add("Status", statusAsString()).add("CreationTime", creationTime())
                .add("DeletionProtectionEnabled", deletionProtectionEnabled())
                .add("MultiRegionProperties", multiRegionProperties()).add("Tags", hasTags() ? tags() : null)
                .add("EncryptionDetails", encryptionDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "deletionProtectionEnabled":
            return Optional.ofNullable(clazz.cast(deletionProtectionEnabled()));
        case "multiRegionProperties":
            return Optional.ofNullable(clazz.cast(multiRegionProperties()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "encryptionDetails":
            return Optional.ofNullable(clazz.cast(encryptionDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("deletionProtectionEnabled", DELETION_PROTECTION_ENABLED_FIELD);
        map.put("multiRegionProperties", MULTI_REGION_PROPERTIES_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("encryptionDetails", ENCRYPTION_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetClusterResponse, T> g) {
        return obj -> g.apply((GetClusterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DsqlResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetClusterResponse> {
        /**
         * <p>
         * The ID of the retrieved cluster.
         * </p>
         * 
         * @param identifier
         *        The ID of the retrieved cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The ARN of the retrieved cluster.
         * </p>
         * 
         * @param arn
         *        The ARN of the retrieved cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the retrieved cluster.
         * </p>
         * 
         * @param status
         *        The status of the retrieved cluster.
         * @see ClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the retrieved cluster.
         * </p>
         * 
         * @param status
         *        The status of the retrieved cluster.
         * @see ClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterStatus
         */
        Builder status(ClusterStatus status);

        /**
         * <p>
         * The time of when the cluster was created.
         * </p>
         * 
         * @param creationTime
         *        The time of when the cluster was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Whether deletion protection is enabled in this cluster.
         * </p>
         * 
         * @param deletionProtectionEnabled
         *        Whether deletion protection is enabled in this cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled);

        /**
         * <p>
         * Returns the current multi-Region cluster configuration, including witness region and linked cluster
         * information.
         * </p>
         * 
         * @param multiRegionProperties
         *        Returns the current multi-Region cluster configuration, including witness region and linked cluster
         *        information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionProperties(MultiRegionProperties multiRegionProperties);

        /**
         * <p>
         * Returns the current multi-Region cluster configuration, including witness region and linked cluster
         * information.
         * </p>
         * This is a convenience method that creates an instance of the {@link MultiRegionProperties.Builder} avoiding
         * the need to create one manually via {@link MultiRegionProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultiRegionProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #multiRegionProperties(MultiRegionProperties)}.
         * 
         * @param multiRegionProperties
         *        a consumer that will call methods on {@link MultiRegionProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiRegionProperties(MultiRegionProperties)
         */
        default Builder multiRegionProperties(Consumer<MultiRegionProperties.Builder> multiRegionProperties) {
            return multiRegionProperties(MultiRegionProperties.builder().applyMutation(multiRegionProperties).build());
        }

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The current encryption configuration details for the cluster.
         * </p>
         * 
         * @param encryptionDetails
         *        The current encryption configuration details for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionDetails(EncryptionDetails encryptionDetails);

        /**
         * <p>
         * The current encryption configuration details for the cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionDetails.Builder} avoiding the
         * need to create one manually via {@link EncryptionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionDetails(EncryptionDetails)}.
         * 
         * @param encryptionDetails
         *        a consumer that will call methods on {@link EncryptionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionDetails(EncryptionDetails)
         */
        default Builder encryptionDetails(Consumer<EncryptionDetails.Builder> encryptionDetails) {
            return encryptionDetails(EncryptionDetails.builder().applyMutation(encryptionDetails).build());
        }
    }

    static final class BuilderImpl extends DsqlResponse.BuilderImpl implements Builder {
        private String identifier;

        private String arn;

        private String status;

        private Instant creationTime;

        private Boolean deletionProtectionEnabled;

        private MultiRegionProperties multiRegionProperties;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private EncryptionDetails encryptionDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClusterResponse model) {
            super(model);
            identifier(model.identifier);
            arn(model.arn);
            status(model.status);
            creationTime(model.creationTime);
            deletionProtectionEnabled(model.deletionProtectionEnabled);
            multiRegionProperties(model.multiRegionProperties);
            tags(model.tags);
            encryptionDetails(model.encryptionDetails);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClusterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        public final MultiRegionProperties.Builder getMultiRegionProperties() {
            return multiRegionProperties != null ? multiRegionProperties.toBuilder() : null;
        }

        public final void setMultiRegionProperties(MultiRegionProperties.BuilderImpl multiRegionProperties) {
            this.multiRegionProperties = multiRegionProperties != null ? multiRegionProperties.build() : null;
        }

        @Override
        public final Builder multiRegionProperties(MultiRegionProperties multiRegionProperties) {
            this.multiRegionProperties = multiRegionProperties;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final EncryptionDetails.Builder getEncryptionDetails() {
            return encryptionDetails != null ? encryptionDetails.toBuilder() : null;
        }

        public final void setEncryptionDetails(EncryptionDetails.BuilderImpl encryptionDetails) {
            this.encryptionDetails = encryptionDetails != null ? encryptionDetails.build() : null;
        }

        @Override
        public final Builder encryptionDetails(EncryptionDetails encryptionDetails) {
            this.encryptionDetails = encryptionDetails;
            return this;
        }

        @Override
        public GetClusterResponse build() {
            return new GetClusterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
