/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * This is an interface reference for Amazon Aurora DSQL. It contains documentation for one of the programming or
 * command line interfaces you can use to manage Amazon Aurora DSQL.
 * </p>
 * <p>
 * Amazon Aurora DSQL is a serverless, distributed SQL database suitable for workloads of any size. is available in both
 * single-Region and multi-Region configurations, so your clusters and databases are always available even if an
 * Availability Zone or an Amazon Web Services Region are unavailable. lets you focus on using your data to acquire new
 * insights for your business and customers.
 * </p>
 */
package software.amazon.awssdk.services.dsql;