/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dsql.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClusterRequest extends DsqlRequest implements
        ToCopyableBuilder<CreateClusterRequest.Builder, CreateClusterRequest> {
    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("deletionProtectionEnabled")
            .getter(getter(CreateClusterRequest::deletionProtectionEnabled)).setter(setter(Builder::deletionProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtectionEnabled").build())
            .build();

    private static final SdkField<String> KMS_ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsEncryptionKey").getter(getter(CreateClusterRequest::kmsEncryptionKey))
            .setter(setter(Builder::kmsEncryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsEncryptionKey").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateClusterRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<MultiRegionProperties> MULTI_REGION_PROPERTIES_FIELD = SdkField
            .<MultiRegionProperties> builder(MarshallingType.SDK_POJO).memberName("multiRegionProperties")
            .getter(getter(CreateClusterRequest::multiRegionProperties)).setter(setter(Builder::multiRegionProperties))
            .constructor(MultiRegionProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiRegionProperties").build())
            .build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("policy")
            .getter(getter(CreateClusterRequest::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final SdkField<Boolean> BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("bypassPolicyLockoutSafetyCheck")
            .getter(getter(CreateClusterRequest::bypassPolicyLockoutSafetyCheck))
            .setter(setter(Builder::bypassPolicyLockoutSafetyCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bypassPolicyLockoutSafetyCheck")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DELETION_PROTECTION_ENABLED_FIELD, KMS_ENCRYPTION_KEY_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD,
            MULTI_REGION_PROPERTIES_FIELD, POLICY_FIELD, BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean deletionProtectionEnabled;

    private final String kmsEncryptionKey;

    private final Map<String, String> tags;

    private final String clientToken;

    private final MultiRegionProperties multiRegionProperties;

    private final String policy;

    private final Boolean bypassPolicyLockoutSafetyCheck;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
        this.kmsEncryptionKey = builder.kmsEncryptionKey;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
        this.multiRegionProperties = builder.multiRegionProperties;
        this.policy = builder.policy;
        this.bypassPolicyLockoutSafetyCheck = builder.bypassPolicyLockoutSafetyCheck;
    }

    /**
     * <p>
     * If enabled, you can't delete your cluster. You must first disable this property before you can delete your
     * cluster.
     * </p>
     * 
     * @return If enabled, you can't delete your cluster. You must first disable this property before you can delete
     *         your cluster.
     */
    public final Boolean deletionProtectionEnabled() {
        return deletionProtectionEnabled;
    }

    /**
     * <p>
     * The KMS key that encrypts and protects the data on your cluster. You can specify the ARN, ID, or alias of an
     * existing key or have Amazon Web Services create a default key for you.
     * </p>
     * 
     * @return The KMS key that encrypts and protects the data on your cluster. You can specify the ARN, ID, or alias of
     *         an existing key or have Amazon Web Services create a default key for you.
     */
    public final String kmsEncryptionKey() {
        return kmsEncryptionKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key and value pairs to use to tag your cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of key and value pairs to use to tag your cluster.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, the subsequent retries with the same client token return the result from the original successful
     * request and they have no additional effect.
     * </p>
     * <p>
     * If you don't specify a client token, the Amazon Web Services SDK automatically generates one.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, the subsequent retries with the same client token return the result from
     *         the original successful request and they have no additional effect.</p>
     *         <p>
     *         If you don't specify a client token, the Amazon Web Services SDK automatically generates one.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The configuration settings when creating a multi-Region cluster, including the witness region and linked cluster
     * properties.
     * </p>
     * 
     * @return The configuration settings when creating a multi-Region cluster, including the witness region and linked
     *         cluster properties.
     */
    public final MultiRegionProperties multiRegionProperties() {
        return multiRegionProperties;
    }

    /**
     * <p>
     * An optional resource-based policy document in JSON format that defines access permissions for the cluster.
     * </p>
     * 
     * @return An optional resource-based policy document in JSON format that defines access permissions for the
     *         cluster.
     */
    public final String policy() {
        return policy;
    }

    /**
     * <p>
     * An optional field that controls whether to bypass the lockout prevention check. When set to true, this parameter
     * allows you to apply a policy that might lock you out of the cluster. Use with caution.
     * </p>
     * 
     * @return An optional field that controls whether to bypass the lockout prevention check. When set to true, this
     *         parameter allows you to apply a policy that might lock you out of the cluster. Use with caution.
     */
    public final Boolean bypassPolicyLockoutSafetyCheck() {
        return bypassPolicyLockoutSafetyCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(kmsEncryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(multiRegionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(bypassPolicyLockoutSafetyCheck());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest) obj;
        return Objects.equals(deletionProtectionEnabled(), other.deletionProtectionEnabled())
                && Objects.equals(kmsEncryptionKey(), other.kmsEncryptionKey()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(multiRegionProperties(), other.multiRegionProperties())
                && Objects.equals(policy(), other.policy())
                && Objects.equals(bypassPolicyLockoutSafetyCheck(), other.bypassPolicyLockoutSafetyCheck());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateClusterRequest").add("DeletionProtectionEnabled", deletionProtectionEnabled())
                .add("KmsEncryptionKey", kmsEncryptionKey()).add("Tags", hasTags() ? tags() : null)
                .add("ClientToken", clientToken()).add("MultiRegionProperties", multiRegionProperties()).add("Policy", policy())
                .add("BypassPolicyLockoutSafetyCheck", bypassPolicyLockoutSafetyCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deletionProtectionEnabled":
            return Optional.ofNullable(clazz.cast(deletionProtectionEnabled()));
        case "kmsEncryptionKey":
            return Optional.ofNullable(clazz.cast(kmsEncryptionKey()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "multiRegionProperties":
            return Optional.ofNullable(clazz.cast(multiRegionProperties()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "bypassPolicyLockoutSafetyCheck":
            return Optional.ofNullable(clazz.cast(bypassPolicyLockoutSafetyCheck()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deletionProtectionEnabled", DELETION_PROTECTION_ENABLED_FIELD);
        map.put("kmsEncryptionKey", KMS_ENCRYPTION_KEY_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("multiRegionProperties", MULTI_REGION_PROPERTIES_FIELD);
        map.put("policy", POLICY_FIELD);
        map.put("bypassPolicyLockoutSafetyCheck", BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DsqlRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateClusterRequest> {
        /**
         * <p>
         * If enabled, you can't delete your cluster. You must first disable this property before you can delete your
         * cluster.
         * </p>
         * 
         * @param deletionProtectionEnabled
         *        If enabled, you can't delete your cluster. You must first disable this property before you can delete
         *        your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled);

        /**
         * <p>
         * The KMS key that encrypts and protects the data on your cluster. You can specify the ARN, ID, or alias of an
         * existing key or have Amazon Web Services create a default key for you.
         * </p>
         * 
         * @param kmsEncryptionKey
         *        The KMS key that encrypts and protects the data on your cluster. You can specify the ARN, ID, or alias
         *        of an existing key or have Amazon Web Services create a default key for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncryptionKey(String kmsEncryptionKey);

        /**
         * <p>
         * A map of key and value pairs to use to tag your cluster.
         * </p>
         * 
         * @param tags
         *        A map of key and value pairs to use to tag your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully, the subsequent retries with the same client token return the result from the original
         * successful request and they have no additional effect.
         * </p>
         * <p>
         * If you don't specify a client token, the Amazon Web Services SDK automatically generates one.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully, the subsequent retries with the same client token return the
         *        result from the original successful request and they have no additional effect.</p>
         *        <p>
         *        If you don't specify a client token, the Amazon Web Services SDK automatically generates one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The configuration settings when creating a multi-Region cluster, including the witness region and linked
         * cluster properties.
         * </p>
         * 
         * @param multiRegionProperties
         *        The configuration settings when creating a multi-Region cluster, including the witness region and
         *        linked cluster properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionProperties(MultiRegionProperties multiRegionProperties);

        /**
         * <p>
         * The configuration settings when creating a multi-Region cluster, including the witness region and linked
         * cluster properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link MultiRegionProperties.Builder} avoiding
         * the need to create one manually via {@link MultiRegionProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultiRegionProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #multiRegionProperties(MultiRegionProperties)}.
         * 
         * @param multiRegionProperties
         *        a consumer that will call methods on {@link MultiRegionProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiRegionProperties(MultiRegionProperties)
         */
        default Builder multiRegionProperties(Consumer<MultiRegionProperties.Builder> multiRegionProperties) {
            return multiRegionProperties(MultiRegionProperties.builder().applyMutation(multiRegionProperties).build());
        }

        /**
         * <p>
         * An optional resource-based policy document in JSON format that defines access permissions for the cluster.
         * </p>
         * 
         * @param policy
         *        An optional resource-based policy document in JSON format that defines access permissions for the
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * An optional field that controls whether to bypass the lockout prevention check. When set to true, this
         * parameter allows you to apply a policy that might lock you out of the cluster. Use with caution.
         * </p>
         * 
         * @param bypassPolicyLockoutSafetyCheck
         *        An optional field that controls whether to bypass the lockout prevention check. When set to true, this
         *        parameter allows you to apply a policy that might lock you out of the cluster. Use with caution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DsqlRequest.BuilderImpl implements Builder {
        private Boolean deletionProtectionEnabled;

        private String kmsEncryptionKey;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private MultiRegionProperties multiRegionProperties;

        private String policy;

        private Boolean bypassPolicyLockoutSafetyCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            deletionProtectionEnabled(model.deletionProtectionEnabled);
            kmsEncryptionKey(model.kmsEncryptionKey);
            tags(model.tags);
            clientToken(model.clientToken);
            multiRegionProperties(model.multiRegionProperties);
            policy(model.policy);
            bypassPolicyLockoutSafetyCheck(model.bypassPolicyLockoutSafetyCheck);
        }

        public final Boolean getDeletionProtectionEnabled() {
            return deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        public final String getKmsEncryptionKey() {
            return kmsEncryptionKey;
        }

        public final void setKmsEncryptionKey(String kmsEncryptionKey) {
            this.kmsEncryptionKey = kmsEncryptionKey;
        }

        @Override
        public final Builder kmsEncryptionKey(String kmsEncryptionKey) {
            this.kmsEncryptionKey = kmsEncryptionKey;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final MultiRegionProperties.Builder getMultiRegionProperties() {
            return multiRegionProperties != null ? multiRegionProperties.toBuilder() : null;
        }

        public final void setMultiRegionProperties(MultiRegionProperties.BuilderImpl multiRegionProperties) {
            this.multiRegionProperties = multiRegionProperties != null ? multiRegionProperties.build() : null;
        }

        @Override
        public final Builder multiRegionProperties(MultiRegionProperties multiRegionProperties) {
            this.multiRegionProperties = multiRegionProperties;
            return this;
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final Boolean getBypassPolicyLockoutSafetyCheck() {
            return bypassPolicyLockoutSafetyCheck;
        }

        public final void setBypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
        }

        @Override
        public final Builder bypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
