/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dsql.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration details about encryption for the cluster including the KMS key ARN, encryption type, and encryption
 * status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionDetails.Builder, EncryptionDetails> {
    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionType").getter(getter(EncryptionDetails::encryptionTypeAsString))
            .setter(setter(Builder::encryptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionType").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(EncryptionDetails::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<String> ENCRYPTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionStatus").getter(getter(EncryptionDetails::encryptionStatusAsString))
            .setter(setter(Builder::encryptionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_TYPE_FIELD,
            KMS_KEY_ARN_FIELD, ENCRYPTION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String encryptionType;

    private final String kmsKeyArn;

    private final String encryptionStatus;

    private EncryptionDetails(BuilderImpl builder) {
        this.encryptionType = builder.encryptionType;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.encryptionStatus = builder.encryptionStatus;
    }

    /**
     * <p>
     * The type of encryption that protects the data on your cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return The type of encryption that protects the data on your cluster.
     * @see EncryptionType
     */
    public final EncryptionType encryptionType() {
        return EncryptionType.fromValue(encryptionType);
    }

    /**
     * <p>
     * The type of encryption that protects the data on your cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return The type of encryption that protects the data on your cluster.
     * @see EncryptionType
     */
    public final String encryptionTypeAsString() {
        return encryptionType;
    }

    /**
     * <p>
     * The ARN of the KMS key that encrypts data in the cluster.
     * </p>
     * 
     * @return The ARN of the KMS key that encrypts data in the cluster.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The status of encryption for the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionStatus}
     * will return {@link EncryptionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionStatusAsString}.
     * </p>
     * 
     * @return The status of encryption for the cluster.
     * @see EncryptionStatus
     */
    public final EncryptionStatus encryptionStatus() {
        return EncryptionStatus.fromValue(encryptionStatus);
    }

    /**
     * <p>
     * The status of encryption for the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionStatus}
     * will return {@link EncryptionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionStatusAsString}.
     * </p>
     * 
     * @return The status of encryption for the cluster.
     * @see EncryptionStatus
     */
    public final String encryptionStatusAsString() {
        return encryptionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionDetails)) {
            return false;
        }
        EncryptionDetails other = (EncryptionDetails) obj;
        return Objects.equals(encryptionTypeAsString(), other.encryptionTypeAsString())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(encryptionStatusAsString(), other.encryptionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionDetails").add("EncryptionType", encryptionTypeAsString())
                .add("KmsKeyArn", kmsKeyArn()).add("EncryptionStatus", encryptionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "encryptionType":
            return Optional.ofNullable(clazz.cast(encryptionTypeAsString()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "encryptionStatus":
            return Optional.ofNullable(clazz.cast(encryptionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("encryptionType", ENCRYPTION_TYPE_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("encryptionStatus", ENCRYPTION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EncryptionDetails, T> g) {
        return obj -> g.apply((EncryptionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionDetails> {
        /**
         * <p>
         * The type of encryption that protects the data on your cluster.
         * </p>
         * 
         * @param encryptionType
         *        The type of encryption that protects the data on your cluster.
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(String encryptionType);

        /**
         * <p>
         * The type of encryption that protects the data on your cluster.
         * </p>
         * 
         * @param encryptionType
         *        The type of encryption that protects the data on your cluster.
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(EncryptionType encryptionType);

        /**
         * <p>
         * The ARN of the KMS key that encrypts data in the cluster.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the KMS key that encrypts data in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The status of encryption for the cluster.
         * </p>
         * 
         * @param encryptionStatus
         *        The status of encryption for the cluster.
         * @see EncryptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionStatus
         */
        Builder encryptionStatus(String encryptionStatus);

        /**
         * <p>
         * The status of encryption for the cluster.
         * </p>
         * 
         * @param encryptionStatus
         *        The status of encryption for the cluster.
         * @see EncryptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionStatus
         */
        Builder encryptionStatus(EncryptionStatus encryptionStatus);
    }

    static final class BuilderImpl implements Builder {
        private String encryptionType;

        private String kmsKeyArn;

        private String encryptionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionDetails model) {
            encryptionType(model.encryptionType);
            kmsKeyArn(model.kmsKeyArn);
            encryptionStatus(model.encryptionStatus);
        }

        public final String getEncryptionType() {
            return encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getEncryptionStatus() {
            return encryptionStatus;
        }

        public final void setEncryptionStatus(String encryptionStatus) {
            this.encryptionStatus = encryptionStatus;
        }

        @Override
        public final Builder encryptionStatus(String encryptionStatus) {
            this.encryptionStatus = encryptionStatus;
            return this;
        }

        @Override
        public final Builder encryptionStatus(EncryptionStatus encryptionStatus) {
            this.encryptionStatus(encryptionStatus == null ? null : encryptionStatus.toString());
            return this;
        }

        @Override
        public EncryptionDetails build() {
            return new EncryptionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
