/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dsql.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutClusterPolicyRequest extends DsqlRequest implements
        ToCopyableBuilder<PutClusterPolicyRequest.Builder, PutClusterPolicyRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(PutClusterPolicyRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("policy")
            .getter(getter(PutClusterPolicyRequest::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final SdkField<Boolean> BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("bypassPolicyLockoutSafetyCheck")
            .getter(getter(PutClusterPolicyRequest::bypassPolicyLockoutSafetyCheck))
            .setter(setter(Builder::bypassPolicyLockoutSafetyCheck))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bypassPolicyLockoutSafetyCheck")
                    .build()).build();

    private static final SdkField<String> EXPECTED_POLICY_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expectedPolicyVersion").getter(getter(PutClusterPolicyRequest::expectedPolicyVersion))
            .setter(setter(Builder::expectedPolicyVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedPolicyVersion").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(PutClusterPolicyRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            POLICY_FIELD, BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD, EXPECTED_POLICY_VERSION_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final String policy;

    private final Boolean bypassPolicyLockoutSafetyCheck;

    private final String expectedPolicyVersion;

    private final String clientToken;

    private PutClusterPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.policy = builder.policy;
        this.bypassPolicyLockoutSafetyCheck = builder.bypassPolicyLockoutSafetyCheck;
        this.expectedPolicyVersion = builder.expectedPolicyVersion;
        this.clientToken = builder.clientToken;
    }

    /**
     * Returns the value of the Identifier property for this object.
     * 
     * @return The value of the Identifier property for this object.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The resource-based policy document to attach to the cluster. This should be a valid JSON policy document that
     * defines permissions and conditions.
     * </p>
     * 
     * @return The resource-based policy document to attach to the cluster. This should be a valid JSON policy document
     *         that defines permissions and conditions.
     */
    public final String policy() {
        return policy;
    }

    /**
     * <p>
     * A flag that allows you to bypass the policy lockout safety check. When set to true, this parameter allows you to
     * apply a policy that might lock you out of the cluster. Use with caution.
     * </p>
     * 
     * @return A flag that allows you to bypass the policy lockout safety check. When set to true, this parameter allows
     *         you to apply a policy that might lock you out of the cluster. Use with caution.
     */
    public final Boolean bypassPolicyLockoutSafetyCheck() {
        return bypassPolicyLockoutSafetyCheck;
    }

    /**
     * <p>
     * The expected version of the current policy. This parameter ensures that you're updating the correct version of
     * the policy and helps prevent concurrent modification conflicts.
     * </p>
     * 
     * @return The expected version of the current policy. This parameter ensures that you're updating the correct
     *         version of the policy and helps prevent concurrent modification conflicts.
     */
    public final String expectedPolicyVersion() {
        return expectedPolicyVersion;
    }

    /**
     * Returns the value of the ClientToken property for this object.
     * 
     * @return The value of the ClientToken property for this object.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(bypassPolicyLockoutSafetyCheck());
        hashCode = 31 * hashCode + Objects.hashCode(expectedPolicyVersion());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutClusterPolicyRequest)) {
            return false;
        }
        PutClusterPolicyRequest other = (PutClusterPolicyRequest) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(policy(), other.policy())
                && Objects.equals(bypassPolicyLockoutSafetyCheck(), other.bypassPolicyLockoutSafetyCheck())
                && Objects.equals(expectedPolicyVersion(), other.expectedPolicyVersion())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutClusterPolicyRequest").add("Identifier", identifier()).add("Policy", policy())
                .add("BypassPolicyLockoutSafetyCheck", bypassPolicyLockoutSafetyCheck())
                .add("ExpectedPolicyVersion", expectedPolicyVersion()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "bypassPolicyLockoutSafetyCheck":
            return Optional.ofNullable(clazz.cast(bypassPolicyLockoutSafetyCheck()));
        case "expectedPolicyVersion":
            return Optional.ofNullable(clazz.cast(expectedPolicyVersion()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("policy", POLICY_FIELD);
        map.put("bypassPolicyLockoutSafetyCheck", BYPASS_POLICY_LOCKOUT_SAFETY_CHECK_FIELD);
        map.put("expectedPolicyVersion", EXPECTED_POLICY_VERSION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutClusterPolicyRequest, T> g) {
        return obj -> g.apply((PutClusterPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DsqlRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutClusterPolicyRequest> {
        /**
         * Sets the value of the Identifier property for this object.
         *
         * @param identifier
         *        The new value for the Identifier property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The resource-based policy document to attach to the cluster. This should be a valid JSON policy document that
         * defines permissions and conditions.
         * </p>
         * 
         * @param policy
         *        The resource-based policy document to attach to the cluster. This should be a valid JSON policy
         *        document that defines permissions and conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * A flag that allows you to bypass the policy lockout safety check. When set to true, this parameter allows you
         * to apply a policy that might lock you out of the cluster. Use with caution.
         * </p>
         * 
         * @param bypassPolicyLockoutSafetyCheck
         *        A flag that allows you to bypass the policy lockout safety check. When set to true, this parameter
         *        allows you to apply a policy that might lock you out of the cluster. Use with caution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck);

        /**
         * <p>
         * The expected version of the current policy. This parameter ensures that you're updating the correct version
         * of the policy and helps prevent concurrent modification conflicts.
         * </p>
         * 
         * @param expectedPolicyVersion
         *        The expected version of the current policy. This parameter ensures that you're updating the correct
         *        version of the policy and helps prevent concurrent modification conflicts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedPolicyVersion(String expectedPolicyVersion);

        /**
         * Sets the value of the ClientToken property for this object.
         *
         * @param clientToken
         *        The new value for the ClientToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DsqlRequest.BuilderImpl implements Builder {
        private String identifier;

        private String policy;

        private Boolean bypassPolicyLockoutSafetyCheck;

        private String expectedPolicyVersion;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PutClusterPolicyRequest model) {
            super(model);
            identifier(model.identifier);
            policy(model.policy);
            bypassPolicyLockoutSafetyCheck(model.bypassPolicyLockoutSafetyCheck);
            expectedPolicyVersion(model.expectedPolicyVersion);
            clientToken(model.clientToken);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final Boolean getBypassPolicyLockoutSafetyCheck() {
            return bypassPolicyLockoutSafetyCheck;
        }

        public final void setBypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
        }

        @Override
        public final Builder bypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
            this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
            return this;
        }

        public final String getExpectedPolicyVersion() {
            return expectedPolicyVersion;
        }

        public final void setExpectedPolicyVersion(String expectedPolicyVersion) {
            this.expectedPolicyVersion = expectedPolicyVersion;
        }

        @Override
        public final Builder expectedPolicyVersion(String expectedPolicyVersion) {
            this.expectedPolicyVersion = expectedPolicyVersion;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutClusterPolicyRequest build() {
            return new PutClusterPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
