/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dsql.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClusterRequest extends DsqlRequest implements
        ToCopyableBuilder<UpdateClusterRequest.Builder, UpdateClusterRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(UpdateClusterRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("deletionProtectionEnabled")
            .getter(getter(UpdateClusterRequest::deletionProtectionEnabled)).setter(setter(Builder::deletionProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtectionEnabled").build())
            .build();

    private static final SdkField<String> KMS_ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsEncryptionKey").getter(getter(UpdateClusterRequest::kmsEncryptionKey))
            .setter(setter(Builder::kmsEncryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsEncryptionKey").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateClusterRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<MultiRegionProperties> MULTI_REGION_PROPERTIES_FIELD = SdkField
            .<MultiRegionProperties> builder(MarshallingType.SDK_POJO).memberName("multiRegionProperties")
            .getter(getter(UpdateClusterRequest::multiRegionProperties)).setter(setter(Builder::multiRegionProperties))
            .constructor(MultiRegionProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiRegionProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            DELETION_PROTECTION_ENABLED_FIELD, KMS_ENCRYPTION_KEY_FIELD, CLIENT_TOKEN_FIELD, MULTI_REGION_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identifier;

    private final Boolean deletionProtectionEnabled;

    private final String kmsEncryptionKey;

    private final String clientToken;

    private final MultiRegionProperties multiRegionProperties;

    private UpdateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
        this.kmsEncryptionKey = builder.kmsEncryptionKey;
        this.clientToken = builder.clientToken;
        this.multiRegionProperties = builder.multiRegionProperties;
    }

    /**
     * <p>
     * The ID of the cluster you want to update.
     * </p>
     * 
     * @return The ID of the cluster you want to update.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * Specifies whether to enable deletion protection in your cluster.
     * </p>
     * 
     * @return Specifies whether to enable deletion protection in your cluster.
     */
    public final Boolean deletionProtectionEnabled() {
        return deletionProtectionEnabled;
    }

    /**
     * <p>
     * The KMS key that encrypts and protects the data on your cluster. You can specify the ARN, ID, or alias of an
     * existing key or have Amazon Web Services create a default key for you.
     * </p>
     * 
     * @return The KMS key that encrypts and protects the data on your cluster. You can specify the ARN, ID, or alias of
     *         an existing key or have Amazon Web Services create a default key for you.
     */
    public final String kmsEncryptionKey() {
        return kmsEncryptionKey;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully. The subsequent retries with the same client token return the result from the original successful
     * request and they have no additional effect.
     * </p>
     * <p>
     * If you don't specify a client token, the Amazon Web Services SDK automatically generates one.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully. The subsequent retries with the same client token return the result from
     *         the original successful request and they have no additional effect.</p>
     *         <p>
     *         If you don't specify a client token, the Amazon Web Services SDK automatically generates one.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The new multi-Region cluster configuration settings to be applied during an update operation.
     * </p>
     * 
     * @return The new multi-Region cluster configuration settings to be applied during an update operation.
     */
    public final MultiRegionProperties multiRegionProperties() {
        return multiRegionProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(kmsEncryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(multiRegionProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterRequest)) {
            return false;
        }
        UpdateClusterRequest other = (UpdateClusterRequest) obj;
        return Objects.equals(identifier(), other.identifier())
                && Objects.equals(deletionProtectionEnabled(), other.deletionProtectionEnabled())
                && Objects.equals(kmsEncryptionKey(), other.kmsEncryptionKey())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(multiRegionProperties(), other.multiRegionProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateClusterRequest").add("Identifier", identifier())
                .add("DeletionProtectionEnabled", deletionProtectionEnabled()).add("KmsEncryptionKey", kmsEncryptionKey())
                .add("ClientToken", clientToken()).add("MultiRegionProperties", multiRegionProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "deletionProtectionEnabled":
            return Optional.ofNullable(clazz.cast(deletionProtectionEnabled()));
        case "kmsEncryptionKey":
            return Optional.ofNullable(clazz.cast(kmsEncryptionKey()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "multiRegionProperties":
            return Optional.ofNullable(clazz.cast(multiRegionProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("deletionProtectionEnabled", DELETION_PROTECTION_ENABLED_FIELD);
        map.put("kmsEncryptionKey", KMS_ENCRYPTION_KEY_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("multiRegionProperties", MULTI_REGION_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterRequest, T> g) {
        return obj -> g.apply((UpdateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DsqlRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateClusterRequest> {
        /**
         * <p>
         * The ID of the cluster you want to update.
         * </p>
         * 
         * @param identifier
         *        The ID of the cluster you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * Specifies whether to enable deletion protection in your cluster.
         * </p>
         * 
         * @param deletionProtectionEnabled
         *        Specifies whether to enable deletion protection in your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled);

        /**
         * <p>
         * The KMS key that encrypts and protects the data on your cluster. You can specify the ARN, ID, or alias of an
         * existing key or have Amazon Web Services create a default key for you.
         * </p>
         * 
         * @param kmsEncryptionKey
         *        The KMS key that encrypts and protects the data on your cluster. You can specify the ARN, ID, or alias
         *        of an existing key or have Amazon Web Services create a default key for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncryptionKey(String kmsEncryptionKey);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully. The subsequent retries with the same client token return the result from the original
         * successful request and they have no additional effect.
         * </p>
         * <p>
         * If you don't specify a client token, the Amazon Web Services SDK automatically generates one.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully. The subsequent retries with the same client token return the
         *        result from the original successful request and they have no additional effect.</p>
         *        <p>
         *        If you don't specify a client token, the Amazon Web Services SDK automatically generates one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The new multi-Region cluster configuration settings to be applied during an update operation.
         * </p>
         * 
         * @param multiRegionProperties
         *        The new multi-Region cluster configuration settings to be applied during an update operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionProperties(MultiRegionProperties multiRegionProperties);

        /**
         * <p>
         * The new multi-Region cluster configuration settings to be applied during an update operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link MultiRegionProperties.Builder} avoiding
         * the need to create one manually via {@link MultiRegionProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultiRegionProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #multiRegionProperties(MultiRegionProperties)}.
         * 
         * @param multiRegionProperties
         *        a consumer that will call methods on {@link MultiRegionProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiRegionProperties(MultiRegionProperties)
         */
        default Builder multiRegionProperties(Consumer<MultiRegionProperties.Builder> multiRegionProperties) {
            return multiRegionProperties(MultiRegionProperties.builder().applyMutation(multiRegionProperties).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DsqlRequest.BuilderImpl implements Builder {
        private String identifier;

        private Boolean deletionProtectionEnabled;

        private String kmsEncryptionKey;

        private String clientToken;

        private MultiRegionProperties multiRegionProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterRequest model) {
            super(model);
            identifier(model.identifier);
            deletionProtectionEnabled(model.deletionProtectionEnabled);
            kmsEncryptionKey(model.kmsEncryptionKey);
            clientToken(model.clientToken);
            multiRegionProperties(model.multiRegionProperties);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        public final String getKmsEncryptionKey() {
            return kmsEncryptionKey;
        }

        public final void setKmsEncryptionKey(String kmsEncryptionKey) {
            this.kmsEncryptionKey = kmsEncryptionKey;
        }

        @Override
        public final Builder kmsEncryptionKey(String kmsEncryptionKey) {
            this.kmsEncryptionKey = kmsEncryptionKey;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final MultiRegionProperties.Builder getMultiRegionProperties() {
            return multiRegionProperties != null ? multiRegionProperties.toBuilder() : null;
        }

        public final void setMultiRegionProperties(MultiRegionProperties.BuilderImpl multiRegionProperties) {
            this.multiRegionProperties = multiRegionProperties != null ? multiRegionProperties.build() : null;
        }

        @Override
        public final Builder multiRegionProperties(MultiRegionProperties multiRegionProperties) {
            this.multiRegionProperties = multiRegionProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterRequest build() {
            return new UpdateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
