/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.AttributeValues;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Expression;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Key;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
public abstract class QueryConditional {
    private static final Function<String, String> EXPRESSION_KEY_MAPPER = key -> "#AMZN_MAPPED_" + Utils.cleanAttributeName(key);
    private static final Function<String, String> EXPRESSION_VALUE_KEY_MAPPER = key -> ":AMZN_MAPPED_" + Utils.cleanAttributeName(key);
    private static final Function<String, String> EXPRESSION_OTHER_VALUE_KEY_MAPPER = key -> ":AMZN_MAPPED_" + Utils.cleanAttributeName(key) + "2";

    public static QueryConditional equalTo(Key key) {
        return new EqualToConditional(key);
    }

    public static QueryConditional greaterThan(Key key) {
        return new SingleKeyItemConditional(key, ">");
    }

    public static QueryConditional greaterThanOrEqualTo(Key key) {
        return new SingleKeyItemConditional(key, ">=");
    }

    public static QueryConditional lessThan(Key key) {
        return new SingleKeyItemConditional(key, "<");
    }

    public static QueryConditional lessThanOrEqualTo(Key key) {
        return new SingleKeyItemConditional(key, "<=");
    }

    public static QueryConditional between(Key key1, Key key2) {
        return new BetweenConditional(key1, key2);
    }

    public static QueryConditional beginsWith(Key key) {
        return new BeginsWithConditional(key);
    }

    public abstract Expression getExpression(TableSchema<?> var1, String var2);

    private static class BetweenConditional
    extends QueryConditional {
        private final Key key1;
        private final Key key2;

        private BetweenConditional(Key key1, Key key2) {
            this.key1 = key1;
            this.key2 = key2;
        }

        @Override
        public Expression getExpression(TableSchema<?> tableSchema, String indexName) {
            ExpressionParameters expressionParameters1 = ExpressionParameters.from(this.key1, tableSchema, indexName);
            ExpressionParameters expressionParameters2 = ExpressionParameters.from(this.key2, tableSchema, indexName);
            if (expressionParameters1.getSortValue().equals((Object)AttributeValues.nullAttributeValue()) || expressionParameters2.getSortValue().equals((Object)AttributeValues.nullAttributeValue())) {
                throw new IllegalArgumentException("Attempt to query using a 'between' condition operator where one of the items has a null sort key.");
            }
            String partitionKeyToken = (String)EXPRESSION_KEY_MAPPER.apply(expressionParameters1.getPartitionKey());
            String partitionValueToken = (String)EXPRESSION_VALUE_KEY_MAPPER.apply(expressionParameters1.getPartitionKey());
            String sortKeyToken = (String)EXPRESSION_KEY_MAPPER.apply(expressionParameters1.getSortKey());
            String sortKeyValueToken1 = (String)EXPRESSION_VALUE_KEY_MAPPER.apply(expressionParameters1.getSortKey());
            String sortKeyValueToken2 = (String)EXPRESSION_OTHER_VALUE_KEY_MAPPER.apply(expressionParameters2.getSortKey());
            String queryExpression = String.format("%s = %s AND %s BETWEEN %s AND %s", partitionKeyToken, partitionValueToken, sortKeyToken, sortKeyValueToken1, sortKeyValueToken2);
            HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
            expressionAttributeValues.put(partitionValueToken, expressionParameters1.getPartitionValue());
            expressionAttributeValues.put(sortKeyValueToken1, expressionParameters1.getSortValue());
            expressionAttributeValues.put(sortKeyValueToken2, expressionParameters2.getSortValue());
            HashMap<String, String> expressionAttributeNames = new HashMap<String, String>();
            expressionAttributeNames.put(partitionKeyToken, expressionParameters1.getPartitionKey());
            expressionAttributeNames.put(sortKeyToken, expressionParameters1.getSortKey());
            return Expression.builder().expression(queryExpression).expressionValues(Collections.unmodifiableMap(expressionAttributeValues)).expressionNames(expressionAttributeNames).build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BetweenConditional that = (BetweenConditional)o;
            if (this.key1 != null ? !this.key1.equals(that.key1) : that.key1 != null) {
                return false;
            }
            return this.key2 != null ? this.key2.equals(that.key2) : that.key2 == null;
        }

        public int hashCode() {
            int result = this.key1 != null ? this.key1.hashCode() : 0;
            result = 31 * result + (this.key2 != null ? this.key2.hashCode() : 0);
            return result;
        }
    }

    private static class BeginsWithConditional
    extends QueryConditional {
        private final Key key;

        private BeginsWithConditional(Key key) {
            this.key = key;
        }

        @Override
        public Expression getExpression(TableSchema<?> tableSchema, String indexName) {
            ExpressionParameters expressionParameters = ExpressionParameters.from(this.key, tableSchema, indexName);
            if (expressionParameters.getSortValue().equals((Object)AttributeValues.nullAttributeValue())) {
                throw new IllegalArgumentException("Attempt to query using a 'beginsWith' condition operator against a null sort key.");
            }
            if (expressionParameters.getSortValue().n() != null) {
                throw new IllegalArgumentException("Attempt to query using a 'beginsWith' condition operator against a numeric sort key.");
            }
            String partitionKeyToken = (String)EXPRESSION_KEY_MAPPER.apply(expressionParameters.getPartitionKey());
            String partitionValueToken = (String)EXPRESSION_VALUE_KEY_MAPPER.apply(expressionParameters.getPartitionKey());
            String sortKeyToken = (String)EXPRESSION_KEY_MAPPER.apply(expressionParameters.getSortKey());
            String sortValueToken = (String)EXPRESSION_VALUE_KEY_MAPPER.apply(expressionParameters.getSortKey());
            String queryExpression = String.format("%s = %s AND begins_with ( %s, %s )", partitionKeyToken, partitionValueToken, sortKeyToken, sortValueToken);
            HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
            expressionAttributeValues.put(partitionValueToken, expressionParameters.getPartitionValue());
            expressionAttributeValues.put(sortValueToken, expressionParameters.getSortValue());
            HashMap<String, String> expressionAttributeNames = new HashMap<String, String>();
            expressionAttributeNames.put(partitionKeyToken, expressionParameters.getPartitionKey());
            expressionAttributeNames.put(sortKeyToken, expressionParameters.getSortKey());
            return Expression.builder().expression(queryExpression).expressionValues(Collections.unmodifiableMap(expressionAttributeValues)).expressionNames(expressionAttributeNames).build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BeginsWithConditional that = (BeginsWithConditional)o;
            return this.key != null ? this.key.equals(that.key) : that.key == null;
        }

        public int hashCode() {
            return this.key != null ? this.key.hashCode() : 0;
        }
    }

    private static class SingleKeyItemConditional
    extends QueryConditional {
        private final Key key;
        private final String operator;

        private SingleKeyItemConditional(Key key, String operator) {
            this.key = key;
            this.operator = operator;
        }

        @Override
        public Expression getExpression(TableSchema<?> tableSchema, String indexName) {
            ExpressionParameters expressionParameters = ExpressionParameters.from(this.key, tableSchema, indexName);
            if (expressionParameters.getSortValue().equals((Object)AttributeValues.nullAttributeValue())) {
                throw new IllegalArgumentException("Attempt to query using a relative condition operator against a null sort key.");
            }
            String partitionKeyToken = (String)EXPRESSION_KEY_MAPPER.apply(expressionParameters.getPartitionKey());
            String partitionValueToken = (String)EXPRESSION_VALUE_KEY_MAPPER.apply(expressionParameters.getPartitionKey());
            String sortKeyToken = (String)EXPRESSION_KEY_MAPPER.apply(expressionParameters.getSortKey());
            String sortValueToken = (String)EXPRESSION_VALUE_KEY_MAPPER.apply(expressionParameters.getSortKey());
            String queryExpression = String.format("%s = %s AND %s %s %s", partitionKeyToken, partitionValueToken, sortKeyToken, this.operator, sortValueToken);
            HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
            expressionAttributeValues.put(partitionValueToken, expressionParameters.getPartitionValue());
            expressionAttributeValues.put(sortValueToken, expressionParameters.getSortValue());
            HashMap<String, String> expressionAttributeNames = new HashMap<String, String>();
            expressionAttributeNames.put(partitionKeyToken, expressionParameters.getPartitionKey());
            expressionAttributeNames.put(sortKeyToken, expressionParameters.getSortKey());
            return Expression.builder().expression(queryExpression).expressionValues(expressionAttributeValues).expressionNames(expressionAttributeNames).build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleKeyItemConditional that = (SingleKeyItemConditional)o;
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
                return false;
            }
            return this.operator != null ? this.operator.equals(that.operator) : that.operator == null;
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
            return result;
        }
    }

    private static class ExpressionParameters {
        private final String partitionKey;
        private final AttributeValue partitionValue;
        private final String sortKey;
        private final AttributeValue sortValue;

        private ExpressionParameters(String partitionKey, AttributeValue partitionValue, String sortKey, AttributeValue sortValue) {
            this.partitionKey = partitionKey;
            this.partitionValue = partitionValue;
            this.sortKey = sortKey;
            this.sortValue = sortValue;
        }

        private static ExpressionParameters from(Key key, TableSchema tableSchema, String indexName) {
            String partitionKey = tableSchema.getTableMetadata().getIndexPartitionKey(indexName);
            AttributeValue partitionValue = key.getPartitionKeyValue();
            String sortKey = tableSchema.getTableMetadata().getIndexSortKey(indexName).orElseThrow(() -> new IllegalArgumentException("A query conditional requires a sort key to be present on the table or index being queried, yet none have been defined in the model"));
            AttributeValue sortValue = key.getSortKeyValue().orElseThrow(() -> new IllegalArgumentException("A query conditional requires a sort key to compare with, however one was not provided."));
            return new ExpressionParameters(partitionKey, partitionValue, sortKey, sortValue);
        }

        String getPartitionKey() {
            return this.partitionKey;
        }

        AttributeValue getPartitionValue() {
            return this.partitionValue;
        }

        String getSortKey() {
            return this.sortKey;
        }

        AttributeValue getSortValue() {
            return this.sortValue;
        }
    }

    private static class EqualToConditional
    extends QueryConditional {
        private final Key key;

        private EqualToConditional(Key key) {
            this.key = key;
        }

        @Override
        public Expression getExpression(TableSchema<?> tableSchema, String indexName) {
            String partitionKey = tableSchema.getTableMetadata().getIndexPartitionKey(indexName);
            AttributeValue partitionValue = this.key.getPartitionKeyValue();
            if (partitionValue == null || partitionValue.equals((Object)AttributeValues.nullAttributeValue())) {
                throw new IllegalArgumentException("Partition key must be a valid scalar value to execute a query against. The provided partition key was set to null.");
            }
            Optional<AttributeValue> sortKeyValue = this.key.getSortKeyValue();
            if (sortKeyValue.isPresent()) {
                Optional<String> sortKey = tableSchema.getTableMetadata().getIndexSortKey(indexName);
                if (!sortKey.isPresent()) {
                    throw new IllegalArgumentException("A sort key was supplied as part of a query conditional against an index that does not support a sort key. Index: " + indexName);
                }
                return this.getPartitionAndSortExpression(partitionKey, sortKey.get(), partitionValue, sortKeyValue.get());
            }
            return this.getPartitionOnlyExpression(partitionKey, partitionValue);
        }

        private Expression getPartitionOnlyExpression(String partitionKey, AttributeValue partitionValue) {
            String partitionKeyToken = (String)EXPRESSION_KEY_MAPPER.apply(partitionKey);
            String partitionKeyValueToken = (String)EXPRESSION_VALUE_KEY_MAPPER.apply(partitionKey);
            String queryExpression = String.format("%s = %s", partitionKeyToken, partitionKeyValueToken);
            return Expression.builder().expression(queryExpression).expressionNames(Collections.singletonMap(partitionKeyToken, partitionKey)).expressionValues(Collections.singletonMap(partitionKeyValueToken, partitionValue)).build();
        }

        private Expression getPartitionAndSortExpression(String partitionKey, String sortKey, AttributeValue partitionValue, AttributeValue sortKeyValue) {
            if (sortKeyValue.equals((Object)AttributeValues.nullAttributeValue())) {
                return this.getPartitionOnlyExpression(partitionKey, partitionValue);
            }
            String partitionKeyToken = (String)EXPRESSION_KEY_MAPPER.apply(partitionKey);
            String partitionKeyValueToken = (String)EXPRESSION_VALUE_KEY_MAPPER.apply(partitionKey);
            String sortKeyToken = (String)EXPRESSION_KEY_MAPPER.apply(sortKey);
            String sortKeyValueToken = (String)EXPRESSION_VALUE_KEY_MAPPER.apply(sortKey);
            String queryExpression = String.format("%s = %s AND %s = %s", partitionKeyToken, partitionKeyValueToken, sortKeyToken, sortKeyValueToken);
            HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
            expressionAttributeValues.put(partitionKeyValueToken, partitionValue);
            expressionAttributeValues.put(sortKeyValueToken, sortKeyValue);
            HashMap<String, String> expressionAttributeNames = new HashMap<String, String>();
            expressionAttributeNames.put(partitionKeyToken, partitionKey);
            expressionAttributeNames.put(sortKeyToken, sortKey);
            return Expression.builder().expression(queryExpression).expressionValues(expressionAttributeValues).expressionNames(expressionAttributeNames).build();
        }
    }
}

