/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.AttributeValues;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Expression;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TransactableWriteOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.extensions.WriteModification;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;
import software.amazon.awssdk.services.dynamodb.model.Update;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;

@SdkPublicApi
public class UpdateItem<T>
implements TableOperation<T, UpdateItemRequest, UpdateItemResponse, T>,
TransactableWriteOperation<T> {
    private static final Function<String, String> EXPRESSION_VALUE_KEY_MAPPER = key -> ":AMZN_MAPPED_" + Utils.cleanAttributeName(key);
    private static final Function<String, String> EXPRESSION_KEY_MAPPER = key -> "#AMZN_MAPPED_" + Utils.cleanAttributeName(key);
    private final T item;
    private final Boolean ignoreNulls;
    private final Expression conditionExpression;

    private UpdateItem(Builder<T> b) {
        this.item = ((Builder)b).item;
        this.ignoreNulls = ((Builder)b).ignoreNulls;
        this.conditionExpression = ((Builder)b).conditionExpression;
    }

    public static <T> UpdateItem<T> of(T item) {
        return UpdateItem.builder().item(item).build();
    }

    public static GenericBuilder builder() {
        return new GenericBuilder();
    }

    public Builder<T> toBuilder() {
        return new Builder<T>().item(this.item).ignoreNulls(this.ignoreNulls);
    }

    @Override
    public UpdateItemRequest generateRequest(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        WriteModification transformation;
        if (!TableMetadata.primaryIndexName().equals(operationContext.indexName())) {
            throw new IllegalArgumentException("UpdateItem cannot be executed against a secondary index.");
        }
        Map<String, AttributeValue> itemMap = tableSchema.itemToMap(this.item, Boolean.TRUE.equals(this.ignoreNulls));
        TableMetadata tableMetadata = tableSchema.tableMetadata();
        WriteModification writeModification = transformation = mapperExtension != null ? mapperExtension.beforeWrite(itemMap, operationContext, tableMetadata) : null;
        if (transformation != null && transformation.transformedItem() != null) {
            itemMap = transformation.transformedItem();
        }
        Collection<String> primaryKeys = tableSchema.tableMetadata().primaryKeys();
        Map<String, AttributeValue> filteredAttributeValues = itemMap.entrySet().stream().filter(entry -> !primaryKeys.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, AttributeValue> keyAttributeValues = itemMap.entrySet().stream().filter(entry -> primaryKeys.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        UpdateItemRequest.Builder baseUpdateItemRequest = UpdateItemRequest.builder().tableName(operationContext.tableName()).key(keyAttributeValues).returnValues(ReturnValue.ALL_NEW);
        Map<String, String> expressionNames = null;
        Map<String, AttributeValue> expressionValues = null;
        String conditionExpressionString = null;
        if (!filteredAttributeValues.isEmpty()) {
            Expression fullUpdateExpression = UpdateItem.generateUpdateExpression(filteredAttributeValues);
            expressionNames = fullUpdateExpression.expressionNames();
            expressionValues = fullUpdateExpression.expressionValues();
            baseUpdateItemRequest = baseUpdateItemRequest.updateExpression(fullUpdateExpression.expression());
        }
        if (transformation != null && transformation.additionalConditionalExpression() != null) {
            expressionNames = Expression.coalesceNames(expressionNames, transformation.additionalConditionalExpression().expressionNames());
            expressionValues = Expression.coalesceValues(expressionValues, transformation.additionalConditionalExpression().expressionValues());
            conditionExpressionString = transformation.additionalConditionalExpression().expression();
        }
        if (this.conditionExpression != null) {
            expressionNames = Expression.coalesceNames(expressionNames, this.conditionExpression.expressionNames());
            expressionValues = Expression.coalesceValues(expressionValues, this.conditionExpression.expressionValues());
            conditionExpressionString = Expression.coalesceExpressions(conditionExpressionString, this.conditionExpression.expression(), " AND ");
        }
        if (expressionNames != null && !expressionNames.isEmpty()) {
            baseUpdateItemRequest = baseUpdateItemRequest.expressionAttributeNames(expressionNames);
        }
        if (expressionValues != null && !expressionValues.isEmpty()) {
            baseUpdateItemRequest = baseUpdateItemRequest.expressionAttributeValues(expressionValues);
        }
        return (UpdateItemRequest)baseUpdateItemRequest.conditionExpression(conditionExpressionString).build();
    }

    @Override
    public T transformResponse(UpdateItemResponse response, TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        try {
            return Utils.readAndTransformSingleItem(response.attributes(), tableSchema, operationContext, mapperExtension);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Unable to read the new item returned by UpdateItem after the update occurred. Rollbacks are not supported by this operation, therefore the record may no longer be readable using this model.", e);
        }
    }

    @Override
    public Function<UpdateItemRequest, UpdateItemResponse> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).updateItem(arg_0);
    }

    @Override
    public TransactWriteItem generateTransactWriteItem(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        UpdateItemRequest updateItemRequest = this.generateRequest(tableSchema, operationContext, mapperExtension);
        Update update = (Update)Update.builder().key(updateItemRequest.key()).tableName(updateItemRequest.tableName()).updateExpression(updateItemRequest.updateExpression()).conditionExpression(updateItemRequest.conditionExpression()).expressionAttributeValues(updateItemRequest.expressionAttributeValues()).expressionAttributeNames(updateItemRequest.expressionAttributeNames()).build();
        return (TransactWriteItem)TransactWriteItem.builder().update(update).build();
    }

    public T item() {
        return this.item;
    }

    public Boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateItem that = (UpdateItem)o;
        if (this.item != null ? !this.item.equals(that.item) : that.item != null) {
            return false;
        }
        return this.ignoreNulls != null ? this.ignoreNulls.equals(that.ignoreNulls) : that.ignoreNulls == null;
    }

    public int hashCode() {
        int result = this.item != null ? this.item.hashCode() : 0;
        result = 31 * result + (this.ignoreNulls != null ? this.ignoreNulls.hashCode() : 0);
        return result;
    }

    private static Expression generateUpdateExpression(Map<String, AttributeValue> attributeValuesToUpdate) {
        ArrayList updateSetActions = new ArrayList();
        ArrayList updateRemoveActions = new ArrayList();
        attributeValuesToUpdate.forEach((key, value) -> {
            if (!AttributeValues.isNullAttributeValue(value)) {
                updateSetActions.add(EXPRESSION_KEY_MAPPER.apply((String)key) + " = " + EXPRESSION_VALUE_KEY_MAPPER.apply((String)key));
            } else {
                updateRemoveActions.add(EXPRESSION_KEY_MAPPER.apply((String)key));
            }
        });
        ArrayList<String> updateActions = new ArrayList<String>();
        if (!updateSetActions.isEmpty()) {
            updateActions.add("SET " + String.join((CharSequence)", ", updateSetActions));
        }
        if (!updateRemoveActions.isEmpty()) {
            updateActions.add("REMOVE " + String.join((CharSequence)", ", updateRemoveActions));
        }
        String updateExpression = String.join((CharSequence)" ", updateActions);
        Map<String, AttributeValue> expressionAttributeValues = attributeValuesToUpdate.entrySet().stream().filter(entry -> !AttributeValues.isNullAttributeValue((AttributeValue)entry.getValue())).collect(Collectors.toMap(entry -> EXPRESSION_VALUE_KEY_MAPPER.apply((String)entry.getKey()), Map.Entry::getValue));
        Map<String, String> expressionAttributeNames = attributeValuesToUpdate.keySet().stream().collect(Collectors.toMap(EXPRESSION_KEY_MAPPER, key -> key));
        return Expression.builder().expression(updateExpression).expressionValues(Collections.unmodifiableMap(expressionAttributeValues)).expressionNames(expressionAttributeNames).build();
    }

    public static final class Builder<T> {
        private T item;
        private Boolean ignoreNulls;
        private Expression conditionExpression;

        private Builder() {
        }

        public Builder<T> ignoreNulls(Boolean ignoreNulls) {
            this.ignoreNulls = ignoreNulls;
            return this;
        }

        public Builder<T> conditionExpression(Expression conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public Builder<T> item(T item) {
            this.item = item;
            return this;
        }

        public UpdateItem<T> build() {
            return new UpdateItem(this);
        }
    }

    public static class GenericBuilder {
        private Boolean ignoreNulls;
        private Expression conditionExpression;

        private GenericBuilder() {
        }

        public GenericBuilder ignoreNulls(Boolean ignoreNulls) {
            this.ignoreNulls = ignoreNulls;
            return this;
        }

        public GenericBuilder conditionExpression(Expression conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public <T> Builder<T> item(T item) {
            return new Builder<T>().item(item).ignoreNulls(this.ignoreNulls).conditionExpression(this.conditionExpression);
        }

        public UpdateItem<?> build() {
            throw new UnsupportedOperationException("Cannot construct a UpdateItem operation without an item to put.");
        }
    }
}

