/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTableResource;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TransactableReadOperation;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItem;

@SdkPublicApi
public class ReadTransaction<T> {
    private final MappedTableResource<T> mappedTableResource;
    private final TransactableReadOperation<T> readOperation;

    private ReadTransaction(MappedTableResource<T> mappedTableResource, TransactableReadOperation<T> readOperation) {
        this.mappedTableResource = mappedTableResource;
        this.readOperation = readOperation;
    }

    public static <T> ReadTransaction<T> of(MappedTableResource<T> mappedTableResource, TransactableReadOperation<T> readOperation) {
        return new ReadTransaction<T>(mappedTableResource, readOperation);
    }

    public MappedTableResource<T> mappedTableResource() {
        return this.mappedTableResource;
    }

    public TransactableReadOperation<T> readOperation() {
        return this.readOperation;
    }

    TransactGetItem generateTransactGetItem() {
        return this.readOperation.generateTransactGetItem(this.mappedTableResource.tableSchema(), OperationContext.of(this.mappedTableResource.tableName()), this.mappedTableResource.mapperExtension());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadTransaction that = (ReadTransaction)o;
        if (this.mappedTableResource != null ? !this.mappedTableResource.equals(that.mappedTableResource) : that.mappedTableResource != null) {
            return false;
        }
        return this.readOperation != null ? this.readOperation.equals(that.readOperation) : that.readOperation == null;
    }

    public int hashCode() {
        int result = this.mappedTableResource != null ? this.mappedTableResource.hashCode() : 0;
        result = 31 * result + (this.readOperation != null ? this.readOperation.hashCode() : 0);
        return result;
    }
}

