/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTableResource;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TransactableWriteOperation;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;

@SdkPublicApi
public class WriteTransaction<T> {
    private final MappedTableResource<T> mappedTableResource;
    private final TransactableWriteOperation<T> writeOperation;

    private WriteTransaction(MappedTableResource<T> mappedTableResource, TransactableWriteOperation<T> writeOperation) {
        this.mappedTableResource = mappedTableResource;
        this.writeOperation = writeOperation;
    }

    public static <T> WriteTransaction<T> of(MappedTableResource<T> mappedTableResource, TransactableWriteOperation<T> writeOperation) {
        return new WriteTransaction<T>(mappedTableResource, writeOperation);
    }

    public MappedTableResource<T> mappedTableResource() {
        return this.mappedTableResource;
    }

    public TransactableWriteOperation<T> writeOperation() {
        return this.writeOperation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteTransaction that = (WriteTransaction)o;
        if (this.mappedTableResource != null ? !this.mappedTableResource.equals(that.mappedTableResource) : that.mappedTableResource != null) {
            return false;
        }
        return this.writeOperation != null ? this.writeOperation.equals(that.writeOperation) : that.writeOperation == null;
    }

    public int hashCode() {
        int result = this.mappedTableResource != null ? this.mappedTableResource.hashCode() : 0;
        result = 31 * result + (this.writeOperation != null ? this.writeOperation.hashCode() : 0);
        return result;
    }

    TransactWriteItem generateRequest() {
        return this.writeOperation.generateTransactWriteItem(this.mappedTableResource.tableSchema(), OperationContext.of(this.mappedTableResource.tableName()), this.mappedTableResource.mapperExtension());
    }
}

