/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.DatabaseOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.ReadTransaction;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.UnmappedItem;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse;

@SdkPublicApi
public class TransactGetItems
implements DatabaseOperation<TransactGetItemsRequest, TransactGetItemsResponse, List<UnmappedItem>> {
    private final List<ReadTransaction> readTransactions;

    private TransactGetItems(List<ReadTransaction> readTransactions) {
        this.readTransactions = readTransactions;
    }

    public static TransactGetItems create(List<ReadTransaction> transactGetRequests) {
        return new TransactGetItems(transactGetRequests);
    }

    public static TransactGetItems create(ReadTransaction ... readTransactions) {
        return new TransactGetItems(Arrays.asList(readTransactions));
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().readTransactions(this.readTransactions);
    }

    @Override
    public TransactGetItemsRequest generateRequest(MapperExtension mapperExtension) {
        return (TransactGetItemsRequest)TransactGetItemsRequest.builder().transactItems((Collection)this.readTransactions.stream().map(ReadTransaction::generateTransactGetItem).collect(Collectors.toList())).build();
    }

    @Override
    public Function<TransactGetItemsRequest, TransactGetItemsResponse> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).transactGetItems(arg_0);
    }

    @Override
    public Function<TransactGetItemsRequest, CompletableFuture<TransactGetItemsResponse>> asyncServiceCall(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return arg_0 -> ((DynamoDbAsyncClient)dynamoDbAsyncClient).transactGetItems(arg_0);
    }

    @Override
    public List<UnmappedItem> transformResponse(TransactGetItemsResponse response, MapperExtension mapperExtension) {
        return response.responses().stream().map(r -> r == null ? null : UnmappedItem.create(r.item())).collect(Collectors.toList());
    }

    public List<ReadTransaction> readTransactions() {
        return this.readTransactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactGetItems that = (TransactGetItems)o;
        return this.readTransactions != null ? this.readTransactions.equals(that.readTransactions) : that.readTransactions == null;
    }

    public int hashCode() {
        return this.readTransactions != null ? this.readTransactions.hashCode() : 0;
    }

    public static final class Builder {
        private List<ReadTransaction> readTransactions;

        private Builder() {
        }

        public Builder readTransactions(List<ReadTransaction> readTransactions) {
            this.readTransactions = readTransactions;
            return this;
        }

        public TransactGetItems build() {
            return new TransactGetItems(this.readTransactions);
        }
    }
}

