/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.DatabaseOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.WriteTransaction;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse;

@SdkPublicApi
public class TransactWriteItems
implements DatabaseOperation<TransactWriteItemsRequest, TransactWriteItemsResponse, Void> {
    private final List<WriteTransaction> writeTransactions;

    private TransactWriteItems(List<WriteTransaction> writeTransactions) {
        this.writeTransactions = writeTransactions;
    }

    public static TransactWriteItems create(List<WriteTransaction> writeTransactions) {
        return new TransactWriteItems(writeTransactions);
    }

    public static TransactWriteItems create(WriteTransaction ... writeTransactions) {
        return new TransactWriteItems(Arrays.asList(writeTransactions));
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().writeTransactions(this.writeTransactions);
    }

    @Override
    public TransactWriteItemsRequest generateRequest(MapperExtension mapperExtension) {
        List requestItems = this.writeTransactions.stream().map(WriteTransaction::generateRequest).collect(Collectors.toList());
        return (TransactWriteItemsRequest)TransactWriteItemsRequest.builder().transactItems(requestItems).build();
    }

    @Override
    public Void transformResponse(TransactWriteItemsResponse response, MapperExtension mapperExtension) {
        return null;
    }

    @Override
    public Function<TransactWriteItemsRequest, TransactWriteItemsResponse> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).transactWriteItems(arg_0);
    }

    @Override
    public Function<TransactWriteItemsRequest, CompletableFuture<TransactWriteItemsResponse>> asyncServiceCall(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return arg_0 -> ((DynamoDbAsyncClient)dynamoDbAsyncClient).transactWriteItems(arg_0);
    }

    public List<WriteTransaction> writeTransactions() {
        return this.writeTransactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactWriteItems that = (TransactWriteItems)o;
        return this.writeTransactions != null ? this.writeTransactions.equals(that.writeTransactions) : that.writeTransactions == null;
    }

    public int hashCode() {
        return this.writeTransactions != null ? this.writeTransactions.hashCode() : 0;
    }

    public static final class Builder {
        private List<WriteTransaction> writeTransactions;

        private Builder() {
        }

        public Builder writeTransactions(List<WriteTransaction> writeTransactions) {
            this.writeTransactions = writeTransactions;
            return this;
        }

        public TransactWriteItems build() {
            return new TransactWriteItems(this.writeTransactions);
        }
    }
}

