/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.staticmapper;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.staticmapper.Attribute;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.staticmapper.AttributeType;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.staticmapper.AttributeTypes;

@SdkPublicApi
public final class Attributes {
    private Attributes() {
    }

    public static <T> Attribute.AttributeSupplier<T> binaryAttribute(String attributeName, Function<T, ByteBuffer> getAttributeMethod, BiConsumer<T, ByteBuffer> updateItemMethod) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.binaryType());
    }

    public static <T> Attribute.AttributeSupplier<T> binarySetAttribute(String attributeName, Function<T, Set<ByteBuffer>> getAttributeMethod, BiConsumer<T, Set<ByteBuffer>> updateItemMethod) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.binarySetType());
    }

    public static <T> Attribute.AttributeSupplier<T> boolAttribute(String attributeName, Function<T, Boolean> getAttributeMethod, BiConsumer<T, Boolean> updateItemMethod) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.booleanType());
    }

    public static <T> Attribute.AttributeSupplier<T> stringAttribute(String attributeName, Function<T, String> getAttributeMethod, BiConsumer<T, String> updateItemMethod) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.stringType());
    }

    public static <T> Attribute.AttributeSupplier<T> stringSetAttribute(String attributeName, Function<T, Set<String>> getAttributeMethod, BiConsumer<T, Set<String>> updateItemMethod) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.stringSetType());
    }

    public static <T> Attribute.AttributeSupplier<T> integerNumberAttribute(String attributeName, Function<T, Integer> getAttributeMethod, BiConsumer<T, Integer> updateItemMethod) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.integerNumberType());
    }

    public static <T> Attribute.AttributeSupplier<T> longNumberAttribute(String attributeName, Function<T, Long> getAttributeMethod, BiConsumer<T, Long> updateItemMethod) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.longNumberType());
    }

    public static <T> Attribute.AttributeSupplier<T> shortNumberAttribute(String attributeName, Function<T, Short> getAttributeMethod, BiConsumer<T, Short> updateItemMethod) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.shortNumberType());
    }

    public static <T> Attribute.AttributeSupplier<T> doubleNumberAttribute(String attributeName, Function<T, Double> getAttributeMethod, BiConsumer<T, Double> updateItemMethod) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.doubleNumberType());
    }

    public static <T> Attribute.AttributeSupplier<T> floatNumberAttribute(String attributeName, Function<T, Float> getAttributeMethod, BiConsumer<T, Float> updateItemMethod) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.floatNumberType());
    }

    public static <T> Attribute.AttributeSupplier<T> byteNumberAttribute(String attributeName, Function<T, Byte> getAttributeMethod, BiConsumer<T, Byte> updateItemMethod) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.byteNumberType());
    }

    public static <T> Attribute.AttributeSupplier<T> integerSetAttribute(String attributeName, Function<T, Set<Integer>> getAttributeMethod, BiConsumer<T, Set<Integer>> updateItemMethod) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.integerNumberSetType());
    }

    public static <T> Attribute.AttributeSupplier<T> longSetAttribute(String attributeName, Function<T, Set<Long>> getAttributeMethod, BiConsumer<T, Set<Long>> updateItemMethod) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.longNumberSetType());
    }

    public static <T> Attribute.AttributeSupplier<T> shortSetAttribute(String attributeName, Function<T, Set<Short>> getAttributeMethod, BiConsumer<T, Set<Short>> updateItemMethod) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.shortNumberSetType());
    }

    public static <T> Attribute.AttributeSupplier<T> doubleSetAttribute(String attributeName, Function<T, Set<Double>> getAttributeMethod, BiConsumer<T, Set<Double>> updateItemMethod) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.doubleNumberSetType());
    }

    public static <T> Attribute.AttributeSupplier<T> floatSetAttribute(String attributeName, Function<T, Set<Float>> getAttributeMethod, BiConsumer<T, Set<Float>> updateItemMethod) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.floatNumberSetType());
    }

    public static <T> Attribute.AttributeSupplier<T> byteSetAttribute(String attributeName, Function<T, Set<Byte>> getAttributeMethod, BiConsumer<T, Set<Byte>> updateItemMethod) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.byteNumberSetType());
    }

    public static <T, K> Attribute.AttributeSupplier<T> documentMapAttribute(String attributeName, Function<T, K> getAttributeMethod, BiConsumer<T, K> updateItemMethod, TableSchema<K> documentSchema) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.documentMapType(documentSchema));
    }

    public static <T, K> Attribute.AttributeSupplier<T> mapAttribute(String attributeName, Function<T, Map<String, K>> getAttributeMethod, BiConsumer<T, Map<String, K>> updateItemMethod, AttributeType<K> mappedValueType) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.mapType(mappedValueType));
    }

    public static <T, K> Attribute.AttributeSupplier<T> listAttribute(String attributeName, Function<T, List<K>> getAttributeMethod, BiConsumer<T, List<K>> updateItemMethod, AttributeType<K> listElementsType) {
        return Attribute.create(attributeName, getAttributeMethod, updateItemMethod, AttributeTypes.listType(listElementsType));
    }
}

