/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.core;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.DynamoDbTable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Key;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Page;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.DefaultDynamoDbIndex;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.CreateTableEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.DeleteItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.GetItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.PutItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.QueryEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.ScanEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.UpdateItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.CreateTableOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.DeleteItemOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.GetItemOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.PutItemOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.QueryOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.ScanOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.UpdateItemOperation;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkInternalApi
public class DefaultDynamoDbTable<T>
implements DynamoDbTable<T> {
    private final DynamoDbClient dynamoDbClient;
    private final MapperExtension mapperExtension;
    private final TableSchema<T> tableSchema;
    private final String tableName;

    DefaultDynamoDbTable(DynamoDbClient dynamoDbClient, MapperExtension mapperExtension, TableSchema<T> tableSchema, String tableName) {
        this.dynamoDbClient = dynamoDbClient;
        this.mapperExtension = mapperExtension;
        this.tableSchema = tableSchema;
        this.tableName = tableName;
    }

    @Override
    public MapperExtension mapperExtension() {
        return this.mapperExtension;
    }

    @Override
    public TableSchema<T> tableSchema() {
        return this.tableSchema;
    }

    public DynamoDbClient dynamoDbClient() {
        return this.dynamoDbClient;
    }

    @Override
    public String tableName() {
        return this.tableName;
    }

    @Override
    public DefaultDynamoDbIndex<T> index(String indexName) {
        this.tableSchema.tableMetadata().indexPartitionKey(indexName);
        return new DefaultDynamoDbIndex<T>(this.dynamoDbClient, this.mapperExtension, this.tableSchema, this.tableName, indexName);
    }

    @Override
    public Void createTable(CreateTableEnhancedRequest request) {
        CreateTableOperation operation = CreateTableOperation.create(request);
        return (Void)operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.mapperExtension, this.dynamoDbClient);
    }

    @Override
    public Void createTable(Consumer<CreateTableEnhancedRequest.Builder> requestConsumer) {
        CreateTableEnhancedRequest.Builder builder = CreateTableEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.createTable(builder.build());
    }

    @Override
    public Void createTable() {
        return this.createTable(CreateTableEnhancedRequest.builder().build());
    }

    @Override
    public T deleteItem(DeleteItemEnhancedRequest request) {
        DeleteItemOperation operation = DeleteItemOperation.create(request);
        return (T)operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.mapperExtension, this.dynamoDbClient);
    }

    @Override
    public T deleteItem(Consumer<DeleteItemEnhancedRequest.Builder> requestConsumer) {
        DeleteItemEnhancedRequest.Builder builder = DeleteItemEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.deleteItem(builder.build());
    }

    @Override
    public T getItem(GetItemEnhancedRequest request) {
        GetItemOperation operation = GetItemOperation.create(request);
        return (T)operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.mapperExtension, this.dynamoDbClient);
    }

    @Override
    public T getItem(Consumer<GetItemEnhancedRequest.Builder> requestConsumer) {
        GetItemEnhancedRequest.Builder builder = GetItemEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.getItem(builder.build());
    }

    @Override
    public SdkIterable<Page<T>> query(QueryEnhancedRequest request) {
        QueryOperation operation = QueryOperation.create(request);
        return operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.mapperExtension, this.dynamoDbClient);
    }

    @Override
    public SdkIterable<Page<T>> query(Consumer<QueryEnhancedRequest.Builder> requestConsumer) {
        QueryEnhancedRequest.Builder builder = QueryEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.query(builder.build());
    }

    @Override
    public Void putItem(PutItemEnhancedRequest<T> request) {
        PutItemOperation<T> operation = PutItemOperation.create(request);
        return (Void)operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.mapperExtension, this.dynamoDbClient);
    }

    @Override
    public Void putItem(Class<? extends T> itemClass, Consumer<PutItemEnhancedRequest.Builder<T>> requestConsumer) {
        PutItemEnhancedRequest.Builder<T> builder = PutItemEnhancedRequest.builder(itemClass);
        requestConsumer.accept(builder);
        return this.putItem(builder.build());
    }

    @Override
    public SdkIterable<Page<T>> scan(ScanEnhancedRequest request) {
        ScanOperation operation = ScanOperation.create(request);
        return operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.mapperExtension, this.dynamoDbClient);
    }

    @Override
    public SdkIterable<Page<T>> scan(Consumer<ScanEnhancedRequest.Builder> requestConsumer) {
        ScanEnhancedRequest.Builder builder = ScanEnhancedRequest.builder();
        requestConsumer.accept(builder);
        return this.scan(builder.build());
    }

    @Override
    public SdkIterable<Page<T>> scan() {
        return this.scan(ScanEnhancedRequest.builder().build());
    }

    @Override
    public T updateItem(UpdateItemEnhancedRequest<T> request) {
        UpdateItemOperation<T> operation = UpdateItemOperation.create(request);
        return (T)operation.executeOnPrimaryIndex(this.tableSchema, this.tableName, this.mapperExtension, this.dynamoDbClient);
    }

    @Override
    public T updateItem(Class<? extends T> itemClass, Consumer<UpdateItemEnhancedRequest.Builder<T>> requestConsumer) {
        UpdateItemEnhancedRequest.Builder<T> builder = UpdateItemEnhancedRequest.builder(itemClass);
        requestConsumer.accept(builder);
        return this.updateItem(builder.build());
    }

    @Override
    public Key keyFrom(T item) {
        return Utils.createKeyFromItem(item, this.tableSchema, TableMetadata.primaryIndexName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDynamoDbTable that = (DefaultDynamoDbTable)o;
        if (this.dynamoDbClient != null ? !this.dynamoDbClient.equals(that.dynamoDbClient) : that.dynamoDbClient != null) {
            return false;
        }
        if (this.mapperExtension != null ? !this.mapperExtension.equals(that.mapperExtension) : that.mapperExtension != null) {
            return false;
        }
        if (this.tableSchema != null ? !this.tableSchema.equals(that.tableSchema) : that.tableSchema != null) {
            return false;
        }
        return this.tableName != null ? this.tableName.equals(that.tableName) : that.tableName == null;
    }

    public int hashCode() {
        int result = this.dynamoDbClient != null ? this.dynamoDbClient.hashCode() : 0;
        result = 31 * result + (this.mapperExtension != null ? this.mapperExtension.hashCode() : 0);
        result = 31 * result + (this.tableSchema != null ? this.tableSchema.hashCode() : 0);
        result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
        return result;
    }
}

