/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.ReadBatch;

@SdkPublicApi
public final class BatchGetItemEnhancedRequest {
    private final List<ReadBatch> readBatches;

    private BatchGetItemEnhancedRequest(Builder builder) {
        this.readBatches = BatchGetItemEnhancedRequest.getListIfExist(builder.readBatches);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().readBatches(this.readBatches);
    }

    public Collection<ReadBatch> readBatches() {
        return this.readBatches;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchGetItemEnhancedRequest that = (BatchGetItemEnhancedRequest)o;
        return this.readBatches != null ? this.readBatches.equals(that.readBatches) : that.readBatches == null;
    }

    public int hashCode() {
        return this.readBatches != null ? this.readBatches.hashCode() : 0;
    }

    private static List<ReadBatch> getListIfExist(List<ReadBatch> readBatches) {
        return readBatches != null ? Collections.unmodifiableList(readBatches) : null;
    }

    public static final class Builder {
        private List<ReadBatch> readBatches;

        private Builder() {
        }

        public Builder readBatches(Collection<ReadBatch> readBatches) {
            this.readBatches = readBatches != null ? new ArrayList<ReadBatch>(readBatches) : null;
            return this;
        }

        public Builder readBatches(ReadBatch ... readBatches) {
            this.readBatches = Arrays.asList(readBatches);
            return this;
        }

        public Builder addReadBatch(ReadBatch readBatch) {
            if (this.readBatches == null) {
                this.readBatches = new ArrayList<ReadBatch>();
            }
            this.readBatches.add(readBatch);
            return this;
        }

        public BatchGetItemEnhancedRequest build() {
            return new BatchGetItemEnhancedRequest(this);
        }
    }
}

