/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTableResource;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;

@SdkPublicApi
public final class BatchGetResultPage {
    private final BatchGetItemResponse batchGetItemResponse;
    private final MapperExtension mapperExtension;

    private BatchGetResultPage(Builder builder) {
        this.batchGetItemResponse = builder.batchGetItemResponse;
        this.mapperExtension = builder.mapperExtension;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> List<T> getResultsForTable(MappedTableResource<T> mappedTable) {
        List results = this.batchGetItemResponse.responses().getOrDefault(mappedTable.tableName(), Collections.emptyList());
        return results.stream().map(itemMap -> Utils.readAndTransformSingleItem(itemMap, mappedTable.tableSchema(), OperationContext.create(mappedTable.tableName()), this.mapperExtension)).collect(Collectors.toList());
    }

    public static final class Builder {
        private BatchGetItemResponse batchGetItemResponse;
        private MapperExtension mapperExtension;

        private Builder() {
        }

        public Builder batchGetItemResponse(BatchGetItemResponse batchGetItemResponse) {
            this.batchGetItemResponse = batchGetItemResponse;
            return this;
        }

        public Builder mapperExtension(MapperExtension mapperExtension) {
            this.mapperExtension = mapperExtension;
            return this;
        }

        public BatchGetResultPage build() {
            return new BatchGetResultPage(this);
        }
    }
}

