/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.model;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Key;

@SdkPublicApi
public final class GetItemEnhancedRequest {
    private final Key key;
    private final Boolean consistentRead;

    private GetItemEnhancedRequest(Builder builder) {
        this.key = builder.key;
        this.consistentRead = builder.consistentRead;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return GetItemEnhancedRequest.builder().key(this.key).consistentRead(this.consistentRead);
    }

    public Boolean consistentRead() {
        return this.consistentRead;
    }

    public Key key() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetItemEnhancedRequest getItem = (GetItemEnhancedRequest)o;
        if (this.key != null ? !this.key.equals(getItem.key) : getItem.key != null) {
            return false;
        }
        return this.consistentRead != null ? this.consistentRead.equals(getItem.consistentRead) : getItem.consistentRead == null;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.consistentRead != null ? this.consistentRead.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private Key key;
        private Boolean consistentRead;

        private Builder() {
        }

        public Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public Builder key(Key key) {
            this.key = key;
            return this;
        }

        public GetItemEnhancedRequest build() {
            return new GetItemEnhancedRequest(this);
        }
    }
}

