/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.PaginatedDatabaseOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.BatchGetItemEnhancedRequest;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.BatchGetResultPage;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.model.ReadBatch;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;

@SdkInternalApi
public class BatchGetItemOperation
implements PaginatedDatabaseOperation<BatchGetItemRequest, BatchGetItemResponse, BatchGetResultPage> {
    private final BatchGetItemEnhancedRequest request;

    private BatchGetItemOperation(BatchGetItemEnhancedRequest request) {
        this.request = request;
    }

    public static BatchGetItemOperation create(BatchGetItemEnhancedRequest request) {
        return new BatchGetItemOperation(request);
    }

    @Override
    public BatchGetItemRequest generateRequest(MapperExtension mapperExtension) {
        HashMap requestItems = new HashMap();
        this.request.readBatches().forEach(readBatch -> this.addReadRequestsToMap((ReadBatch)readBatch, requestItems));
        return (BatchGetItemRequest)BatchGetItemRequest.builder().requestItems(Collections.unmodifiableMap(requestItems)).build();
    }

    @Override
    public BatchGetResultPage transformResponse(BatchGetItemResponse response, MapperExtension mapperExtension) {
        return BatchGetResultPage.builder().batchGetItemResponse(response).mapperExtension(mapperExtension).build();
    }

    @Override
    public Function<BatchGetItemRequest, SdkIterable<BatchGetItemResponse>> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).batchGetItemPaginator(arg_0);
    }

    @Override
    public Function<BatchGetItemRequest, SdkPublisher<BatchGetItemResponse>> asyncServiceCall(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return arg_0 -> ((DynamoDbAsyncClient)dynamoDbAsyncClient).batchGetItemPaginator(arg_0);
    }

    private void addReadRequestsToMap(ReadBatch readBatch, Map<String, KeysAndAttributes> readRequestMap) {
        KeysAndAttributes newKeysAndAttributes = readBatch.keysAndAttributes();
        KeysAndAttributes existingKeysAndAttributes = readRequestMap.get(readBatch.tableName());
        if (existingKeysAndAttributes == null) {
            readRequestMap.put(readBatch.tableName(), newKeysAndAttributes);
            return;
        }
        KeysAndAttributes mergedKeysAndAttributes = BatchGetItemOperation.mergeKeysAndAttributes(existingKeysAndAttributes, newKeysAndAttributes);
        readRequestMap.put(readBatch.tableName(), mergedKeysAndAttributes);
    }

    private static KeysAndAttributes mergeKeysAndAttributes(KeysAndAttributes first, KeysAndAttributes second) {
        if (!BatchGetItemOperation.compareNullableBooleans(first.consistentRead(), second.consistentRead())) {
            throw new IllegalArgumentException("All batchable read requests for the same table must have the same 'consistentRead' setting.");
        }
        Boolean consistentRead = first.consistentRead() == null ? second.consistentRead() : first.consistentRead();
        List keys = Stream.concat(first.keys().stream(), second.keys().stream()).collect(Collectors.toList());
        return (KeysAndAttributes)KeysAndAttributes.builder().keys(keys).consistentRead(consistentRead).build();
    }

    private static boolean compareNullableBooleans(Boolean one, Boolean two) {
        if (one == null && two == null) {
            return true;
        }
        if (one != null) {
            return one.equals(two);
        }
        return false;
    }
}

