/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.staticmapper;

import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
public class AttributeType<T> {
    private final Function<T, AttributeValue> objectTransformer;
    private final Function<AttributeValue, T> attributeValueTransformer;
    private final AttributeValueType attributeValueType;

    private AttributeType(Function<T, AttributeValue> objectTransformer, Function<AttributeValue, T> attributeValueTransformer, AttributeValueType attributeValueType) {
        this.objectTransformer = objectTransformer;
        this.attributeValueTransformer = attributeValueTransformer;
        this.attributeValueType = attributeValueType;
    }

    public static <T> AttributeType<T> create(Function<T, AttributeValue> objectTransformer, Function<AttributeValue, T> attributeValueTransformer, AttributeValueType attributeValueType) {
        return new AttributeType<T>(objectTransformer, attributeValueTransformer, attributeValueType);
    }

    public AttributeValue objectToAttributeValue(T object) {
        return this.objectTransformer.apply(object);
    }

    public T attributeValueToObject(AttributeValue attributeValue) {
        return this.attributeValueTransformer.apply(attributeValue);
    }

    AttributeValueType attributeValueType() {
        return this.attributeValueType;
    }
}

