/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.time.DateTimeException;
import java.time.MonthDay;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.ConverterUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class MonthDayAttributeConverter
implements AttributeConverter<MonthDay> {
    private static final Visitor VISITOR = new Visitor();

    private MonthDayAttributeConverter() {
    }

    public static MonthDayAttributeConverter create() {
        return new MonthDayAttributeConverter();
    }

    @Override
    public EnhancedType<MonthDay> type() {
        return EnhancedType.of(MonthDay.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.N;
    }

    @Override
    public AttributeValue transformFrom(MonthDay input) {
        String value = "" + ConverterUtils.padLeft2(input.getMonthValue()) + ConverterUtils.padLeft2(input.getDayOfMonth());
        return (AttributeValue)AttributeValue.builder().n(value).build();
    }

    @Override
    public MonthDay transformTo(AttributeValue input) {
        if (input.n() != null) {
            return EnhancedAttributeValue.fromNumber(input.n()).convert(VISITOR);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<MonthDay> {
        private Visitor() {
            super(MonthDay.class, MonthDayAttributeConverter.class);
        }

        @Override
        public MonthDay convertNumber(String value) {
            Validate.isTrue((value.length() == 4 ? 1 : 0) != 0, (String)"Invalid Month/Day length: %s, expected 4 (MMDD)", (Object[])new Object[]{value.length()});
            String[] chunkedMonthDay = ConverterUtils.chunk(value, 2, 2);
            try {
                return MonthDay.of(Integer.parseInt(chunkedMonthDay[0]), Integer.parseInt(chunkedMonthDay[1]));
            }
            catch (DateTimeException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

