/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.Objects;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;

@SdkPublicApi
public final class DeleteItemEnhancedRequest {
    private final Key key;
    private final Expression conditionExpression;

    private DeleteItemEnhancedRequest(Builder builder) {
        this.key = builder.key;
        this.conditionExpression = builder.conditionExpression;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return DeleteItemEnhancedRequest.builder().key(this.key).conditionExpression(this.conditionExpression);
    }

    public Key key() {
        return this.key;
    }

    public Expression conditionExpression() {
        return this.conditionExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteItemEnhancedRequest that = (DeleteItemEnhancedRequest)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.conditionExpression, that.conditionExpression);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.conditionExpression != null ? this.conditionExpression.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private Key key;
        private Expression conditionExpression;

        private Builder() {
        }

        public Builder key(Key key) {
            this.key = key;
            return this;
        }

        public Builder key(Consumer<Key.Builder> keyConsumer) {
            Key.Builder builder = Key.builder();
            keyConsumer.accept(builder);
            return this.key(builder.build());
        }

        public Builder conditionExpression(Expression conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public DeleteItemEnhancedRequest build() {
            return new DeleteItemEnhancedRequest(this);
        }
    }
}

