/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.extensions;

import java.util.Map;
import java.util.Objects;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbExtensionContext;
import software.amazon.awssdk.enhanced.dynamodb.OperationContext;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.OperationName;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public final class DefaultDynamoDbExtensionContext
implements DynamoDbExtensionContext.BeforeWrite,
DynamoDbExtensionContext.AfterRead {
    private final Map<String, AttributeValue> items;
    private final OperationContext operationContext;
    private final TableMetadata tableMetadata;
    private final TableSchema<?> tableSchema;
    private final OperationName operationName;

    private DefaultDynamoDbExtensionContext(Builder builder) {
        this.items = builder.items;
        this.operationContext = builder.operationContext;
        this.tableMetadata = builder.tableMetadata;
        this.tableSchema = builder.tableSchema;
        this.operationName = builder.operationName != null ? builder.operationName : OperationName.NONE;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Map<String, AttributeValue> items() {
        return this.items;
    }

    @Override
    public OperationContext operationContext() {
        return this.operationContext;
    }

    @Override
    public TableMetadata tableMetadata() {
        return this.tableMetadata;
    }

    @Override
    public TableSchema<?> tableSchema() {
        return this.tableSchema;
    }

    @Override
    public OperationName operationName() {
        return this.operationName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDynamoDbExtensionContext that = (DefaultDynamoDbExtensionContext)o;
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        if (!Objects.equals(this.operationContext, that.operationContext)) {
            return false;
        }
        if (!Objects.equals(this.tableMetadata, that.tableMetadata)) {
            return false;
        }
        if (!Objects.equals(this.tableSchema, that.tableSchema)) {
            return false;
        }
        return Objects.equals((Object)this.operationName, (Object)that.operationName);
    }

    public int hashCode() {
        int result = this.items != null ? this.items.hashCode() : 0;
        result = 31 * result + (this.operationContext != null ? this.operationContext.hashCode() : 0);
        result = 31 * result + (this.tableMetadata != null ? this.tableMetadata.hashCode() : 0);
        result = 31 * result + (this.tableSchema != null ? this.tableSchema.hashCode() : 0);
        result = 31 * result + (this.operationName != null ? this.operationName.hashCode() : 0);
        return result;
    }

    @NotThreadSafe
    public static final class Builder {
        private Map<String, AttributeValue> items;
        private OperationContext operationContext;
        private TableMetadata tableMetadata;
        private TableSchema<?> tableSchema;
        private OperationName operationName;

        public Builder items(Map<String, AttributeValue> item) {
            this.items = item;
            return this;
        }

        public Builder operationContext(OperationContext operationContext) {
            this.operationContext = operationContext;
            return this;
        }

        public Builder tableMetadata(TableMetadata tableMetadata) {
            this.tableMetadata = tableMetadata;
            return this;
        }

        public Builder tableSchema(TableSchema<?> tableSchema) {
            this.tableSchema = tableSchema;
            return this;
        }

        public Builder operationName(OperationName operationName) {
            this.operationName = operationName;
            return this;
        }

        public DefaultDynamoDbExtensionContext build() {
            return new DefaultDynamoDbExtensionContext(this);
        }
    }
}

