/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.IndexMetadata;
import software.amazon.awssdk.enhanced.dynamodb.KeyAttributeMetadata;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;

@SdkPublicApi
@ThreadSafe
public interface TableMetadata {
    default public List<String> indexPartitionKeys(String indexName) {
        String indexPartitionKey = this.indexPartitionKey(indexName);
        return indexPartitionKey == null ? Collections.emptyList() : Collections.singletonList(indexPartitionKey);
    }

    default public String indexPartitionKey(String indexName) {
        List<String> keys = this.indexPartitionKeys(indexName);
        return keys.isEmpty() ? null : keys.get(0);
    }

    default public List<String> indexSortKeys(String indexName) {
        Optional<String> indexSortKey = this.indexSortKey(indexName);
        return indexSortKey.map(Collections::singletonList).orElse(Collections.emptyList());
    }

    default public Optional<String> indexSortKey(String indexName) {
        List<String> keys = this.indexSortKeys(indexName);
        return keys.isEmpty() ? Optional.empty() : Optional.of(keys.get(0));
    }

    public <T> Optional<T> customMetadataObject(String var1, Class<? extends T> var2);

    public Collection<String> indexKeys(String var1);

    @Deprecated
    public Collection<String> allKeys();

    public Collection<IndexMetadata> indices();

    public Map<String, Object> customMetadata();

    public Collection<KeyAttributeMetadata> keyAttributes();

    public Optional<ScalarAttributeType> scalarAttributeType(String var1);

    default public String primaryPartitionKey() {
        return this.indexPartitionKey(TableMetadata.primaryIndexName());
    }

    default public Optional<String> primarySortKey() {
        return this.indexSortKey(TableMetadata.primaryIndexName());
    }

    default public Collection<String> primaryKeys() {
        return this.indexKeys(TableMetadata.primaryIndexName());
    }

    public static String primaryIndexName() {
        return "$PRIMARY_INDEX";
    }
}

