/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.AttributeDefinitionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an attribute for describing the key schema for the table and indexes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AttributeDefinition implements StructuredPojo, ToCopyableBuilder<AttributeDefinition.Builder, AttributeDefinition> {
    private final String attributeName;

    private final String attributeType;

    private AttributeDefinition(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.attributeType = builder.attributeType;
    }

    /**
     * <p>
     * A name for the attribute.
     * </p>
     * 
     * @return A name for the attribute.
     */
    public String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The data type for the attribute, where:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>S</code> - the attribute is of type String
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>N</code> - the attribute is of type Number
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>B</code> - the attribute is of type Binary
     * </p>
     * </li>
     * </ul>
     * 
     * @return The data type for the attribute, where:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>S</code> - the attribute is of type String
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>N</code> - the attribute is of type Number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>B</code> - the attribute is of type Binary
     *         </p>
     *         </li>
     * @see ScalarAttributeType
     */
    public String attributeType() {
        return attributeType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((attributeName() == null) ? 0 : attributeName().hashCode());
        hashCode = 31 * hashCode + ((attributeType() == null) ? 0 : attributeType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeDefinition)) {
            return false;
        }
        AttributeDefinition other = (AttributeDefinition) obj;
        if (other.attributeName() == null ^ this.attributeName() == null) {
            return false;
        }
        if (other.attributeName() != null && !other.attributeName().equals(this.attributeName())) {
            return false;
        }
        if (other.attributeType() == null ^ this.attributeType() == null) {
            return false;
        }
        if (other.attributeType() != null && !other.attributeType().equals(this.attributeType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (attributeName() != null) {
            sb.append("AttributeName: ").append(attributeName()).append(",");
        }
        if (attributeType() != null) {
            sb.append("AttributeType: ").append(attributeType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributeDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AttributeDefinition> {
        /**
         * <p>
         * A name for the attribute.
         * </p>
         * 
         * @param attributeName
         *        A name for the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The data type for the attribute, where:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>S</code> - the attribute is of type String
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>N</code> - the attribute is of type Number
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>B</code> - the attribute is of type Binary
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributeType
         *        The data type for the attribute, where:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>S</code> - the attribute is of type String
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>N</code> - the attribute is of type Number
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>B</code> - the attribute is of type Binary
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalarAttributeType
         */
        Builder attributeType(String attributeType);

        /**
         * <p>
         * The data type for the attribute, where:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>S</code> - the attribute is of type String
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>N</code> - the attribute is of type Number
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>B</code> - the attribute is of type Binary
         * </p>
         * </li>
         * </ul>
         * 
         * @param attributeType
         *        The data type for the attribute, where:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>S</code> - the attribute is of type String
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>N</code> - the attribute is of type Number
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>B</code> - the attribute is of type Binary
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalarAttributeType
         */
        Builder attributeType(ScalarAttributeType attributeType);
    }

    private static final class BuilderImpl implements Builder {
        private String attributeName;

        private String attributeType;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeDefinition model) {
            setAttributeName(model.attributeName);
            setAttributeType(model.attributeType);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getAttributeType() {
            return attributeType;
        }

        @Override
        public final Builder attributeType(String attributeType) {
            this.attributeType = attributeType;
            return this;
        }

        @Override
        public final Builder attributeType(ScalarAttributeType attributeType) {
            this.attributeType(attributeType.toString());
            return this;
        }

        public final void setAttributeType(String attributeType) {
            this.attributeType = attributeType;
        }

        public final void setAttributeType(ScalarAttributeType attributeType) {
            this.attributeType(attributeType.toString());
        }

        @Override
        public AttributeDefinition build() {
            return new AttributeDefinition(this);
        }
    }
}
