/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.dynamodb.transform.AttributeValueMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the data for an attribute.
 * </p>
 * <p>
 * Each attribute value is described as a name-value pair. The name is the data type, and the value is the data itself.
 * </p>
 * <p>
 * For more information, see <a href=
 * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes"
 * >Data Types</a> in the <i>Amazon DynamoDB Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AttributeValue implements StructuredPojo, ToCopyableBuilder<AttributeValue.Builder, AttributeValue> {
    private final String s;

    private final String n;

    private final ByteBuffer b;

    private final List<String> ss;

    private final List<String> ns;

    private final List<ByteBuffer> bs;

    private final Map<String, AttributeValue> m;

    private final List<AttributeValue> l;

    private final Boolean bool;

    private final Boolean nul;

    private AttributeValue(BuilderImpl builder) {
        this.s = builder.s;
        this.n = builder.n;
        this.b = builder.b;
        this.ss = builder.ss;
        this.ns = builder.ns;
        this.bs = builder.bs;
        this.m = builder.m;
        this.l = builder.l;
        this.bool = builder.bool;
        this.nul = builder.nul;
    }

    /**
     * <p>
     * An attribute of type String. For example:
     * </p>
     * <p>
     * <code>"S": "Hello"</code>
     * </p>
     * 
     * @return An attribute of type String. For example:</p>
     *         <p>
     *         <code>"S": "Hello"</code>
     */
    public String s() {
        return s;
    }

    /**
     * <p>
     * An attribute of type Number. For example:
     * </p>
     * <p>
     * <code>"N": "123.45"</code>
     * </p>
     * <p>
     * Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and
     * libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
     * </p>
     * 
     * @return An attribute of type Number. For example:</p>
     *         <p>
     *         <code>"N": "123.45"</code>
     *         </p>
     *         <p>
     *         Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages
     *         and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
     */
    public String n() {
        return n;
    }

    /**
     * <p>
     * An attribute of type Binary. For example:
     * </p>
     * <p>
     * <code>"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"</code>
     * </p>
     * <p>
     * {@code ByteBuffer}s are stateful. Calling their {@code get} methods changes their {@code position}. We recommend
     * using {@link java.nio.ByteBuffer#asReadOnlyBuffer()} to create a read-only view of the buffer with an independent
     * {@code position}, and calling {@code get} methods on this rather than directly on the returned {@code ByteBuffer}
     * . Doing so will ensure that anyone else using the {@code ByteBuffer} will not be affected by changes to the
     * {@code position}.
     * </p>
     * 
     * @return An attribute of type Binary. For example:</p>
     *         <p>
     *         <code>"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"</code>
     */
    public ByteBuffer b() {
        return b;
    }

    /**
     * <p>
     * An attribute of type String Set. For example:
     * </p>
     * <p>
     * <code>"SS": ["Giraffe", "Hippo" ,"Zebra"]</code>
     * </p>
     * 
     * @return An attribute of type String Set. For example:</p>
     *         <p>
     *         <code>"SS": ["Giraffe", "Hippo" ,"Zebra"]</code>
     */
    public List<String> ss() {
        return ss;
    }

    /**
     * <p>
     * An attribute of type Number Set. For example:
     * </p>
     * <p>
     * <code>"NS": ["42.2", "-19", "7.5", "3.14"]</code>
     * </p>
     * <p>
     * Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and
     * libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
     * </p>
     * 
     * @return An attribute of type Number Set. For example:</p>
     *         <p>
     *         <code>"NS": ["42.2", "-19", "7.5", "3.14"]</code>
     *         </p>
     *         <p>
     *         Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages
     *         and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
     */
    public List<String> ns() {
        return ns;
    }

    /**
     * <p>
     * An attribute of type Binary Set. For example:
     * </p>
     * <p>
     * <code>"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]</code>
     * </p>
     * 
     * @return An attribute of type Binary Set. For example:</p>
     *         <p>
     *         <code>"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]</code>
     */
    public List<ByteBuffer> bs() {
        return bs;
    }

    /**
     * <p>
     * An attribute of type Map. For example:
     * </p>
     * <p>
     * <code>"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}</code>
     * </p>
     * 
     * @return An attribute of type Map. For example:</p>
     *         <p>
     *         <code>"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}</code>
     */
    public Map<String, AttributeValue> m() {
        return m;
    }

    /**
     * <p>
     * An attribute of type List. For example:
     * </p>
     * <p>
     * <code>"L": ["Cookies", "Coffee", 3.14159]</code>
     * </p>
     * 
     * @return An attribute of type List. For example:</p>
     *         <p>
     *         <code>"L": ["Cookies", "Coffee", 3.14159]</code>
     */
    public List<AttributeValue> l() {
        return l;
    }

    /**
     * <p>
     * An attribute of type Boolean. For example:
     * </p>
     * <p>
     * <code>"BOOL": true</code>
     * </p>
     * 
     * @return An attribute of type Boolean. For example:</p>
     *         <p>
     *         <code>"BOOL": true</code>
     */
    public Boolean bool() {
        return bool;
    }

    /**
     * <p>
     * An attribute of type Null. For example:
     * </p>
     * <p>
     * <code>"NULL": true</code>
     * </p>
     * 
     * @return An attribute of type Null. For example:</p>
     *         <p>
     *         <code>"NULL": true</code>
     */
    public Boolean nul() {
        return nul;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((s() == null) ? 0 : s().hashCode());
        hashCode = 31 * hashCode + ((n() == null) ? 0 : n().hashCode());
        hashCode = 31 * hashCode + ((b() == null) ? 0 : b().hashCode());
        hashCode = 31 * hashCode + ((ss() == null) ? 0 : ss().hashCode());
        hashCode = 31 * hashCode + ((ns() == null) ? 0 : ns().hashCode());
        hashCode = 31 * hashCode + ((bs() == null) ? 0 : bs().hashCode());
        hashCode = 31 * hashCode + ((m() == null) ? 0 : m().hashCode());
        hashCode = 31 * hashCode + ((l() == null) ? 0 : l().hashCode());
        hashCode = 31 * hashCode + ((bool() == null) ? 0 : bool().hashCode());
        hashCode = 31 * hashCode + ((nul() == null) ? 0 : nul().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValue)) {
            return false;
        }
        AttributeValue other = (AttributeValue) obj;
        if (other.s() == null ^ this.s() == null) {
            return false;
        }
        if (other.s() != null && !other.s().equals(this.s())) {
            return false;
        }
        if (other.n() == null ^ this.n() == null) {
            return false;
        }
        if (other.n() != null && !other.n().equals(this.n())) {
            return false;
        }
        if (other.b() == null ^ this.b() == null) {
            return false;
        }
        if (other.b() != null && !other.b().equals(this.b())) {
            return false;
        }
        if (other.ss() == null ^ this.ss() == null) {
            return false;
        }
        if (other.ss() != null && !other.ss().equals(this.ss())) {
            return false;
        }
        if (other.ns() == null ^ this.ns() == null) {
            return false;
        }
        if (other.ns() != null && !other.ns().equals(this.ns())) {
            return false;
        }
        if (other.bs() == null ^ this.bs() == null) {
            return false;
        }
        if (other.bs() != null && !other.bs().equals(this.bs())) {
            return false;
        }
        if (other.m() == null ^ this.m() == null) {
            return false;
        }
        if (other.m() != null && !other.m().equals(this.m())) {
            return false;
        }
        if (other.l() == null ^ this.l() == null) {
            return false;
        }
        if (other.l() != null && !other.l().equals(this.l())) {
            return false;
        }
        if (other.bool() == null ^ this.bool() == null) {
            return false;
        }
        if (other.bool() != null && !other.bool().equals(this.bool())) {
            return false;
        }
        if (other.nul() == null ^ this.nul() == null) {
            return false;
        }
        if (other.nul() != null && !other.nul().equals(this.nul())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (s() != null) {
            sb.append("S: ").append(s()).append(",");
        }
        if (n() != null) {
            sb.append("N: ").append(n()).append(",");
        }
        if (b() != null) {
            sb.append("B: ").append(b()).append(",");
        }
        if (ss() != null) {
            sb.append("SS: ").append(ss()).append(",");
        }
        if (ns() != null) {
            sb.append("NS: ").append(ns()).append(",");
        }
        if (bs() != null) {
            sb.append("BS: ").append(bs()).append(",");
        }
        if (m() != null) {
            sb.append("M: ").append(m()).append(",");
        }
        if (l() != null) {
            sb.append("L: ").append(l()).append(",");
        }
        if (bool() != null) {
            sb.append("BOOL: ").append(bool()).append(",");
        }
        if (nul() != null) {
            sb.append("NUL: ").append(nul()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributeValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, AttributeValue> {
        /**
         * <p>
         * An attribute of type String. For example:
         * </p>
         * <p>
         * <code>"S": "Hello"</code>
         * </p>
         * 
         * @param s
         *        An attribute of type String. For example:</p>
         *        <p>
         *        <code>"S": "Hello"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s(String s);

        /**
         * <p>
         * An attribute of type Number. For example:
         * </p>
         * <p>
         * <code>"N": "123.45"</code>
         * </p>
         * <p>
         * Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and
         * libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
         * </p>
         * 
         * @param n
         *        An attribute of type Number. For example:</p>
         *        <p>
         *        <code>"N": "123.45"</code>
         *        </p>
         *        <p>
         *        Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages
         *        and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder n(String n);

        /**
         * <p>
         * An attribute of type Binary. For example:
         * </p>
         * <p>
         * <code>"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"</code>
         * </p>
         * 
         * @param b
         *        An attribute of type Binary. For example:</p>
         *        <p>
         *        <code>"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder b(ByteBuffer b);

        /**
         * <p>
         * An attribute of type String Set. For example:
         * </p>
         * <p>
         * <code>"SS": ["Giraffe", "Hippo" ,"Zebra"]</code>
         * </p>
         * 
         * @param ss
         *        An attribute of type String Set. For example:</p>
         *        <p>
         *        <code>"SS": ["Giraffe", "Hippo" ,"Zebra"]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ss(Collection<String> ss);

        /**
         * <p>
         * An attribute of type String Set. For example:
         * </p>
         * <p>
         * <code>"SS": ["Giraffe", "Hippo" ,"Zebra"]</code>
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setSS(java.util.Collection)} or {@link #withSS(java.util.Collection)} if you want to override the
         * existing values.
         * </p>
         * 
         * @param ss
         *        An attribute of type String Set. For example:</p>
         *        <p>
         *        <code>"SS": ["Giraffe", "Hippo" ,"Zebra"]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ss(String... ss);

        /**
         * <p>
         * An attribute of type Number Set. For example:
         * </p>
         * <p>
         * <code>"NS": ["42.2", "-19", "7.5", "3.14"]</code>
         * </p>
         * <p>
         * Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and
         * libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
         * </p>
         * 
         * @param ns
         *        An attribute of type Number Set. For example:</p>
         *        <p>
         *        <code>"NS": ["42.2", "-19", "7.5", "3.14"]</code>
         *        </p>
         *        <p>
         *        Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages
         *        and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ns(Collection<String> ns);

        /**
         * <p>
         * An attribute of type Number Set. For example:
         * </p>
         * <p>
         * <code>"NS": ["42.2", "-19", "7.5", "3.14"]</code>
         * </p>
         * <p>
         * Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and
         * libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setNS(java.util.Collection)} or {@link #withNS(java.util.Collection)} if you want to override the
         * existing values.
         * </p>
         * 
         * @param ns
         *        An attribute of type Number Set. For example:</p>
         *        <p>
         *        <code>"NS": ["42.2", "-19", "7.5", "3.14"]</code>
         *        </p>
         *        <p>
         *        Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages
         *        and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ns(String... ns);

        /**
         * <p>
         * An attribute of type Binary Set. For example:
         * </p>
         * <p>
         * <code>"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]</code>
         * </p>
         * 
         * @param bs
         *        An attribute of type Binary Set. For example:</p>
         *        <p>
         *        <code>"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bs(Collection<ByteBuffer> bs);

        /**
         * <p>
         * An attribute of type Binary Set. For example:
         * </p>
         * <p>
         * <code>"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]</code>
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setBS(java.util.Collection)} or {@link #withBS(java.util.Collection)} if you want to override the
         * existing values.
         * </p>
         * 
         * @param bs
         *        An attribute of type Binary Set. For example:</p>
         *        <p>
         *        <code>"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bs(ByteBuffer... bs);

        /**
         * <p>
         * An attribute of type Map. For example:
         * </p>
         * <p>
         * <code>"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}</code>
         * </p>
         * 
         * @param m
         *        An attribute of type Map. For example:</p>
         *        <p>
         *        <code>"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder m(Map<String, AttributeValue> m);

        /**
         * <p>
         * An attribute of type List. For example:
         * </p>
         * <p>
         * <code>"L": ["Cookies", "Coffee", 3.14159]</code>
         * </p>
         * 
         * @param l
         *        An attribute of type List. For example:</p>
         *        <p>
         *        <code>"L": ["Cookies", "Coffee", 3.14159]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder l(Collection<AttributeValue> l);

        /**
         * <p>
         * An attribute of type List. For example:
         * </p>
         * <p>
         * <code>"L": ["Cookies", "Coffee", 3.14159]</code>
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setL(java.util.Collection)} or {@link #withL(java.util.Collection)} if you want to override the
         * existing values.
         * </p>
         * 
         * @param l
         *        An attribute of type List. For example:</p>
         *        <p>
         *        <code>"L": ["Cookies", "Coffee", 3.14159]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder l(AttributeValue... l);

        /**
         * <p>
         * An attribute of type Boolean. For example:
         * </p>
         * <p>
         * <code>"BOOL": true</code>
         * </p>
         * 
         * @param bool
         *        An attribute of type Boolean. For example:</p>
         *        <p>
         *        <code>"BOOL": true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bool(Boolean bool);

        /**
         * <p>
         * An attribute of type Null. For example:
         * </p>
         * <p>
         * <code>"NULL": true</code>
         * </p>
         * 
         * @param nul
         *        An attribute of type Null. For example:</p>
         *        <p>
         *        <code>"NULL": true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nul(Boolean nul);
    }

    private static final class BuilderImpl implements Builder {
        private String s;

        private String n;

        private ByteBuffer b;

        private List<String> ss;

        private List<String> ns;

        private List<ByteBuffer> bs;

        private Map<String, AttributeValue> m;

        private List<AttributeValue> l;

        private Boolean bool;

        private Boolean nul;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeValue model) {
            setS(model.s);
            setN(model.n);
            setB(model.b);
            setSS(model.ss);
            setNS(model.ns);
            setBS(model.bs);
            setM(model.m);
            setL(model.l);
            setBOOL(model.bool);
            setNUL(model.nul);
        }

        public final String getS() {
            return s;
        }

        @Override
        public final Builder s(String s) {
            this.s = s;
            return this;
        }

        public final void setS(String s) {
            this.s = s;
        }

        public final String getN() {
            return n;
        }

        @Override
        public final Builder n(String n) {
            this.n = n;
            return this;
        }

        public final void setN(String n) {
            this.n = n;
        }

        public final ByteBuffer getB() {
            return b;
        }

        @Override
        public final Builder b(ByteBuffer b) {
            this.b = StandardMemberCopier.copy(b);
            return this;
        }

        public final void setB(ByteBuffer b) {
            this.b = StandardMemberCopier.copy(b);
        }

        public final Collection<String> getSS() {
            return ss;
        }

        @Override
        public final Builder ss(Collection<String> ss) {
            this.ss = StringSetAttributeValueCopier.copy(ss);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ss(String... ss) {
            if (this.ss == null) {
                this.ss = new ArrayList<>(ss.length);
            }
            for (String e : ss) {
                this.ss.add(e);
            }
            return this;
        }

        public final void setSS(Collection<String> ss) {
            this.ss = StringSetAttributeValueCopier.copy(ss);
        }

        @SafeVarargs
        public final void setSS(String... ss) {
            if (this.ss == null) {
                this.ss = new ArrayList<>(ss.length);
            }
            for (String e : ss) {
                this.ss.add(e);
            }
        }

        public final Collection<String> getNS() {
            return ns;
        }

        @Override
        public final Builder ns(Collection<String> ns) {
            this.ns = NumberSetAttributeValueCopier.copy(ns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ns(String... ns) {
            if (this.ns == null) {
                this.ns = new ArrayList<>(ns.length);
            }
            for (String e : ns) {
                this.ns.add(e);
            }
            return this;
        }

        public final void setNS(Collection<String> ns) {
            this.ns = NumberSetAttributeValueCopier.copy(ns);
        }

        @SafeVarargs
        public final void setNS(String... ns) {
            if (this.ns == null) {
                this.ns = new ArrayList<>(ns.length);
            }
            for (String e : ns) {
                this.ns.add(e);
            }
        }

        public final Collection<ByteBuffer> getBS() {
            return bs;
        }

        @Override
        public final Builder bs(Collection<ByteBuffer> bs) {
            this.bs = BinarySetAttributeValueCopier.copy(bs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bs(ByteBuffer... bs) {
            if (this.bs == null) {
                this.bs = new ArrayList<>(bs.length);
            }
            for (ByteBuffer e : bs) {
                this.bs.add(StandardMemberCopier.copy(e));
            }
            return this;
        }

        public final void setBS(Collection<ByteBuffer> bs) {
            this.bs = BinarySetAttributeValueCopier.copy(bs);
        }

        @SafeVarargs
        public final void setBS(ByteBuffer... bs) {
            if (this.bs == null) {
                this.bs = new ArrayList<>(bs.length);
            }
            for (ByteBuffer e : bs) {
                this.bs.add(StandardMemberCopier.copy(e));
            }
        }

        public final Map<String, AttributeValue> getM() {
            return m;
        }

        @Override
        public final Builder m(Map<String, AttributeValue> m) {
            this.m = MapAttributeValueCopier.copy(m);
            return this;
        }

        public final void setM(Map<String, AttributeValue> m) {
            this.m = MapAttributeValueCopier.copy(m);
        }

        public final Collection<AttributeValue> getL() {
            return l;
        }

        @Override
        public final Builder l(Collection<AttributeValue> l) {
            this.l = ListAttributeValueCopier.copy(l);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder l(AttributeValue... l) {
            if (this.l == null) {
                this.l = new ArrayList<>(l.length);
            }
            for (AttributeValue e : l) {
                this.l.add(e);
            }
            return this;
        }

        public final void setL(Collection<AttributeValue> l) {
            this.l = ListAttributeValueCopier.copy(l);
        }

        @SafeVarargs
        public final void setL(AttributeValue... l) {
            if (this.l == null) {
                this.l = new ArrayList<>(l.length);
            }
            for (AttributeValue e : l) {
                this.l.add(e);
            }
        }

        public final Boolean getBOOL() {
            return bool;
        }

        @Override
        public final Builder bool(Boolean bool) {
            this.bool = bool;
            return this;
        }

        public final void setBOOL(Boolean bool) {
            this.bool = bool;
        }

        public final Boolean getNUL() {
            return nul;
        }

        @Override
        public final Builder nul(Boolean nul) {
            this.nul = nul;
            return this;
        }

        public final void setNUL(Boolean nul) {
            this.nul = nul;
        }

        @Override
        public AttributeValue build() {
            return new AttributeValue(this);
        }
    }
}
