/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>BatchWriteItem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BatchWriteItemResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<BatchWriteItemResponse.Builder, BatchWriteItemResponse> {
    private final Map<String, List<WriteRequest>> unprocessedItems;

    private final Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics;

    private final List<ConsumedCapacity> consumedCapacity;

    private BatchWriteItemResponse(BuilderImpl builder) {
        this.unprocessedItems = builder.unprocessedItems;
        this.itemCollectionMetrics = builder.itemCollectionMetrics;
        this.consumedCapacity = builder.consumedCapacity;
    }

    /**
     * <p>
     * A map of tables and requests against those tables that were not processed. The <code>UnprocessedItems</code>
     * value is in the same form as <code>RequestItems</code>, so you can provide this value directly to a subsequent
     * <code>BatchGetItem</code> operation. For more information, see <code>RequestItems</code> in the Request
     * Parameters section.
     * </p>
     * <p>
     * Each <code>UnprocessedItems</code> entry consists of a table name and, for that table, a list of operations to
     * perform (<code>DeleteRequest</code> or <code>PutRequest</code>).
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The item to be
     * deleted is identified by a <code>Key</code> subelement:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Key</code> - A map of primary key attribute values that uniquely identify the item. Each entry in this map
     * consists of an attribute name and an attribute value.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to be put is
     * identified by an <code>Item</code> subelement:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an attribute name
     * and an attribute value. Attribute values must not be null; string and binary type attributes must have lengths
     * greater than zero; and set type attributes must not be empty. Requests that contain empty values will be rejected
     * with a <code>ValidationException</code> exception.
     * </p>
     * <p>
     * If you specify any attributes that are part of an index key, then the data types for those attributes must match
     * those of the schema in the table's attribute definition.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * If there are no unprocessed items remaining, the response contains an empty <code>UnprocessedItems</code> map.
     * </p>
     * 
     * @return A map of tables and requests against those tables that were not processed. The
     *         <code>UnprocessedItems</code> value is in the same form as <code>RequestItems</code>, so you can provide
     *         this value directly to a subsequent <code>BatchGetItem</code> operation. For more information, see
     *         <code>RequestItems</code> in the Request Parameters section.</p>
     *         <p>
     *         Each <code>UnprocessedItems</code> entry consists of a table name and, for that table, a list of
     *         operations to perform (<code>DeleteRequest</code> or <code>PutRequest</code>).
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The item
     *         to be deleted is identified by a <code>Key</code> subelement:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Key</code> - A map of primary key attribute values that uniquely identify the item. Each entry in
     *         this map consists of an attribute name and an attribute value.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to be
     *         put is identified by an <code>Item</code> subelement:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an attribute
     *         name and an attribute value. Attribute values must not be null; string and binary type attributes must
     *         have lengths greater than zero; and set type attributes must not be empty. Requests that contain empty
     *         values will be rejected with a <code>ValidationException</code> exception.
     *         </p>
     *         <p>
     *         If you specify any attributes that are part of an index key, then the data types for those attributes
     *         must match those of the schema in the table's attribute definition.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         If there are no unprocessed items remaining, the response contains an empty <code>UnprocessedItems</code>
     *         map.
     */
    public Map<String, List<WriteRequest>> unprocessedItems() {
        return unprocessedItems;
    }

    /**
     * <p>
     * A list of tables that were processed by <code>BatchWriteItem</code> and, for each table, information about any
     * item collections that were affected by individual <code>DeleteItem</code> or <code>PutItem</code> operations.
     * </p>
     * <p>
     * Each entry consists of the following subelements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the
     * partition key value of the item.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SizeEstimateRange</code> - An estimate of item collection size, expressed in GB. This is a two-element
     * array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the
     * items in the table, plus the size of all attributes projected into all of the local secondary indexes on the
     * table. Use this estimate to measure whether a local secondary index is approaching its size limit.
     * </p>
     * <p>
     * The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A list of tables that were processed by <code>BatchWriteItem</code> and, for each table, information
     *         about any item collections that were affected by individual <code>DeleteItem</code> or
     *         <code>PutItem</code> operations.</p>
     *         <p>
     *         Each entry consists of the following subelements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the
     *         partition key value of the item.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SizeEstimateRange</code> - An estimate of item collection size, expressed in GB. This is a
     *         two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the
     *         size of all the items in the table, plus the size of all attributes projected into all of the local
     *         secondary indexes on the table. Use this estimate to measure whether a local secondary index is
     *         approaching its size limit.
     *         </p>
     *         <p>
     *         The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the
     *         estimate.
     *         </p>
     *         </li>
     */
    public Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics() {
        return itemCollectionMetrics;
    }

    /**
     * <p>
     * The capacity units consumed by the entire <code>BatchWriteItem</code> operation.
     * </p>
     * <p>
     * Each element consists of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TableName</code> - The table that consumed the provisioned throughput.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CapacityUnits</code> - The total number of capacity units consumed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The capacity units consumed by the entire <code>BatchWriteItem</code> operation.</p>
     *         <p>
     *         Each element consists of:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>TableName</code> - The table that consumed the provisioned throughput.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CapacityUnits</code> - The total number of capacity units consumed.
     *         </p>
     *         </li>
     */
    public List<ConsumedCapacity> consumedCapacity() {
        return consumedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((unprocessedItems() == null) ? 0 : unprocessedItems().hashCode());
        hashCode = 31 * hashCode + ((itemCollectionMetrics() == null) ? 0 : itemCollectionMetrics().hashCode());
        hashCode = 31 * hashCode + ((consumedCapacity() == null) ? 0 : consumedCapacity().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteItemResponse)) {
            return false;
        }
        BatchWriteItemResponse other = (BatchWriteItemResponse) obj;
        if (other.unprocessedItems() == null ^ this.unprocessedItems() == null) {
            return false;
        }
        if (other.unprocessedItems() != null && !other.unprocessedItems().equals(this.unprocessedItems())) {
            return false;
        }
        if (other.itemCollectionMetrics() == null ^ this.itemCollectionMetrics() == null) {
            return false;
        }
        if (other.itemCollectionMetrics() != null && !other.itemCollectionMetrics().equals(this.itemCollectionMetrics())) {
            return false;
        }
        if (other.consumedCapacity() == null ^ this.consumedCapacity() == null) {
            return false;
        }
        if (other.consumedCapacity() != null && !other.consumedCapacity().equals(this.consumedCapacity())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (unprocessedItems() != null) {
            sb.append("UnprocessedItems: ").append(unprocessedItems()).append(",");
        }
        if (itemCollectionMetrics() != null) {
            sb.append("ItemCollectionMetrics: ").append(itemCollectionMetrics()).append(",");
        }
        if (consumedCapacity() != null) {
            sb.append("ConsumedCapacity: ").append(consumedCapacity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BatchWriteItemResponse> {
        /**
         * <p>
         * A map of tables and requests against those tables that were not processed. The <code>UnprocessedItems</code>
         * value is in the same form as <code>RequestItems</code>, so you can provide this value directly to a
         * subsequent <code>BatchGetItem</code> operation. For more information, see <code>RequestItems</code> in the
         * Request Parameters section.
         * </p>
         * <p>
         * Each <code>UnprocessedItems</code> entry consists of a table name and, for that table, a list of operations
         * to perform (<code>DeleteRequest</code> or <code>PutRequest</code>).
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The item to
         * be deleted is identified by a <code>Key</code> subelement:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key</code> - A map of primary key attribute values that uniquely identify the item. Each entry in this
         * map consists of an attribute name and an attribute value.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to be put
         * is identified by an <code>Item</code> subelement:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an attribute
         * name and an attribute value. Attribute values must not be null; string and binary type attributes must have
         * lengths greater than zero; and set type attributes must not be empty. Requests that contain empty values will
         * be rejected with a <code>ValidationException</code> exception.
         * </p>
         * <p>
         * If you specify any attributes that are part of an index key, then the data types for those attributes must
         * match those of the schema in the table's attribute definition.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * If there are no unprocessed items remaining, the response contains an empty <code>UnprocessedItems</code>
         * map.
         * </p>
         * 
         * @param unprocessedItems
         *        A map of tables and requests against those tables that were not processed. The
         *        <code>UnprocessedItems</code> value is in the same form as <code>RequestItems</code>, so you can
         *        provide this value directly to a subsequent <code>BatchGetItem</code> operation. For more information,
         *        see <code>RequestItems</code> in the Request Parameters section.</p>
         *        <p>
         *        Each <code>UnprocessedItems</code> entry consists of a table name and, for that table, a list of
         *        operations to perform (<code>DeleteRequest</code> or <code>PutRequest</code>).
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DeleteRequest</code> - Perform a <code>DeleteItem</code> operation on the specified item. The
         *        item to be deleted is identified by a <code>Key</code> subelement:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Key</code> - A map of primary key attribute values that uniquely identify the item. Each entry
         *        in this map consists of an attribute name and an attribute value.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PutRequest</code> - Perform a <code>PutItem</code> operation on the specified item. The item to
         *        be put is identified by an <code>Item</code> subelement:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Item</code> - A map of attributes and their values. Each entry in this map consists of an
         *        attribute name and an attribute value. Attribute values must not be null; string and binary type
         *        attributes must have lengths greater than zero; and set type attributes must not be empty. Requests
         *        that contain empty values will be rejected with a <code>ValidationException</code> exception.
         *        </p>
         *        <p>
         *        If you specify any attributes that are part of an index key, then the data types for those attributes
         *        must match those of the schema in the table's attribute definition.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        If there are no unprocessed items remaining, the response contains an empty
         *        <code>UnprocessedItems</code> map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedItems(Map<String, ? extends Collection<WriteRequest>> unprocessedItems);

        /**
         * <p>
         * A list of tables that were processed by <code>BatchWriteItem</code> and, for each table, information about
         * any item collections that were affected by individual <code>DeleteItem</code> or <code>PutItem</code>
         * operations.
         * </p>
         * <p>
         * Each entry consists of the following subelements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as the
         * partition key value of the item.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SizeEstimateRange</code> - An estimate of item collection size, expressed in GB. This is a two-element
         * array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the
         * items in the table, plus the size of all attributes projected into all of the local secondary indexes on the
         * table. Use this estimate to measure whether a local secondary index is approaching its size limit.
         * </p>
         * <p>
         * The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the
         * estimate.
         * </p>
         * </li>
         * </ul>
         * 
         * @param itemCollectionMetrics
         *        A list of tables that were processed by <code>BatchWriteItem</code> and, for each table, information
         *        about any item collections that were affected by individual <code>DeleteItem</code> or
         *        <code>PutItem</code> operations.</p>
         *        <p>
         *        Each entry consists of the following subelements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ItemCollectionKey</code> - The partition key value of the item collection. This is the same as
         *        the partition key value of the item.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SizeEstimateRange</code> - An estimate of item collection size, expressed in GB. This is a
         *        two-element array containing a lower bound and an upper bound for the estimate. The estimate includes
         *        the size of all the items in the table, plus the size of all attributes projected into all of the
         *        local secondary indexes on the table. Use this estimate to measure whether a local secondary index is
         *        approaching its size limit.
         *        </p>
         *        <p>
         *        The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of
         *        the estimate.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> itemCollectionMetrics);

        /**
         * <p>
         * The capacity units consumed by the entire <code>BatchWriteItem</code> operation.
         * </p>
         * <p>
         * Each element consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TableName</code> - The table that consumed the provisioned throughput.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CapacityUnits</code> - The total number of capacity units consumed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param consumedCapacity
         *        The capacity units consumed by the entire <code>BatchWriteItem</code> operation.</p>
         *        <p>
         *        Each element consists of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TableName</code> - The table that consumed the provisioned throughput.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CapacityUnits</code> - The total number of capacity units consumed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity);

        /**
         * <p>
         * The capacity units consumed by the entire <code>BatchWriteItem</code> operation.
         * </p>
         * <p>
         * Each element consists of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>TableName</code> - The table that consumed the provisioned throughput.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CapacityUnits</code> - The total number of capacity units consumed.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setConsumedCapacity(java.util.Collection)} or {@link #withConsumedCapacity(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param consumedCapacity
         *        The capacity units consumed by the entire <code>BatchWriteItem</code> operation.</p>
         *        <p>
         *        Each element consists of:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>TableName</code> - The table that consumed the provisioned throughput.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CapacityUnits</code> - The total number of capacity units consumed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(ConsumedCapacity... consumedCapacity);
    }

    private static final class BuilderImpl implements Builder {
        private Map<String, List<WriteRequest>> unprocessedItems;

        private Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics;

        private List<ConsumedCapacity> consumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteItemResponse model) {
            setUnprocessedItems(model.unprocessedItems);
            setItemCollectionMetrics(model.itemCollectionMetrics);
            setConsumedCapacity(model.consumedCapacity);
        }

        public final Map<String, ? extends Collection<WriteRequest>> getUnprocessedItems() {
            return unprocessedItems;
        }

        @Override
        public final Builder unprocessedItems(Map<String, ? extends Collection<WriteRequest>> unprocessedItems) {
            this.unprocessedItems = BatchWriteItemRequestMapCopier.copy(unprocessedItems);
            return this;
        }

        public final void setUnprocessedItems(Map<String, ? extends Collection<WriteRequest>> unprocessedItems) {
            this.unprocessedItems = BatchWriteItemRequestMapCopier.copy(unprocessedItems);
        }

        public final Map<String, ? extends Collection<ItemCollectionMetrics>> getItemCollectionMetrics() {
            return itemCollectionMetrics;
        }

        @Override
        public final Builder itemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> itemCollectionMetrics) {
            this.itemCollectionMetrics = ItemCollectionMetricsPerTableCopier.copy(itemCollectionMetrics);
            return this;
        }

        public final void setItemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> itemCollectionMetrics) {
            this.itemCollectionMetrics = ItemCollectionMetricsPerTableCopier.copy(itemCollectionMetrics);
        }

        public final Collection<ConsumedCapacity> getConsumedCapacity() {
            return consumedCapacity;
        }

        @Override
        public final Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(ConsumedCapacity... consumedCapacity) {
            if (this.consumedCapacity == null) {
                this.consumedCapacity = new ArrayList<>(consumedCapacity.length);
            }
            for (ConsumedCapacity e : consumedCapacity) {
                this.consumedCapacity.add(e);
            }
            return this;
        }

        public final void setConsumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
        }

        @SafeVarargs
        public final void setConsumedCapacity(ConsumedCapacity... consumedCapacity) {
            if (this.consumedCapacity == null) {
                this.consumedCapacity = new ArrayList<>(consumedCapacity.length);
            }
            for (ConsumedCapacity e : consumedCapacity) {
                this.consumedCapacity.add(e);
            }
        }

        @Override
        public BatchWriteItemResponse build() {
            return new BatchWriteItemResponse(this);
        }
    }
}
