/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>DeleteItem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteItemRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteItemRequest.Builder, DeleteItemRequest> {
    private final String tableName;

    private final Map<String, AttributeValue> key;

    private final Map<String, ExpectedAttributeValue> expected;

    private final String conditionalOperator;

    private final String returnValues;

    private final String returnConsumedCapacity;

    private final String returnItemCollectionMetrics;

    private final String conditionExpression;

    private final Map<String, String> expressionAttributeNames;

    private final Map<String, AttributeValue> expressionAttributeValues;

    private DeleteItemRequest(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.key = builder.key;
        this.expected = builder.expected;
        this.conditionalOperator = builder.conditionalOperator;
        this.returnValues = builder.returnValues;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.returnItemCollectionMetrics = builder.returnItemCollectionMetrics;
        this.conditionExpression = builder.conditionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
    }

    /**
     * <p>
     * The name of the table from which to delete the item.
     * </p>
     * 
     * @return The name of the table from which to delete the item.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * A map of attribute names to <code>AttributeValue</code> objects, representing the primary key of the item to
     * delete.
     * </p>
     * <p>
     * For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only
     * need to provide a value for the partition key. For a composite primary key, you must provide values for both the
     * partition key and the sort key.
     * </p>
     * 
     * @return A map of attribute names to <code>AttributeValue</code> objects, representing the primary key of the item
     *         to delete.</p>
     *         <p>
     *         For the primary key, you must provide all of the attributes. For example, with a simple primary key, you
     *         only need to provide a value for the partition key. For a composite primary key, you must provide values
     *         for both the partition key and the sort key.
     */
    public Map<String, AttributeValue> key() {
        return key;
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>ConditionExpresssion</code> instead. For more information, see <a href=
     * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html"
     * >Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>ConditionExpresssion</code> instead. For more information, see <a
     *         href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html"
     *         >Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, ExpectedAttributeValue> expected() {
        return expected;
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href=
     * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a
     *         href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     *         >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @see ConditionalOperator
     */
    public String conditionalOperator() {
        return conditionalOperator;
    }

    /**
     * <p>
     * Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were deleted.
     * For <code>DeleteItem</code>, the valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then
     * nothing is returned. (This setting is the default for <code>ReturnValues</code>.)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL_OLD</code> - The content of the old item is returned.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however, <code>DeleteItem</code>
     * does not recognize any values other than <code>NONE</code> or <code>ALL_OLD</code>.
     * </p>
     * </note>
     * 
     * @return Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were
     *         deleted. For <code>DeleteItem</code>, the valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>,
     *         then nothing is returned. (This setting is the default for <code>ReturnValues</code>.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL_OLD</code> - The content of the old item is returned.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however,
     *         <code>DeleteItem</code> does not recognize any values other than <code>NONE</code> or
     *         <code>ALL_OLD</code>.
     *         </p>
     * @see ReturnValue
     */
    public String returnValues() {
        return returnValues;
    }

    /**
     *
     * @return
     * @see ReturnConsumedCapacity
     */
    public String returnConsumedCapacity() {
        return returnConsumedCapacity;
    }

    /**
     * <p>
     * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
     * statistics about item collections, if any, that were modified during the operation are returned in the response.
     * If set to <code>NONE</code> (the default), no statistics are returned.
     * </p>
     * 
     * @return Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
     *         includes statistics about item collections, if any, that were modified during the operation are returned
     *         in the response. If set to <code>NONE</code> (the default), no statistics are returned.
     * @see ReturnItemCollectionMetrics
     */
    public String returnItemCollectionMetrics() {
        return returnItemCollectionMetrics;
    }

    /**
     * <p>
     * A condition that must be satisfied in order for a conditional <code>DeleteItem</code> to succeed.
     * </p>
     * <p>
     * An expression can contain any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code>
     * </p>
     * <p>
     * These function names are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Logical operators: <code>AND | OR | NOT</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on condition expressions, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
     * >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return A condition that must be satisfied in order for a conditional <code>DeleteItem</code> to succeed.</p>
     *         <p>
     *         An expression can contain any of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Functions:
     *         <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code>
     *         </p>
     *         <p>
     *         These function names are case-sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Logical operators: <code>AND | OR | NOT</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information on condition expressions, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
     *         >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public String conditionExpression() {
        return conditionExpression;
    }

    /**
     * <p>
     * One or more substitution tokens for attribute names in an expression. The following are some use cases for using
     * <code>ExpressionAttributeNames</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To access an attribute whose name conflicts with a DynamoDB reserved word.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a placeholder for repeating occurrences of an attribute name in an expression.
     * </p>
     * </li>
     * <li>
     * <p>
     * To prevent special characters in an attribute name from being misinterpreted in an expression.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following
     * attribute name:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Percentile</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For
     * the complete list of reserved words, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for
     * <code>ExpressionAttributeNames</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>{"#P":"Percentile"}</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You could then use this substitution in an expression, as in this example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>#P = :val</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for
     * the actual value at runtime.
     * </p>
     * </note>
     * <p>
     * For more information on expression attribute names, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return One or more substitution tokens for attribute names in an expression. The following are some use cases
     *         for using <code>ExpressionAttributeNames</code>:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         To access an attribute whose name conflicts with a DynamoDB reserved word.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To create a placeholder for repeating occurrences of an attribute name in an expression.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To prevent special characters in an attribute name from being misinterpreted in an expression.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the
     *         following attribute name:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Percentile</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The name of this attribute conflicts with a reserved word, so it cannot be used directly in an
     *         expression. (For the complete list of reserved words, see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
     *         Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the
     *         following for <code>ExpressionAttributeNames</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>{"#P":"Percentile"}</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You could then use this substitution in an expression, as in this example:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>#P = :val</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are
     *         placeholders for the actual value at runtime.
     *         </p>
     *         </note>
     *         <p>
     *         For more information on expression attribute names, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     *         >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, String> expressionAttributeNames() {
        return expressionAttributeNames;
    }

    /**
     * <p>
     * One or more values that can be substituted in an expression.
     * </p>
     * <p>
     * Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that
     * you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following:
     * </p>
     * <p>
     * <code>Available | Backordered | Discontinued</code>
     * </p>
     * <p>
     * You would first need to specify <code>ExpressionAttributeValues</code> as follows:
     * </p>
     * <p>
     * <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
     * </p>
     * <p>
     * You could then use these values in an expression, such as this:
     * </p>
     * <p>
     * <code>ProductStatus IN (:avail, :back, :disc)</code>
     * </p>
     * <p>
     * For more information on expression attribute values, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
     * >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return One or more values that can be substituted in an expression.</p>
     *         <p>
     *         Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example,
     *         suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the
     *         following:
     *         </p>
     *         <p>
     *         <code>Available | Backordered | Discontinued</code>
     *         </p>
     *         <p>
     *         You would first need to specify <code>ExpressionAttributeValues</code> as follows:
     *         </p>
     *         <p>
     *         <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
     *         </p>
     *         <p>
     *         You could then use these values in an expression, such as this:
     *         </p>
     *         <p>
     *         <code>ProductStatus IN (:avail, :back, :disc)</code>
     *         </p>
     *         <p>
     *         For more information on expression attribute values, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
     *         >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, AttributeValue> expressionAttributeValues() {
        return expressionAttributeValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tableName() == null) ? 0 : tableName().hashCode());
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((expected() == null) ? 0 : expected().hashCode());
        hashCode = 31 * hashCode + ((conditionalOperator() == null) ? 0 : conditionalOperator().hashCode());
        hashCode = 31 * hashCode + ((returnValues() == null) ? 0 : returnValues().hashCode());
        hashCode = 31 * hashCode + ((returnConsumedCapacity() == null) ? 0 : returnConsumedCapacity().hashCode());
        hashCode = 31 * hashCode + ((returnItemCollectionMetrics() == null) ? 0 : returnItemCollectionMetrics().hashCode());
        hashCode = 31 * hashCode + ((conditionExpression() == null) ? 0 : conditionExpression().hashCode());
        hashCode = 31 * hashCode + ((expressionAttributeNames() == null) ? 0 : expressionAttributeNames().hashCode());
        hashCode = 31 * hashCode + ((expressionAttributeValues() == null) ? 0 : expressionAttributeValues().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteItemRequest)) {
            return false;
        }
        DeleteItemRequest other = (DeleteItemRequest) obj;
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.expected() == null ^ this.expected() == null) {
            return false;
        }
        if (other.expected() != null && !other.expected().equals(this.expected())) {
            return false;
        }
        if (other.conditionalOperator() == null ^ this.conditionalOperator() == null) {
            return false;
        }
        if (other.conditionalOperator() != null && !other.conditionalOperator().equals(this.conditionalOperator())) {
            return false;
        }
        if (other.returnValues() == null ^ this.returnValues() == null) {
            return false;
        }
        if (other.returnValues() != null && !other.returnValues().equals(this.returnValues())) {
            return false;
        }
        if (other.returnConsumedCapacity() == null ^ this.returnConsumedCapacity() == null) {
            return false;
        }
        if (other.returnConsumedCapacity() != null && !other.returnConsumedCapacity().equals(this.returnConsumedCapacity())) {
            return false;
        }
        if (other.returnItemCollectionMetrics() == null ^ this.returnItemCollectionMetrics() == null) {
            return false;
        }
        if (other.returnItemCollectionMetrics() != null
                && !other.returnItemCollectionMetrics().equals(this.returnItemCollectionMetrics())) {
            return false;
        }
        if (other.conditionExpression() == null ^ this.conditionExpression() == null) {
            return false;
        }
        if (other.conditionExpression() != null && !other.conditionExpression().equals(this.conditionExpression())) {
            return false;
        }
        if (other.expressionAttributeNames() == null ^ this.expressionAttributeNames() == null) {
            return false;
        }
        if (other.expressionAttributeNames() != null && !other.expressionAttributeNames().equals(this.expressionAttributeNames())) {
            return false;
        }
        if (other.expressionAttributeValues() == null ^ this.expressionAttributeValues() == null) {
            return false;
        }
        if (other.expressionAttributeValues() != null
                && !other.expressionAttributeValues().equals(this.expressionAttributeValues())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (tableName() != null) {
            sb.append("TableName: ").append(tableName()).append(",");
        }
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (expected() != null) {
            sb.append("Expected: ").append(expected()).append(",");
        }
        if (conditionalOperator() != null) {
            sb.append("ConditionalOperator: ").append(conditionalOperator()).append(",");
        }
        if (returnValues() != null) {
            sb.append("ReturnValues: ").append(returnValues()).append(",");
        }
        if (returnConsumedCapacity() != null) {
            sb.append("ReturnConsumedCapacity: ").append(returnConsumedCapacity()).append(",");
        }
        if (returnItemCollectionMetrics() != null) {
            sb.append("ReturnItemCollectionMetrics: ").append(returnItemCollectionMetrics()).append(",");
        }
        if (conditionExpression() != null) {
            sb.append("ConditionExpression: ").append(conditionExpression()).append(",");
        }
        if (expressionAttributeNames() != null) {
            sb.append("ExpressionAttributeNames: ").append(expressionAttributeNames()).append(",");
        }
        if (expressionAttributeValues() != null) {
            sb.append("ExpressionAttributeValues: ").append(expressionAttributeValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteItemRequest> {
        /**
         * <p>
         * The name of the table from which to delete the item.
         * </p>
         * 
         * @param tableName
         *        The name of the table from which to delete the item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * A map of attribute names to <code>AttributeValue</code> objects, representing the primary key of the item to
         * delete.
         * </p>
         * <p>
         * For the primary key, you must provide all of the attributes. For example, with a simple primary key, you only
         * need to provide a value for the partition key. For a composite primary key, you must provide values for both
         * the partition key and the sort key.
         * </p>
         * 
         * @param key
         *        A map of attribute names to <code>AttributeValue</code> objects, representing the primary key of the
         *        item to delete.</p>
         *        <p>
         *        For the primary key, you must provide all of the attributes. For example, with a simple primary key,
         *        you only need to provide a value for the partition key. For a composite primary key, you must provide
         *        values for both the partition key and the sort key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(Map<String, AttributeValue> key);

        /**
         * <p>
         * This is a legacy parameter. Use <code>ConditionExpresssion</code> instead. For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html"
         * >Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param expected
         *        This is a legacy parameter. Use <code>ConditionExpresssion</code> instead. For more information, see
         *        <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html"
         *        >Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expected(Map<String, ExpectedAttributeValue> expected);

        /**
         * <p>
         * This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param conditionalOperator
         *        This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a
         *        href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         *        >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionalOperator
         */
        Builder conditionalOperator(String conditionalOperator);

        /**
         * <p>
         * This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param conditionalOperator
         *        This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a
         *        href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         *        >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionalOperator
         */
        Builder conditionalOperator(ConditionalOperator conditionalOperator);

        /**
         * <p>
         * Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were
         * deleted. For <code>DeleteItem</code>, the valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then
         * nothing is returned. (This setting is the default for <code>ReturnValues</code>.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL_OLD</code> - The content of the old item is returned.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however,
         * <code>DeleteItem</code> does not recognize any values other than <code>NONE</code> or <code>ALL_OLD</code>.
         * </p>
         * </note>
         * 
         * @param returnValues
         *        Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were
         *        deleted. For <code>DeleteItem</code>, the valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is
         *        <code>NONE</code>, then nothing is returned. (This setting is the default for
         *        <code>ReturnValues</code>.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL_OLD</code> - The content of the old item is returned.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however,
         *        <code>DeleteItem</code> does not recognize any values other than <code>NONE</code> or
         *        <code>ALL_OLD</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnValue
         */
        Builder returnValues(String returnValues);

        /**
         * <p>
         * Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were
         * deleted. For <code>DeleteItem</code>, the valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then
         * nothing is returned. (This setting is the default for <code>ReturnValues</code>.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL_OLD</code> - The content of the old item is returned.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however,
         * <code>DeleteItem</code> does not recognize any values other than <code>NONE</code> or <code>ALL_OLD</code>.
         * </p>
         * </note>
         * 
         * @param returnValues
         *        Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were
         *        deleted. For <code>DeleteItem</code>, the valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is
         *        <code>NONE</code>, then nothing is returned. (This setting is the default for
         *        <code>ReturnValues</code>.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL_OLD</code> - The content of the old item is returned.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however,
         *        <code>DeleteItem</code> does not recognize any values other than <code>NONE</code> or
         *        <code>ALL_OLD</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnValue
         */
        Builder returnValues(ReturnValue returnValues);

        /**
         *
         * @param returnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(String returnConsumedCapacity);

        /**
         *
         * @param returnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity);

        /**
         * <p>
         * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
         * statistics about item collections, if any, that were modified during the operation are returned in the
         * response. If set to <code>NONE</code> (the default), no statistics are returned.
         * </p>
         * 
         * @param returnItemCollectionMetrics
         *        Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
         *        includes statistics about item collections, if any, that were modified during the operation are
         *        returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnItemCollectionMetrics
         */
        Builder returnItemCollectionMetrics(String returnItemCollectionMetrics);

        /**
         * <p>
         * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
         * statistics about item collections, if any, that were modified during the operation are returned in the
         * response. If set to <code>NONE</code> (the default), no statistics are returned.
         * </p>
         * 
         * @param returnItemCollectionMetrics
         *        Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
         *        includes statistics about item collections, if any, that were modified during the operation are
         *        returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnItemCollectionMetrics
         */
        Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics);

        /**
         * <p>
         * A condition that must be satisfied in order for a conditional <code>DeleteItem</code> to succeed.
         * </p>
         * <p>
         * An expression can contain any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Functions:
         * <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code>
         * </p>
         * <p>
         * These function names are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Logical operators: <code>AND | OR | NOT</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information on condition expressions, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
         * >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param conditionExpression
         *        A condition that must be satisfied in order for a conditional <code>DeleteItem</code> to succeed.</p>
         *        <p>
         *        An expression can contain any of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Functions:
         *        <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code>
         *        </p>
         *        <p>
         *        These function names are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Logical operators: <code>AND | OR | NOT</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information on condition expressions, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
         *        >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionExpression(String conditionExpression);

        /**
         * <p>
         * One or more substitution tokens for attribute names in an expression. The following are some use cases for
         * using <code>ExpressionAttributeNames</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To access an attribute whose name conflicts with a DynamoDB reserved word.
         * </p>
         * </li>
         * <li>
         * <p>
         * To create a placeholder for repeating occurrences of an attribute name in an expression.
         * </p>
         * </li>
         * <li>
         * <p>
         * To prevent special characters in an attribute name from being misinterpreted in an expression.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the
         * following attribute name:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Percentile</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression.
         * (For the complete list of reserved words, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a>
         * in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for
         * <code>ExpressionAttributeNames</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>{"#P":"Percentile"}</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You could then use this substitution in an expression, as in this example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>#P = :val</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders
         * for the actual value at runtime.
         * </p>
         * </note>
         * <p>
         * For more information on expression attribute names, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param expressionAttributeNames
         *        One or more substitution tokens for attribute names in an expression. The following are some use cases
         *        for using <code>ExpressionAttributeNames</code>:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        To access an attribute whose name conflicts with a DynamoDB reserved word.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To create a placeholder for repeating occurrences of an attribute name in an expression.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To prevent special characters in an attribute name from being misinterpreted in an expression.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider
         *        the following attribute name:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Percentile</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The name of this attribute conflicts with a reserved word, so it cannot be used directly in an
         *        expression. (For the complete list of reserved words, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
         *        Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the
         *        following for <code>ExpressionAttributeNames</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>{"#P":"Percentile"}</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You could then use this substitution in an expression, as in this example:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>#P = :val</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are
         *        placeholders for the actual value at runtime.
         *        </p>
         *        </note>
         *        <p>
         *        For more information on expression attribute names, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         *        >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionAttributeNames(Map<String, String> expressionAttributeNames);

        /**
         * <p>
         * One or more values that can be substituted in an expression.
         * </p>
         * <p>
         * Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose
         * that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following:
         * </p>
         * <p>
         * <code>Available | Backordered | Discontinued</code>
         * </p>
         * <p>
         * You would first need to specify <code>ExpressionAttributeValues</code> as follows:
         * </p>
         * <p>
         * <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
         * </p>
         * <p>
         * You could then use these values in an expression, such as this:
         * </p>
         * <p>
         * <code>ProductStatus IN (:avail, :back, :disc)</code>
         * </p>
         * <p>
         * For more information on expression attribute values, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
         * >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param expressionAttributeValues
         *        One or more values that can be substituted in an expression.</p>
         *        <p>
         *        Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example,
         *        suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of
         *        the following:
         *        </p>
         *        <p>
         *        <code>Available | Backordered | Discontinued</code>
         *        </p>
         *        <p>
         *        You would first need to specify <code>ExpressionAttributeValues</code> as follows:
         *        </p>
         *        <p>
         *        <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
         *        </p>
         *        <p>
         *        You could then use these values in an expression, such as this:
         *        </p>
         *        <p>
         *        <code>ProductStatus IN (:avail, :back, :disc)</code>
         *        </p>
         *        <p>
         *        For more information on expression attribute values, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
         *        >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues);
    }

    private static final class BuilderImpl implements Builder {
        private String tableName;

        private Map<String, AttributeValue> key;

        private Map<String, ExpectedAttributeValue> expected;

        private String conditionalOperator;

        private String returnValues;

        private String returnConsumedCapacity;

        private String returnItemCollectionMetrics;

        private String conditionExpression;

        private Map<String, String> expressionAttributeNames;

        private Map<String, AttributeValue> expressionAttributeValues;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteItemRequest model) {
            setTableName(model.tableName);
            setKey(model.key);
            setExpected(model.expected);
            setConditionalOperator(model.conditionalOperator);
            setReturnValues(model.returnValues);
            setReturnConsumedCapacity(model.returnConsumedCapacity);
            setReturnItemCollectionMetrics(model.returnItemCollectionMetrics);
            setConditionExpression(model.conditionExpression);
            setExpressionAttributeNames(model.expressionAttributeNames);
            setExpressionAttributeValues(model.expressionAttributeValues);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Map<String, AttributeValue> getKey() {
            return key;
        }

        @Override
        public final Builder key(Map<String, AttributeValue> key) {
            this.key = KeyCopier.copy(key);
            return this;
        }

        public final void setKey(Map<String, AttributeValue> key) {
            this.key = KeyCopier.copy(key);
        }

        public final Map<String, ExpectedAttributeValue> getExpected() {
            return expected;
        }

        @Override
        public final Builder expected(Map<String, ExpectedAttributeValue> expected) {
            this.expected = ExpectedAttributeMapCopier.copy(expected);
            return this;
        }

        public final void setExpected(Map<String, ExpectedAttributeValue> expected) {
            this.expected = ExpectedAttributeMapCopier.copy(expected);
        }

        public final String getConditionalOperator() {
            return conditionalOperator;
        }

        @Override
        public final Builder conditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
            return this;
        }

        @Override
        public final Builder conditionalOperator(ConditionalOperator conditionalOperator) {
            this.conditionalOperator(conditionalOperator.toString());
            return this;
        }

        public final void setConditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
        }

        public final void setConditionalOperator(ConditionalOperator conditionalOperator) {
            this.conditionalOperator(conditionalOperator.toString());
        }

        public final String getReturnValues() {
            return returnValues;
        }

        @Override
        public final Builder returnValues(String returnValues) {
            this.returnValues = returnValues;
            return this;
        }

        @Override
        public final Builder returnValues(ReturnValue returnValues) {
            this.returnValues(returnValues.toString());
            return this;
        }

        public final void setReturnValues(String returnValues) {
            this.returnValues = returnValues;
        }

        public final void setReturnValues(ReturnValue returnValues) {
            this.returnValues(returnValues.toString());
        }

        public final String getReturnConsumedCapacity() {
            return returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
        }

        public final String getReturnItemCollectionMetrics() {
            return returnItemCollectionMetrics;
        }

        @Override
        public final Builder returnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        @Override
        public final Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics(returnItemCollectionMetrics.toString());
            return this;
        }

        public final void setReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
        }

        public final void setReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics(returnItemCollectionMetrics.toString());
        }

        public final String getConditionExpression() {
            return conditionExpression;
        }

        @Override
        public final Builder conditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public final void setConditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public final Map<String, AttributeValue> getExpressionAttributeValues() {
            return expressionAttributeValues;
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
        }

        @Override
        public DeleteItemRequest build() {
            return new DeleteItemRequest(this);
        }
    }
}
