/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

@Generated("software.amazon.awssdk:codegen")
final class KeyListCopier {
    static List<Map<String, AttributeValue>> copy(Collection<Map<String, AttributeValue>> keyListParam) {
        if (keyListParam == null) {
            return null;
        }
        List<Map<String, AttributeValue>> keyListParamCopy = new ArrayList<>(keyListParam.size());
        for (Map<String, AttributeValue> e : keyListParam) {
            keyListParamCopy.add(KeyCopier.copy(e));
        }
        return keyListParamCopy;
    }
}
