/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.dynamodb.transform.ProvisionedThroughputDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the provisioned throughput settings for the table, consisting of read and write capacity units, along with
 * data about increases and decreases.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ProvisionedThroughputDescription implements StructuredPojo,
        ToCopyableBuilder<ProvisionedThroughputDescription.Builder, ProvisionedThroughputDescription> {
    private final Date lastIncreaseDateTime;

    private final Date lastDecreaseDateTime;

    private final Long numberOfDecreasesToday;

    private final Long readCapacityUnits;

    private final Long writeCapacityUnits;

    private ProvisionedThroughputDescription(BuilderImpl builder) {
        this.lastIncreaseDateTime = builder.lastIncreaseDateTime;
        this.lastDecreaseDateTime = builder.lastDecreaseDateTime;
        this.numberOfDecreasesToday = builder.numberOfDecreasesToday;
        this.readCapacityUnits = builder.readCapacityUnits;
        this.writeCapacityUnits = builder.writeCapacityUnits;
    }

    /**
     * <p>
     * The date and time of the last provisioned throughput increase for this table.
     * </p>
     * 
     * @return The date and time of the last provisioned throughput increase for this table.
     */
    public Date lastIncreaseDateTime() {
        return lastIncreaseDateTime;
    }

    /**
     * <p>
     * The date and time of the last provisioned throughput decrease for this table.
     * </p>
     * 
     * @return The date and time of the last provisioned throughput decrease for this table.
     */
    public Date lastDecreaseDateTime() {
        return lastDecreaseDateTime;
    }

    /**
     * <p>
     * The number of provisioned throughput decreases for this table during this UTC calendar day. For current maximums
     * on provisioned throughput decreases, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the <i>Amazon
     * DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The number of provisioned throughput decreases for this table during this UTC calendar day. For current
     *         maximums on provisioned throughput decreases, see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
     *         <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Long numberOfDecreasesToday() {
        return numberOfDecreasesToday;
    }

    /**
     * <p>
     * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     * <code>ThrottlingException</code>. Eventually consistent reads require less effort than strongly consistent reads,
     * so a setting of 50 <code>ReadCapacityUnits</code> per second provides 100 eventually consistent
     * <code>ReadCapacityUnits</code> per second.
     * </p>
     * 
     * @return The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     *         <code>ThrottlingException</code>. Eventually consistent reads require less effort than strongly
     *         consistent reads, so a setting of 50 <code>ReadCapacityUnits</code> per second provides 100 eventually
     *         consistent <code>ReadCapacityUnits</code> per second.
     */
    public Long readCapacityUnits() {
        return readCapacityUnits;
    }

    /**
     * <p>
     * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.
     * </p>
     * 
     * @return The maximum number of writes consumed per second before DynamoDB returns a
     *         <code>ThrottlingException</code>.
     */
    public Long writeCapacityUnits() {
        return writeCapacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((lastIncreaseDateTime() == null) ? 0 : lastIncreaseDateTime().hashCode());
        hashCode = 31 * hashCode + ((lastDecreaseDateTime() == null) ? 0 : lastDecreaseDateTime().hashCode());
        hashCode = 31 * hashCode + ((numberOfDecreasesToday() == null) ? 0 : numberOfDecreasesToday().hashCode());
        hashCode = 31 * hashCode + ((readCapacityUnits() == null) ? 0 : readCapacityUnits().hashCode());
        hashCode = 31 * hashCode + ((writeCapacityUnits() == null) ? 0 : writeCapacityUnits().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedThroughputDescription)) {
            return false;
        }
        ProvisionedThroughputDescription other = (ProvisionedThroughputDescription) obj;
        if (other.lastIncreaseDateTime() == null ^ this.lastIncreaseDateTime() == null) {
            return false;
        }
        if (other.lastIncreaseDateTime() != null && !other.lastIncreaseDateTime().equals(this.lastIncreaseDateTime())) {
            return false;
        }
        if (other.lastDecreaseDateTime() == null ^ this.lastDecreaseDateTime() == null) {
            return false;
        }
        if (other.lastDecreaseDateTime() != null && !other.lastDecreaseDateTime().equals(this.lastDecreaseDateTime())) {
            return false;
        }
        if (other.numberOfDecreasesToday() == null ^ this.numberOfDecreasesToday() == null) {
            return false;
        }
        if (other.numberOfDecreasesToday() != null && !other.numberOfDecreasesToday().equals(this.numberOfDecreasesToday())) {
            return false;
        }
        if (other.readCapacityUnits() == null ^ this.readCapacityUnits() == null) {
            return false;
        }
        if (other.readCapacityUnits() != null && !other.readCapacityUnits().equals(this.readCapacityUnits())) {
            return false;
        }
        if (other.writeCapacityUnits() == null ^ this.writeCapacityUnits() == null) {
            return false;
        }
        if (other.writeCapacityUnits() != null && !other.writeCapacityUnits().equals(this.writeCapacityUnits())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (lastIncreaseDateTime() != null) {
            sb.append("LastIncreaseDateTime: ").append(lastIncreaseDateTime()).append(",");
        }
        if (lastDecreaseDateTime() != null) {
            sb.append("LastDecreaseDateTime: ").append(lastDecreaseDateTime()).append(",");
        }
        if (numberOfDecreasesToday() != null) {
            sb.append("NumberOfDecreasesToday: ").append(numberOfDecreasesToday()).append(",");
        }
        if (readCapacityUnits() != null) {
            sb.append("ReadCapacityUnits: ").append(readCapacityUnits()).append(",");
        }
        if (writeCapacityUnits() != null) {
            sb.append("WriteCapacityUnits: ").append(writeCapacityUnits()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProvisionedThroughputDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ProvisionedThroughputDescription> {
        /**
         * <p>
         * The date and time of the last provisioned throughput increase for this table.
         * </p>
         * 
         * @param lastIncreaseDateTime
         *        The date and time of the last provisioned throughput increase for this table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastIncreaseDateTime(Date lastIncreaseDateTime);

        /**
         * <p>
         * The date and time of the last provisioned throughput decrease for this table.
         * </p>
         * 
         * @param lastDecreaseDateTime
         *        The date and time of the last provisioned throughput decrease for this table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDecreaseDateTime(Date lastDecreaseDateTime);

        /**
         * <p>
         * The number of provisioned throughput decreases for this table during this UTC calendar day. For current
         * maximums on provisioned throughput decreases, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
         * <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param numberOfDecreasesToday
         *        The number of provisioned throughput decreases for this table during this UTC calendar day. For
         *        current maximums on provisioned throughput decreases, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
         *        <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDecreasesToday(Long numberOfDecreasesToday);

        /**
         * <p>
         * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         * <code>ThrottlingException</code>. Eventually consistent reads require less effort than strongly consistent
         * reads, so a setting of 50 <code>ReadCapacityUnits</code> per second provides 100 eventually consistent
         * <code>ReadCapacityUnits</code> per second.
         * </p>
         * 
         * @param readCapacityUnits
         *        The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         *        <code>ThrottlingException</code>. Eventually consistent reads require less effort than strongly
         *        consistent reads, so a setting of 50 <code>ReadCapacityUnits</code> per second provides 100 eventually
         *        consistent <code>ReadCapacityUnits</code> per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readCapacityUnits(Long readCapacityUnits);

        /**
         * <p>
         * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.
         * </p>
         * 
         * @param writeCapacityUnits
         *        The maximum number of writes consumed per second before DynamoDB returns a
         *        <code>ThrottlingException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeCapacityUnits(Long writeCapacityUnits);
    }

    private static final class BuilderImpl implements Builder {
        private Date lastIncreaseDateTime;

        private Date lastDecreaseDateTime;

        private Long numberOfDecreasesToday;

        private Long readCapacityUnits;

        private Long writeCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedThroughputDescription model) {
            setLastIncreaseDateTime(model.lastIncreaseDateTime);
            setLastDecreaseDateTime(model.lastDecreaseDateTime);
            setNumberOfDecreasesToday(model.numberOfDecreasesToday);
            setReadCapacityUnits(model.readCapacityUnits);
            setWriteCapacityUnits(model.writeCapacityUnits);
        }

        public final Date getLastIncreaseDateTime() {
            return lastIncreaseDateTime;
        }

        @Override
        public final Builder lastIncreaseDateTime(Date lastIncreaseDateTime) {
            this.lastIncreaseDateTime = StandardMemberCopier.copy(lastIncreaseDateTime);
            return this;
        }

        public final void setLastIncreaseDateTime(Date lastIncreaseDateTime) {
            this.lastIncreaseDateTime = StandardMemberCopier.copy(lastIncreaseDateTime);
        }

        public final Date getLastDecreaseDateTime() {
            return lastDecreaseDateTime;
        }

        @Override
        public final Builder lastDecreaseDateTime(Date lastDecreaseDateTime) {
            this.lastDecreaseDateTime = StandardMemberCopier.copy(lastDecreaseDateTime);
            return this;
        }

        public final void setLastDecreaseDateTime(Date lastDecreaseDateTime) {
            this.lastDecreaseDateTime = StandardMemberCopier.copy(lastDecreaseDateTime);
        }

        public final Long getNumberOfDecreasesToday() {
            return numberOfDecreasesToday;
        }

        @Override
        public final Builder numberOfDecreasesToday(Long numberOfDecreasesToday) {
            this.numberOfDecreasesToday = numberOfDecreasesToday;
            return this;
        }

        public final void setNumberOfDecreasesToday(Long numberOfDecreasesToday) {
            this.numberOfDecreasesToday = numberOfDecreasesToday;
        }

        public final Long getReadCapacityUnits() {
            return readCapacityUnits;
        }

        @Override
        public final Builder readCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
            return this;
        }

        public final void setReadCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
        }

        public final Long getWriteCapacityUnits() {
            return writeCapacityUnits;
        }

        @Override
        public final Builder writeCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
            return this;
        }

        public final void setWriteCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
        }

        @Override
        public ProvisionedThroughputDescription build() {
            return new ProvisionedThroughputDescription(this);
        }
    }
}
