/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.dynamodb.transform.StreamDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents all of the data describing a particular stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StreamDescription implements StructuredPojo, ToCopyableBuilder<StreamDescription.Builder, StreamDescription> {
    private final String streamArn;

    private final String streamLabel;

    private final String streamStatus;

    private final String streamViewType;

    private final Date creationRequestDateTime;

    private final String tableName;

    private final List<KeySchemaElement> keySchema;

    private final List<Shard> shards;

    private final String lastEvaluatedShardId;

    private StreamDescription(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.streamLabel = builder.streamLabel;
        this.streamStatus = builder.streamStatus;
        this.streamViewType = builder.streamViewType;
        this.creationRequestDateTime = builder.creationRequestDateTime;
        this.tableName = builder.tableName;
        this.keySchema = builder.keySchema;
        this.shards = builder.shards;
        this.lastEvaluatedShardId = builder.lastEvaluatedShardId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the stream.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the stream.
     */
    public String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * A timestamp, in ISO 8601 format, for this stream.
     * </p>
     * <p>
     * Note that <code>LatestStreamLabel</code> is not a unique identifier for the stream, because it is possible that a
     * stream from another table might have the same timestamp. However, the combination of the following three elements
     * is guaranteed to be unique:
     * </p>
     * <ul>
     * <li>
     * <p>
     * the AWS customer ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * the table name
     * </p>
     * </li>
     * <li>
     * <p>
     * the <code>StreamLabel</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return A timestamp, in ISO 8601 format, for this stream.</p>
     *         <p>
     *         Note that <code>LatestStreamLabel</code> is not a unique identifier for the stream, because it is
     *         possible that a stream from another table might have the same timestamp. However, the combination of the
     *         following three elements is guaranteed to be unique:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         the AWS customer ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         the table name
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         the <code>StreamLabel</code>
     *         </p>
     *         </li>
     */
    public String streamLabel() {
        return streamLabel;
    }

    /**
     * <p>
     * Indicates the current status of the stream:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLING</code> - Streams is currently being enabled on the DynamoDB table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ENABLED</code> - the stream is enabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLING</code> - Streams is currently being disabled on the DynamoDB table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - the stream is disabled.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates the current status of the stream:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLING</code> - Streams is currently being enabled on the DynamoDB table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - the stream is enabled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLING</code> - Streams is currently being disabled on the DynamoDB table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - the stream is disabled.
     *         </p>
     *         </li>
     * @see StreamStatus
     */
    public String streamStatus() {
        return streamStatus;
    }

    /**
     * <p>
     * Indicates the format of the records within this stream:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KEYS_ONLY</code> - only the key attributes of items that were modified in the DynamoDB table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_IMAGE</code> - entire items from the table, as they appeared after they were modified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OLD_IMAGE</code> - entire items from the table, as they appeared before they were modified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NEW_AND_OLD_IMAGES</code> - both the new and the old images of the items from the table.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates the format of the records within this stream:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>KEYS_ONLY</code> - only the key attributes of items that were modified in the DynamoDB table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_IMAGE</code> - entire items from the table, as they appeared after they were modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OLD_IMAGE</code> - entire items from the table, as they appeared before they were modified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NEW_AND_OLD_IMAGES</code> - both the new and the old images of the items from the table.
     *         </p>
     *         </li>
     * @see StreamViewType
     */
    public String streamViewType() {
        return streamViewType;
    }

    /**
     * <p>
     * The date and time when the request to create this stream was issued.
     * </p>
     * 
     * @return The date and time when the request to create this stream was issued.
     */
    public Date creationRequestDateTime() {
        return creationRequestDateTime;
    }

    /**
     * <p>
     * The DynamoDB table with which the stream is associated.
     * </p>
     * 
     * @return The DynamoDB table with which the stream is associated.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The key attribute(s) of the stream's DynamoDB table.
     * </p>
     * 
     * @return The key attribute(s) of the stream's DynamoDB table.
     */
    public List<KeySchemaElement> keySchema() {
        return keySchema;
    }

    /**
     * <p>
     * The shards that comprise the stream.
     * </p>
     * 
     * @return The shards that comprise the stream.
     */
    public List<Shard> shards() {
        return shards;
    }

    /**
     * <p>
     * The shard ID of the item where the operation stopped, inclusive of the previous result set. Use this value to
     * start a new operation, excluding this value in the new request.
     * </p>
     * <p>
     * If <code>LastEvaluatedShardId</code> is empty, then the "last page" of results has been processed and there is
     * currently no more data to be retrieved.
     * </p>
     * <p>
     * If <code>LastEvaluatedShardId</code> is not empty, it does not necessarily mean that there is more data in the
     * result set. The only way to know when you have reached the end of the result set is when
     * <code>LastEvaluatedShardId</code> is empty.
     * </p>
     * 
     * @return The shard ID of the item where the operation stopped, inclusive of the previous result set. Use this
     *         value to start a new operation, excluding this value in the new request.</p>
     *         <p>
     *         If <code>LastEvaluatedShardId</code> is empty, then the "last page" of results has been processed and
     *         there is currently no more data to be retrieved.
     *         </p>
     *         <p>
     *         If <code>LastEvaluatedShardId</code> is not empty, it does not necessarily mean that there is more data
     *         in the result set. The only way to know when you have reached the end of the result set is when
     *         <code>LastEvaluatedShardId</code> is empty.
     */
    public String lastEvaluatedShardId() {
        return lastEvaluatedShardId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamArn() == null) ? 0 : streamArn().hashCode());
        hashCode = 31 * hashCode + ((streamLabel() == null) ? 0 : streamLabel().hashCode());
        hashCode = 31 * hashCode + ((streamStatus() == null) ? 0 : streamStatus().hashCode());
        hashCode = 31 * hashCode + ((streamViewType() == null) ? 0 : streamViewType().hashCode());
        hashCode = 31 * hashCode + ((creationRequestDateTime() == null) ? 0 : creationRequestDateTime().hashCode());
        hashCode = 31 * hashCode + ((tableName() == null) ? 0 : tableName().hashCode());
        hashCode = 31 * hashCode + ((keySchema() == null) ? 0 : keySchema().hashCode());
        hashCode = 31 * hashCode + ((shards() == null) ? 0 : shards().hashCode());
        hashCode = 31 * hashCode + ((lastEvaluatedShardId() == null) ? 0 : lastEvaluatedShardId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamDescription)) {
            return false;
        }
        StreamDescription other = (StreamDescription) obj;
        if (other.streamArn() == null ^ this.streamArn() == null) {
            return false;
        }
        if (other.streamArn() != null && !other.streamArn().equals(this.streamArn())) {
            return false;
        }
        if (other.streamLabel() == null ^ this.streamLabel() == null) {
            return false;
        }
        if (other.streamLabel() != null && !other.streamLabel().equals(this.streamLabel())) {
            return false;
        }
        if (other.streamStatus() == null ^ this.streamStatus() == null) {
            return false;
        }
        if (other.streamStatus() != null && !other.streamStatus().equals(this.streamStatus())) {
            return false;
        }
        if (other.streamViewType() == null ^ this.streamViewType() == null) {
            return false;
        }
        if (other.streamViewType() != null && !other.streamViewType().equals(this.streamViewType())) {
            return false;
        }
        if (other.creationRequestDateTime() == null ^ this.creationRequestDateTime() == null) {
            return false;
        }
        if (other.creationRequestDateTime() != null && !other.creationRequestDateTime().equals(this.creationRequestDateTime())) {
            return false;
        }
        if (other.tableName() == null ^ this.tableName() == null) {
            return false;
        }
        if (other.tableName() != null && !other.tableName().equals(this.tableName())) {
            return false;
        }
        if (other.keySchema() == null ^ this.keySchema() == null) {
            return false;
        }
        if (other.keySchema() != null && !other.keySchema().equals(this.keySchema())) {
            return false;
        }
        if (other.shards() == null ^ this.shards() == null) {
            return false;
        }
        if (other.shards() != null && !other.shards().equals(this.shards())) {
            return false;
        }
        if (other.lastEvaluatedShardId() == null ^ this.lastEvaluatedShardId() == null) {
            return false;
        }
        if (other.lastEvaluatedShardId() != null && !other.lastEvaluatedShardId().equals(this.lastEvaluatedShardId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (streamArn() != null) {
            sb.append("StreamArn: ").append(streamArn()).append(",");
        }
        if (streamLabel() != null) {
            sb.append("StreamLabel: ").append(streamLabel()).append(",");
        }
        if (streamStatus() != null) {
            sb.append("StreamStatus: ").append(streamStatus()).append(",");
        }
        if (streamViewType() != null) {
            sb.append("StreamViewType: ").append(streamViewType()).append(",");
        }
        if (creationRequestDateTime() != null) {
            sb.append("CreationRequestDateTime: ").append(creationRequestDateTime()).append(",");
        }
        if (tableName() != null) {
            sb.append("TableName: ").append(tableName()).append(",");
        }
        if (keySchema() != null) {
            sb.append("KeySchema: ").append(keySchema()).append(",");
        }
        if (shards() != null) {
            sb.append("Shards: ").append(shards()).append(",");
        }
        if (lastEvaluatedShardId() != null) {
            sb.append("LastEvaluatedShardId: ").append(lastEvaluatedShardId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, StreamDescription> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the stream.
         * </p>
         * 
         * @param streamArn
         *        The Amazon Resource Name (ARN) for the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * A timestamp, in ISO 8601 format, for this stream.
         * </p>
         * <p>
         * Note that <code>LatestStreamLabel</code> is not a unique identifier for the stream, because it is possible
         * that a stream from another table might have the same timestamp. However, the combination of the following
         * three elements is guaranteed to be unique:
         * </p>
         * <ul>
         * <li>
         * <p>
         * the AWS customer ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * the table name
         * </p>
         * </li>
         * <li>
         * <p>
         * the <code>StreamLabel</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param streamLabel
         *        A timestamp, in ISO 8601 format, for this stream.</p>
         *        <p>
         *        Note that <code>LatestStreamLabel</code> is not a unique identifier for the stream, because it is
         *        possible that a stream from another table might have the same timestamp. However, the combination of
         *        the following three elements is guaranteed to be unique:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        the AWS customer ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        the table name
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        the <code>StreamLabel</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamLabel(String streamLabel);

        /**
         * <p>
         * Indicates the current status of the stream:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLING</code> - Streams is currently being enabled on the DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED</code> - the stream is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLING</code> - Streams is currently being disabled on the DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - the stream is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param streamStatus
         *        Indicates the current status of the stream:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLING</code> - Streams is currently being enabled on the DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - the stream is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLING</code> - Streams is currently being disabled on the DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - the stream is disabled.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamStatus
         */
        Builder streamStatus(String streamStatus);

        /**
         * <p>
         * Indicates the current status of the stream:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLING</code> - Streams is currently being enabled on the DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ENABLED</code> - the stream is enabled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLING</code> - Streams is currently being disabled on the DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - the stream is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param streamStatus
         *        Indicates the current status of the stream:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLING</code> - Streams is currently being enabled on the DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - the stream is enabled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLING</code> - Streams is currently being disabled on the DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - the stream is disabled.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamStatus
         */
        Builder streamStatus(StreamStatus streamStatus);

        /**
         * <p>
         * Indicates the format of the records within this stream:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - only the key attributes of items that were modified in the DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_IMAGE</code> - entire items from the table, as they appeared after they were modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OLD_IMAGE</code> - entire items from the table, as they appeared before they were modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_AND_OLD_IMAGES</code> - both the new and the old images of the items from the table.
         * </p>
         * </li>
         * </ul>
         * 
         * @param streamViewType
         *        Indicates the format of the records within this stream:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - only the key attributes of items that were modified in the DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_IMAGE</code> - entire items from the table, as they appeared after they were modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OLD_IMAGE</code> - entire items from the table, as they appeared before they were modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_AND_OLD_IMAGES</code> - both the new and the old images of the items from the table.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamViewType
         */
        Builder streamViewType(String streamViewType);

        /**
         * <p>
         * Indicates the format of the records within this stream:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>KEYS_ONLY</code> - only the key attributes of items that were modified in the DynamoDB table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_IMAGE</code> - entire items from the table, as they appeared after they were modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OLD_IMAGE</code> - entire items from the table, as they appeared before they were modified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NEW_AND_OLD_IMAGES</code> - both the new and the old images of the items from the table.
         * </p>
         * </li>
         * </ul>
         * 
         * @param streamViewType
         *        Indicates the format of the records within this stream:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>KEYS_ONLY</code> - only the key attributes of items that were modified in the DynamoDB table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_IMAGE</code> - entire items from the table, as they appeared after they were modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OLD_IMAGE</code> - entire items from the table, as they appeared before they were modified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NEW_AND_OLD_IMAGES</code> - both the new and the old images of the items from the table.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamViewType
         */
        Builder streamViewType(StreamViewType streamViewType);

        /**
         * <p>
         * The date and time when the request to create this stream was issued.
         * </p>
         * 
         * @param creationRequestDateTime
         *        The date and time when the request to create this stream was issued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationRequestDateTime(Date creationRequestDateTime);

        /**
         * <p>
         * The DynamoDB table with which the stream is associated.
         * </p>
         * 
         * @param tableName
         *        The DynamoDB table with which the stream is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The key attribute(s) of the stream's DynamoDB table.
         * </p>
         * 
         * @param keySchema
         *        The key attribute(s) of the stream's DynamoDB table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(Collection<KeySchemaElement> keySchema);

        /**
         * <p>
         * The key attribute(s) of the stream's DynamoDB table.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setKeySchema(java.util.Collection)} or {@link #withKeySchema(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param keySchema
         *        The key attribute(s) of the stream's DynamoDB table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(KeySchemaElement... keySchema);

        /**
         * <p>
         * The shards that comprise the stream.
         * </p>
         * 
         * @param shards
         *        The shards that comprise the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shards(Collection<Shard> shards);

        /**
         * <p>
         * The shards that comprise the stream.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setShards(java.util.Collection)} or {@link #withShards(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param shards
         *        The shards that comprise the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shards(Shard... shards);

        /**
         * <p>
         * The shard ID of the item where the operation stopped, inclusive of the previous result set. Use this value to
         * start a new operation, excluding this value in the new request.
         * </p>
         * <p>
         * If <code>LastEvaluatedShardId</code> is empty, then the "last page" of results has been processed and there
         * is currently no more data to be retrieved.
         * </p>
         * <p>
         * If <code>LastEvaluatedShardId</code> is not empty, it does not necessarily mean that there is more data in
         * the result set. The only way to know when you have reached the end of the result set is when
         * <code>LastEvaluatedShardId</code> is empty.
         * </p>
         * 
         * @param lastEvaluatedShardId
         *        The shard ID of the item where the operation stopped, inclusive of the previous result set. Use this
         *        value to start a new operation, excluding this value in the new request.</p>
         *        <p>
         *        If <code>LastEvaluatedShardId</code> is empty, then the "last page" of results has been processed and
         *        there is currently no more data to be retrieved.
         *        </p>
         *        <p>
         *        If <code>LastEvaluatedShardId</code> is not empty, it does not necessarily mean that there is more
         *        data in the result set. The only way to know when you have reached the end of the result set is when
         *        <code>LastEvaluatedShardId</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluatedShardId(String lastEvaluatedShardId);
    }

    private static final class BuilderImpl implements Builder {
        private String streamArn;

        private String streamLabel;

        private String streamStatus;

        private String streamViewType;

        private Date creationRequestDateTime;

        private String tableName;

        private List<KeySchemaElement> keySchema;

        private List<Shard> shards;

        private String lastEvaluatedShardId;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamDescription model) {
            setStreamArn(model.streamArn);
            setStreamLabel(model.streamLabel);
            setStreamStatus(model.streamStatus);
            setStreamViewType(model.streamViewType);
            setCreationRequestDateTime(model.creationRequestDateTime);
            setTableName(model.tableName);
            setKeySchema(model.keySchema);
            setShards(model.shards);
            setLastEvaluatedShardId(model.lastEvaluatedShardId);
        }

        public final String getStreamArn() {
            return streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final String getStreamLabel() {
            return streamLabel;
        }

        @Override
        public final Builder streamLabel(String streamLabel) {
            this.streamLabel = streamLabel;
            return this;
        }

        public final void setStreamLabel(String streamLabel) {
            this.streamLabel = streamLabel;
        }

        public final String getStreamStatus() {
            return streamStatus;
        }

        @Override
        public final Builder streamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
            return this;
        }

        @Override
        public final Builder streamStatus(StreamStatus streamStatus) {
            this.streamStatus(streamStatus.toString());
            return this;
        }

        public final void setStreamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
        }

        public final void setStreamStatus(StreamStatus streamStatus) {
            this.streamStatus(streamStatus.toString());
        }

        public final String getStreamViewType() {
            return streamViewType;
        }

        @Override
        public final Builder streamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
            return this;
        }

        @Override
        public final Builder streamViewType(StreamViewType streamViewType) {
            this.streamViewType(streamViewType.toString());
            return this;
        }

        public final void setStreamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
        }

        public final void setStreamViewType(StreamViewType streamViewType) {
            this.streamViewType(streamViewType.toString());
        }

        public final Date getCreationRequestDateTime() {
            return creationRequestDateTime;
        }

        @Override
        public final Builder creationRequestDateTime(Date creationRequestDateTime) {
            this.creationRequestDateTime = StandardMemberCopier.copy(creationRequestDateTime);
            return this;
        }

        public final void setCreationRequestDateTime(Date creationRequestDateTime) {
            this.creationRequestDateTime = StandardMemberCopier.copy(creationRequestDateTime);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Collection<KeySchemaElement> getKeySchema() {
            return keySchema;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement... keySchema) {
            if (this.keySchema == null) {
                this.keySchema = new ArrayList<>(keySchema.length);
            }
            for (KeySchemaElement e : keySchema) {
                this.keySchema.add(e);
            }
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
        }

        @SafeVarargs
        public final void setKeySchema(KeySchemaElement... keySchema) {
            if (this.keySchema == null) {
                this.keySchema = new ArrayList<>(keySchema.length);
            }
            for (KeySchemaElement e : keySchema) {
                this.keySchema.add(e);
            }
        }

        public final Collection<Shard> getShards() {
            return shards;
        }

        @Override
        public final Builder shards(Collection<Shard> shards) {
            this.shards = ShardDescriptionListCopier.copy(shards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Shard... shards) {
            if (this.shards == null) {
                this.shards = new ArrayList<>(shards.length);
            }
            for (Shard e : shards) {
                this.shards.add(e);
            }
            return this;
        }

        public final void setShards(Collection<Shard> shards) {
            this.shards = ShardDescriptionListCopier.copy(shards);
        }

        @SafeVarargs
        public final void setShards(Shard... shards) {
            if (this.shards == null) {
                this.shards = new ArrayList<>(shards.length);
            }
            for (Shard e : shards) {
                this.shards.add(e);
            }
        }

        public final String getLastEvaluatedShardId() {
            return lastEvaluatedShardId;
        }

        @Override
        public final Builder lastEvaluatedShardId(String lastEvaluatedShardId) {
            this.lastEvaluatedShardId = lastEvaluatedShardId;
            return this;
        }

        public final void setLastEvaluatedShardId(String lastEvaluatedShardId) {
            this.lastEvaluatedShardId = lastEvaluatedShardId;
        }

        @Override
        public StreamDescription build() {
            return new StreamDescription(this);
        }
    }
}
