/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDb;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperFieldModel;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverted;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverter;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTyped;

@DynamoDb
@DynamoDbTypeConverted(converter=Converter.class)
@DynamoDbTyped(value=DynamoDbMapperFieldModel.DynamoDbAttributeType.S)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.ANNOTATION_TYPE})
public @interface DynamoDbConvertedBool {
    public Format value();

    public static final class Converter
    implements DynamoDbTypeConverter<String, Boolean> {
        private final String valueTrue;
        private final String valueFalse;

        public Converter(Class<Boolean> targetType, DynamoDbConvertedBool annotation) {
            this.valueTrue = annotation.value().name().split("_")[0];
            this.valueFalse = annotation.value().name().split("_")[1];
        }

        @Override
        public final String convert(Boolean object) {
            return Boolean.TRUE.equals(object) ? this.valueTrue : this.valueFalse;
        }

        @Override
        public final Boolean unconvert(String object) {
            return this.valueTrue.equals(object) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public static enum Format {
        true_false,
        T_F,
        Y_N;

    }
}

