/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperFieldModel;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMappingException;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverted;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverter;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTyped;

@DynamoDbTypeConverted(converter=Converter.class)
@DynamoDbTyped(value=DynamoDbMapperFieldModel.DynamoDbAttributeType.S)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD})
public @interface DynamoDbTypeConvertedJson {
    public Class<? extends Object> targetType() default void.class;

    public static final class Converter<T>
    implements DynamoDbTypeConverter<String, T> {
        private static final ObjectMapper MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        private final Class<T> targetType;

        public Converter(Class<T> targetType, DynamoDbTypeConvertedJson annotation) {
            this.targetType = annotation.targetType() == Void.TYPE ? targetType : annotation.targetType();
        }

        @Override
        public final String convert(T object) {
            try {
                return MAPPER.writeValueAsString(object);
            }
            catch (Exception e) {
                throw new DynamoDbMappingException("Unable to write object to JSON", e);
            }
        }

        @Override
        public final T unconvert(String object) {
            try {
                return (T)MAPPER.readValue(object, this.targetType);
            }
            catch (Exception e) {
                throw new DynamoDbMappingException("Unable to read JSON string", e);
            }
        }
    }
}

