/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.util.List;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapper;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperConfig;
import software.amazon.awssdk.services.dynamodb.datamodeling.PaginatedList;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

public class PaginatedScanList<T>
extends PaginatedList<T> {
    private ScanRequest scanRequest;
    private final DynamoDbMapperConfig config;
    private ScanResponse scanResult;

    public PaginatedScanList(DynamoDbMapper mapper, Class<T> clazz, DynamoDBClient dynamo, ScanRequest scanRequest, ScanResponse scanResult, DynamoDbMapperConfig.PaginationLoadingStrategy paginationLoadingStrategy, DynamoDbMapperConfig config) {
        super(mapper, clazz, dynamo, paginationLoadingStrategy);
        this.scanRequest = scanRequest;
        this.scanResult = scanResult;
        this.config = config;
        this.allResults.addAll(mapper.marshallIntoObjects(mapper.toParameters(scanResult.items(), clazz, scanRequest.tableName(), config)));
        if (paginationLoadingStrategy == DynamoDbMapperConfig.PaginationLoadingStrategy.EAGER_LOADING) {
            this.loadAllResults();
        }
    }

    @Override
    protected synchronized boolean atEndOfResults() {
        return this.scanResult.lastEvaluatedKey() == null;
    }

    @Override
    protected synchronized List<T> fetchNextPage() {
        this.scanRequest = (ScanRequest)((Object)this.scanRequest.toBuilder().exclusiveStartKey(this.scanResult.lastEvaluatedKey()).build());
        this.scanResult = this.dynamo.scan(DynamoDbMapper.applyUserAgent(this.scanRequest));
        return this.mapper.marshallIntoObjects(this.mapper.toParameters(this.scanResult.items(), this.clazz, this.scanRequest.tableName(), this.config));
    }
}

