/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkTestInternalApi;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapper;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

public class ParallelScanTask {
    private final List<ScanRequest> parallelScanRequests;
    private final int totalSegments;
    private final List<Future<ScanResponse>> segmentScanFutureTasks;
    private final List<ScanResponse> segmentScanResponses;
    private final List<SegmentScanstate> segmentScanstates;
    private final DynamoDBClient dynamo;
    private ExecutorService executorService;

    @Deprecated
    public ParallelScanTask(DynamoDbMapper mapper, DynamoDBClient dynamo, List<ScanRequest> parallelScanRequests) {
        this(dynamo, parallelScanRequests);
    }

    ParallelScanTask(DynamoDBClient dynamo, List<ScanRequest> parallelScanRequests) {
        this(dynamo, parallelScanRequests, Executors.newCachedThreadPool());
    }

    @SdkTestInternalApi
    ParallelScanTask(DynamoDBClient dynamo, List<ScanRequest> parallelScanRequests, ExecutorService executorService) {
        this.dynamo = dynamo;
        this.parallelScanRequests = parallelScanRequests;
        this.totalSegments = parallelScanRequests.size();
        this.executorService = executorService;
        this.segmentScanFutureTasks = Collections.synchronizedList(new ArrayList(this.totalSegments));
        this.segmentScanResponses = Collections.synchronizedList(new ArrayList(this.totalSegments));
        this.segmentScanstates = Collections.synchronizedList(new ArrayList(this.totalSegments));
        this.initSegmentScanstates();
    }

    String getTableName() {
        return this.parallelScanRequests.get(0).tableName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAllSegmentScanFinished() {
        List<SegmentScanstate> list = this.segmentScanstates;
        synchronized (list) {
            for (int segment = 0; segment < this.totalSegments; ++segment) {
                if (this.segmentScanstates.get(segment) == SegmentScanstate.SegmentScanCompleted) continue;
                return false;
            }
            this.executorService.shutdown();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ScanResponse> nextBatchOfScanResponses() throws SdkClientException {
        this.startScanNextPages();
        List<SegmentScanstate> list = this.segmentScanstates;
        synchronized (list) {
            while (this.segmentScanstates.contains((Object)SegmentScanstate.Waiting) || this.segmentScanstates.contains((Object)SegmentScanstate.Scanning)) {
                try {
                    this.segmentScanstates.wait();
                }
                catch (InterruptedException ie) {
                    throw new SdkClientException("Parallel scan interrupted by other thread.", (Throwable)ie);
                }
            }
            return this.marshalParallelScanResponses();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startScanNextPages() {
        for (int segment = 0; segment < this.totalSegments; ++segment) {
            int currentSegment = segment;
            SegmentScanstate currentSegmentState = this.segmentScanstates.get(currentSegment);
            if (currentSegmentState == SegmentScanstate.Scanning) {
                throw new SdkClientException("Should never see a 'Scanning' state when starting parallel scans.");
            }
            if (currentSegmentState == SegmentScanstate.Failed || currentSegmentState == SegmentScanstate.SegmentScanCompleted) {
                this.segmentScanResponses.set(currentSegment, null);
                continue;
            }
            List<SegmentScanstate> list = this.segmentScanstates;
            synchronized (list) {
                this.segmentScanstates.set(currentSegment, SegmentScanstate.Scanning);
                this.segmentScanstates.notifyAll();
            }
            Future<ScanResponse> futureTask = this.executorService.submit(() -> {
                try {
                    if (currentSegmentState == SegmentScanstate.HasNextPage) {
                        return this.scanNextPageOfSegment(currentSegment, true);
                    }
                    if (currentSegmentState == SegmentScanstate.Waiting) {
                        return this.scanNextPageOfSegment(currentSegment, false);
                    }
                    throw new SdkClientException("Should not start a new future task");
                }
                catch (Exception e) {
                    List<SegmentScanstate> list = this.segmentScanstates;
                    synchronized (list) {
                        this.segmentScanstates.set(currentSegment, SegmentScanstate.Failed);
                        this.segmentScanstates.notifyAll();
                        this.executorService.shutdown();
                    }
                    throw e;
                }
            });
            this.segmentScanFutureTasks.set(currentSegment, futureTask);
        }
    }

    private List<ScanResponse> marshalParallelScanResponses() {
        LinkedList<ScanResponse> scanResults = new LinkedList<ScanResponse>();
        for (int segment = 0; segment < this.totalSegments; ++segment) {
            SegmentScanstate currentSegmentState = this.segmentScanstates.get(segment);
            if (currentSegmentState == SegmentScanstate.Failed) {
                try {
                    this.segmentScanFutureTasks.get(segment).get();
                    throw new SdkClientException("No Exception found in the failed scan task.");
                }
                catch (ExecutionException ee) {
                    Throwable cause = ee.getCause();
                    if (cause instanceof SdkClientException) {
                        throw (SdkClientException)cause;
                    }
                    throw new SdkClientException("Internal error during the scan on segment #" + segment + ".", ee.getCause());
                }
                catch (Exception e) {
                    throw new SdkClientException("Error during the scan on segment #" + segment + ".", (Throwable)e);
                }
            }
            if (currentSegmentState == SegmentScanstate.HasNextPage || currentSegmentState == SegmentScanstate.SegmentScanCompleted) {
                ScanResponse scanResult = this.segmentScanResponses.get(segment);
                scanResults.add(scanResult);
                continue;
            }
            if (currentSegmentState != SegmentScanstate.Waiting && currentSegmentState != SegmentScanstate.Scanning) continue;
            throw new SdkClientException("Should never see a 'Scanning' or 'Waiting' state when marshalling parallel scan results.");
        }
        return scanResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScanResponse scanNextPageOfSegment(int currentSegment, boolean checkLastEvaluatedKey) {
        ScanRequest segmentScanRequest = this.parallelScanRequests.get(currentSegment);
        if (checkLastEvaluatedKey) {
            ScanResponse lastScanResult = this.segmentScanResponses.get(currentSegment);
            segmentScanRequest = (ScanRequest)((Object)segmentScanRequest.toBuilder().exclusiveStartKey(lastScanResult.lastEvaluatedKey()).build());
        } else {
            segmentScanRequest = (ScanRequest)((Object)segmentScanRequest.toBuilder().exclusiveStartKey(null).build());
        }
        ScanResponse scanResult = this.dynamo.scan(DynamoDbMapper.applyUserAgent(segmentScanRequest));
        this.segmentScanResponses.set(currentSegment, scanResult);
        List<SegmentScanstate> list = this.segmentScanstates;
        synchronized (list) {
            if (null == scanResult.lastEvaluatedKey()) {
                this.segmentScanstates.set(currentSegment, SegmentScanstate.SegmentScanCompleted);
            } else {
                this.segmentScanstates.set(currentSegment, SegmentScanstate.HasNextPage);
            }
            this.segmentScanstates.notifyAll();
        }
        return scanResult;
    }

    private void initSegmentScanstates() {
        for (int segment = 0; segment < this.totalSegments; ++segment) {
            this.segmentScanFutureTasks.add(null);
            this.segmentScanResponses.add(null);
            this.segmentScanstates.add(SegmentScanstate.Waiting);
        }
    }

    private static enum SegmentScanstate {
        Waiting,
        Scanning,
        Failed,
        HasNextPage,
        SegmentScanCompleted;

    }
}

