/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMappingException;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverter;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTypeConverterFactory;
import software.amazon.awssdk.services.dynamodb.datamodeling.S3Link;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.util.DateUtils;

@SdkInternalApi
final class StandardTypeConverters
extends DynamoDbTypeConverterFactory {
    private static final DynamoDbTypeConverterFactory FACTORY = new StandardTypeConverters();

    StandardTypeConverters() {
    }

    static DynamoDbTypeConverterFactory factory() {
        return FACTORY;
    }

    @Override
    public <S, T> DynamoDbTypeConverter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
        Scalar source = Scalar.of(sourceType);
        Scalar target = Scalar.of(targetType);
        Converter toSource = source.getConverter(sourceType, target.type());
        Converter toTarget = target.getConverter(targetType, source.type());
        return new StandardDynamoDbTypeConverter(toSource, toTarget);
    }

    private static class StandardDynamoDbTypeConverter<S, T>
    implements DynamoDbTypeConverter<S, T> {
        private final Converter<S, T> toSource;
        private final Converter<T, S> toTarget;

        public StandardDynamoDbTypeConverter(Converter<S, T> toSource, Converter<T, S> toTarget) {
            this.toSource = toSource;
            this.toTarget = toTarget;
        }

        @Override
        public final S convert(T o) {
            return this.toSource.convert(o);
        }

        @Override
        public final T unconvert(S o) {
            return this.toTarget.convert(o);
        }
    }

    static abstract class Converter<S, T> {
        Converter() {
        }

        final <U> Converter<S, U> join(final Converter<T, U> target) {
            final Converter source = this;
            return new Converter<S, U>(){

                @Override
                public S convert(U o) {
                    return source.convert(target.convert(o));
                }
            };
        }

        public abstract S convert(T var1);
    }

    private static abstract class ToObject<T>
    extends Converter<Object, T> {
        private static final ToObject<Object> FROM_OBJECT = new ToObject<Object>(){

            @Override
            public final Object convert(Object o) {
                return o;
            }
        };

        private ToObject() {
        }
    }

    private static abstract class ToUuid<T>
    extends Converter<UUID, T> {
        private static final ToUuid<ByteBuffer> FROM_BYTE_BUFFER = new ToUuid<ByteBuffer>(){

            @Override
            public final UUID convert(ByteBuffer o) {
                return new UUID(o.getLong(), o.getLong());
            }
        };
        private static final ToUuid<String> FROM_STRING = new ToUuid<String>(){

            @Override
            public final UUID convert(String o) {
                return UUID.fromString(o);
            }
        };

        private ToUuid() {
        }

        static /* synthetic */ ToUuid access$4200() {
            return FROM_STRING;
        }

        static /* synthetic */ ToUuid access$4300() {
            return FROM_BYTE_BUFFER;
        }
    }

    private static abstract class ToUri<T>
    extends Converter<URI, T> {
        private static final ToUri<String> FROM_STRING = new ToUri<String>(){

            @Override
            public final URI convert(String o) {
                try {
                    return new URI(o);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("malformed URI", e);
                }
            }
        };

        private ToUri() {
        }

        static /* synthetic */ ToUri access$4100() {
            return FROM_STRING;
        }
    }

    private static abstract class ToUrl<T>
    extends Converter<URL, String> {
        private static final ToUrl<String> FROM_STRING = new ToUrl<String>(){

            @Override
            public final URL convert(String o) {
                try {
                    return new URL(o);
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("malformed URL", e);
                }
            }
        };

        private ToUrl() {
        }

        static /* synthetic */ ToUrl access$4000() {
            return FROM_STRING;
        }
    }

    private static abstract class ToTimeZone<T>
    extends Converter<TimeZone, T> {
        private static final ToTimeZone<String> FROM_STRING = new ToTimeZone<String>(){

            @Override
            public final TimeZone convert(String o) {
                return TimeZone.getTimeZone(o);
            }
        };

        private ToTimeZone() {
        }

        static /* synthetic */ ToTimeZone access$3900() {
            return FROM_STRING;
        }
    }

    private static abstract class ToString<T>
    extends Converter<String, T> {
        private static final ToString<Boolean> FROM_BOOLEAN = new ToString<Boolean>(){

            @Override
            public final String convert(Boolean o) {
                return Boolean.TRUE.equals(o) ? "1" : "0";
            }
        };
        private static final ToString<byte[]> FROM_BYTE_ARRAY = new ToString<byte[]>(){

            @Override
            public final String convert(byte[] o) {
                return new String(o, Charset.forName("UTF-8"));
            }
        };
        private static final ToString<Date> FROM_DATE = new ToString<Date>(){

            @Override
            public final String convert(Date o) {
                return DateUtils.formatIso8601Date((Date)o);
            }
        };
        private static final ToString<Enum> FROM_ENUM = new ToString<Enum>(){

            @Override
            public final String convert(Enum o) {
                return o.name();
            }
        };
        private static final ToString<Locale> FROM_LOCALE = new ToString<Locale>(){

            @Override
            public final String convert(Locale o) {
                StringBuilder value = new StringBuilder(o.getLanguage());
                if (!o.getCountry().isEmpty() || !o.getVariant().isEmpty()) {
                    value.append("-").append(o.getCountry());
                }
                if (!o.getVariant().isEmpty()) {
                    value.append("-").append(o.getVariant());
                }
                return value.toString();
            }
        };
        private static final ToString<Number> FROM_NUMBER = new ToString<Number>(){

            @Override
            public final String convert(Number o) {
                return o.toString();
            }
        };
        private static final ToString<TimeZone> FROM_TIME_ZONE = new ToString<TimeZone>(){

            @Override
            public final String convert(TimeZone o) {
                return o.getID();
            }
        };
        private static final ToString<Object> FROM_OBJECT = new ToString<Object>(){

            @Override
            public final String convert(Object o) {
                return o.toString();
            }
        };

        private ToString() {
        }

        static /* synthetic */ ToString access$100() {
            return FROM_NUMBER;
        }

        static /* synthetic */ ToString access$3200() {
            return FROM_OBJECT;
        }

        static /* synthetic */ ToString access$3300() {
            return FROM_TIME_ZONE;
        }

        static /* synthetic */ ToString access$3400() {
            return FROM_LOCALE;
        }

        static /* synthetic */ ToString access$3500() {
            return FROM_ENUM;
        }

        static /* synthetic */ ToString access$3600() {
            return FROM_DATE;
        }

        static /* synthetic */ ToString access$3700() {
            return FROM_BYTE_ARRAY;
        }

        static /* synthetic */ ToString access$3800() {
            return FROM_BOOLEAN;
        }
    }

    private static abstract class ToShort<T>
    extends Converter<Short, T> {
        private static final ToShort<Number> FROM_NUMBER = new ToShort<Number>(){

            @Override
            public final Short convert(Number o) {
                return o.shortValue();
            }
        };
        private static final ToShort<String> FROM_STRING = new ToShort<String>(){

            @Override
            public final Short convert(String o) {
                return Short.valueOf(o);
            }
        };

        private ToShort() {
        }

        static /* synthetic */ ToShort access$3000() {
            return FROM_STRING;
        }

        static /* synthetic */ ToShort access$3100() {
            return FROM_NUMBER;
        }
    }

    private static abstract class ToLong<T>
    extends Converter<Long, T> {
        private static final ToLong<Date> FROM_DATE = new ToLong<Date>(){

            @Override
            public final Long convert(Date o) {
                return o.getTime();
            }
        };
        private static final ToLong<Number> FROM_NUMBER = new ToLong<Number>(){

            @Override
            public final Long convert(Number o) {
                return o.longValue();
            }
        };
        private static final ToLong<String> FROM_STRING = new ToLong<String>(){

            @Override
            public final Long convert(String o) {
                return Long.valueOf(o);
            }
        };

        private ToLong() {
        }

        static /* synthetic */ ToLong access$2700() {
            return FROM_STRING;
        }

        static /* synthetic */ ToLong access$2800() {
            return FROM_NUMBER;
        }

        static /* synthetic */ ToLong access$2900() {
            return FROM_DATE;
        }
    }

    private static abstract class ToLocale<T>
    extends Converter<Locale, T> {
        private static final ToLocale<String> FROM_STRING = new ToLocale<String>(){

            @Override
            public final Locale convert(String o) {
                String[] value = o.split("-", 3);
                if (value.length == 3) {
                    return new Locale(value[0], value[1], value[2]);
                }
                if (value.length == 2) {
                    return new Locale(value[0], value[1]);
                }
                return new Locale(value[0]);
            }
        };

        private ToLocale() {
        }

        static /* synthetic */ ToLocale access$2600() {
            return FROM_STRING;
        }
    }

    private static abstract class ToInteger<T>
    extends Converter<Integer, T> {
        private static final ToInteger<Number> FROM_NUMBER = new ToInteger<Number>(){

            @Override
            public final Integer convert(Number o) {
                return o.intValue();
            }
        };
        private static final ToInteger<String> FROM_STRING = new ToInteger<String>(){

            @Override
            public final Integer convert(String o) {
                return Integer.valueOf(o);
            }
        };

        private ToInteger() {
        }

        static /* synthetic */ ToInteger access$2400() {
            return FROM_STRING;
        }

        static /* synthetic */ ToInteger access$2500() {
            return FROM_NUMBER;
        }
    }

    private static abstract class ToFloat<T>
    extends Converter<Float, T> {
        private static final ToFloat<Number> FROM_NUMBER = new ToFloat<Number>(){

            @Override
            public final Float convert(Number o) {
                return Float.valueOf(o.floatValue());
            }
        };
        private static final ToFloat<String> FROM_STRING = new ToFloat<String>(){

            @Override
            public final Float convert(String o) {
                return Float.valueOf(o);
            }
        };

        private ToFloat() {
        }

        static /* synthetic */ ToFloat access$2200() {
            return FROM_STRING;
        }

        static /* synthetic */ ToFloat access$2300() {
            return FROM_NUMBER;
        }
    }

    private static abstract class ToEnum<S extends Enum<S>, T>
    extends Converter<S, T> {
        private ToEnum() {
        }

        private static final class FromString<S extends Enum<S>>
        extends ToEnum<S, String> {
            private final Class<S> sourceType;

            private FromString(Class<S> sourceType) {
                this.sourceType = sourceType;
            }

            @Override
            public final S convert(String o) {
                return Enum.valueOf(this.sourceType, o);
            }
        }
    }

    private static abstract class ToDouble<T>
    extends Converter<Double, T> {
        private static final ToDouble<Number> FROM_NUMBER = new ToDouble<Number>(){

            @Override
            public final Double convert(Number o) {
                return o.doubleValue();
            }
        };
        private static final ToDouble<String> FROM_STRING = new ToDouble<String>(){

            @Override
            public final Double convert(String o) {
                return Double.valueOf(o);
            }
        };

        private ToDouble() {
        }

        static /* synthetic */ ToDouble access$2000() {
            return FROM_STRING;
        }

        static /* synthetic */ ToDouble access$2100() {
            return FROM_NUMBER;
        }
    }

    private static abstract class ToDateTime<T>
    extends Converter<DateTime, T> {
        private static final ToDateTime<Date> FROM_DATE = new ToDateTime<Date>(){

            @Override
            public final DateTime convert(Date o) {
                return new DateTime((Object)o);
            }
        };

        private ToDateTime() {
        }

        static /* synthetic */ ToDateTime access$1900() {
            return FROM_DATE;
        }
    }

    private static abstract class ToDate<T>
    extends Converter<Date, T> {
        private static final ToDate<Calendar> FROM_CALENDAR = new ToDate<Calendar>(){

            @Override
            public final Date convert(Calendar o) {
                return o.getTime();
            }
        };
        private static final ToDate<DateTime> FROM_DATETIME = new ToDate<DateTime>(){

            @Override
            public final Date convert(DateTime o) {
                return o.toDate();
            }
        };
        private static final ToDate<Long> FROM_LONG = new ToDate<Long>(){

            @Override
            public final Date convert(Long o) {
                return new Date(o);
            }
        };
        private static final ToDate<String> FROM_STRING = new ToDate<String>(){

            @Override
            public final Date convert(String o) {
                return DateUtils.parseIso8601Date((String)o);
            }
        };

        private ToDate() {
        }

        static /* synthetic */ ToDate access$1200() {
            return FROM_STRING;
        }

        static /* synthetic */ ToDate access$1400() {
            return FROM_LONG;
        }

        static /* synthetic */ ToDate access$1500() {
            return FROM_DATETIME;
        }

        static /* synthetic */ ToDate access$1800() {
            return FROM_CALENDAR;
        }
    }

    private static abstract class ToCurrency<T>
    extends Converter<Currency, T> {
        private static final ToCurrency<String> FROM_STRING = new ToCurrency<String>(){

            @Override
            public final Currency convert(String o) {
                return Currency.getInstance(o);
            }
        };

        private ToCurrency() {
        }

        static /* synthetic */ ToCurrency access$1700() {
            return FROM_STRING;
        }
    }

    private static abstract class ToCharacter<T>
    extends Converter<Character, T> {
        private static final ToCharacter<String> FROM_STRING = new ToCharacter<String>(){

            @Override
            public final Character convert(String o) {
                return Character.valueOf(o.charAt(0));
            }
        };

        private ToCharacter() {
        }

        static /* synthetic */ ToCharacter access$1600() {
            return FROM_STRING;
        }
    }

    private static abstract class ToCalendar<T>
    extends Converter<Calendar, T> {
        private static final ToCalendar<Date> FROM_DATE = new ToCalendar<Date>(){

            @Override
            public final Calendar convert(Date o) {
                Calendar value = Calendar.getInstance();
                value.setTime(o);
                return value;
            }
        };

        private ToCalendar() {
        }

        static /* synthetic */ ToCalendar access$1300() {
            return FROM_DATE;
        }
    }

    private static abstract class ToByteBuffer<T>
    extends Converter<ByteBuffer, T> {
        private static final ToByteBuffer<byte[]> FROM_BYTE_ARRAY = new ToByteBuffer<byte[]>(){

            @Override
            public final ByteBuffer convert(byte[] o) {
                return ByteBuffer.wrap(o);
            }
        };
        private static final ToByteBuffer<UUID> FROM_UUID = new ToByteBuffer<UUID>(){

            @Override
            public final ByteBuffer convert(UUID o) {
                ByteBuffer value = ByteBuffer.allocate(16);
                value.putLong(o.getMostSignificantBits()).putLong(o.getLeastSignificantBits());
                value.position(0);
                return value;
            }
        };

        private ToByteBuffer() {
        }

        static /* synthetic */ ToByteBuffer access$1000() {
            return FROM_UUID;
        }

        static /* synthetic */ ToByteBuffer access$1100() {
            return FROM_BYTE_ARRAY;
        }
    }

    private static abstract class ToByteArray<T>
    extends Converter<byte[], T> {
        private static final ToByteArray<ByteBuffer> FROM_BYTE_BUFFER = new ToByteArray<ByteBuffer>(){

            @Override
            public final byte[] convert(ByteBuffer o) {
                if (o.hasArray()) {
                    return o.array();
                }
                byte[] value = new byte[o.remaining()];
                o.get(value);
                return value;
            }
        };
        private static final ToByteArray<String> FROM_STRING = new ToByteArray<String>(){

            @Override
            public final byte[] convert(String o) {
                return o.getBytes(Charset.forName("UTF-8"));
            }
        };

        private ToByteArray() {
        }

        static /* synthetic */ ToByteArray access$800() {
            return FROM_STRING;
        }

        static /* synthetic */ ToByteArray access$900() {
            return FROM_BYTE_BUFFER;
        }
    }

    private static abstract class ToByte<T>
    extends Converter<Byte, T> {
        private static final ToByte<Number> FROM_NUMBER = new ToByte<Number>(){

            @Override
            public final Byte convert(Number o) {
                return o.byteValue();
            }
        };
        private static final ToByte<String> FROM_STRING = new ToByte<String>(){

            @Override
            public final Byte convert(String o) {
                return Byte.valueOf(o);
            }
        };

        private ToByte() {
        }

        static /* synthetic */ ToByte access$600() {
            return FROM_STRING;
        }

        static /* synthetic */ ToByte access$700() {
            return FROM_NUMBER;
        }
    }

    private static abstract class ToBoolean<T>
    extends Converter<Boolean, T> {
        private static final ToBoolean<String> FROM_STRING = new ToBoolean<String>(){
            private final Pattern n0 = Pattern.compile("(?i)[N0]");
            private final Pattern y1 = Pattern.compile("(?i)[Y1]");

            @Override
            public final Boolean convert(String o) {
                return this.n0.matcher(o).matches() ? Boolean.FALSE : (this.y1.matcher(o).matches() ? Boolean.TRUE : Boolean.valueOf(o));
            }
        };

        private ToBoolean() {
        }

        static /* synthetic */ ToBoolean access$500() {
            return FROM_STRING;
        }
    }

    private static abstract class ToBigInteger<T>
    extends Converter<BigInteger, T> {
        private static final ToBigInteger<String> FROM_STRING = new ToBigInteger<String>(){

            @Override
            public final BigInteger convert(String o) {
                return new BigInteger(o);
            }
        };

        private ToBigInteger() {
        }

        static /* synthetic */ ToBigInteger access$400() {
            return FROM_STRING;
        }
    }

    private static abstract class ToBigDecimal<T>
    extends Converter<BigDecimal, T> {
        private static final ToBigDecimal<String> FROM_STRING = new ToBigDecimal<String>(){

            @Override
            public final BigDecimal convert(String o) {
                return new BigDecimal(o);
            }
        };

        private ToBigDecimal() {
        }

        static /* synthetic */ ToBigDecimal access$000() {
            return FROM_STRING;
        }
    }

    private static class ConverterMap
    extends LinkedHashMap<Class<?>, Converter<?, ?>> {
        private static final long serialVersionUID = -1L;
        private final Class<?> referenceType;
        private final Class<?> primitiveType;

        private ConverterMap(Class<?> referenceType, Class<?> primitiveType) {
            this.referenceType = referenceType;
            this.primitiveType = primitiveType;
        }

        private <S, T> ConverterMap with(Class<T> targetType, Converter<S, T> converter) {
            this.put(targetType, converter);
            return this;
        }

        private boolean isAssignableFrom(Class<?> type) {
            return type.isPrimitive() ? this.primitiveType == type : this.referenceType.isAssignableFrom(type);
        }

        private <S, T> Converter<S, T> getConverter(Class<T> targetType) {
            for (Map.Entry entry : this.entrySet()) {
                if (!((Class)entry.getKey()).isAssignableFrom(targetType)) continue;
                return (Converter)entry.getValue();
            }
            if (this.isAssignableFrom(targetType)) {
                return ToObject.FROM_OBJECT;
            }
            throw new DynamoDbMappingException("type [" + targetType + "] is not supported; no conversion from " + this.referenceType);
        }

        static /* synthetic */ ConverterMap access$300(ConverterMap x0, Class x1, Converter x2) {
            return x0.with(x1, x2);
        }
    }

    static abstract class Vector {
        static final ToList LIST = new ToList();
        static final ToMap MAP = new ToMap();
        static final ToSet SET = new ToSet();

        Vector() {
        }

        abstract boolean is(Class<?> var1);

        static final class ToSet
        extends Vector {
            ToSet() {
            }

            <S, T> DynamoDbTypeConverter<List<S>, Collection<T>> join(DynamoDbTypeConverter<S, T> target) {
                return new SetTypeConverter<S, T>(target);
            }

            <S, T> Set<T> unconvert(Collection<S> o, DynamoDbTypeConverter<S, T> scalar) {
                LinkedHashSet<T> vector = new LinkedHashSet<T>();
                for (S s : o) {
                    if (vector.add(scalar.unconvert(s))) continue;
                    throw new DynamoDbMappingException("duplicate value (" + s + ")");
                }
                return vector;
            }

            @Override
            boolean is(Class<?> type) {
                return Set.class.isAssignableFrom(type);
            }

            private static class SetTypeConverter<S, T>
            implements DynamoDbTypeConverter<List<S>, Collection<T>> {
                private final DynamoDbTypeConverter<S, T> target;

                public SetTypeConverter(DynamoDbTypeConverter<S, T> target) {
                    this.target = target;
                }

                @Override
                public List<S> convert(Collection<T> o) {
                    return LIST.convert(o, this.target);
                }

                @Override
                public Collection<T> unconvert(List<S> o) {
                    return SET.unconvert(o, this.target);
                }
            }
        }

        static final class ToMap
        extends Vector {
            ToMap() {
            }

            <K, S, T> DynamoDbTypeConverter<Map<K, S>, Map<K, T>> join(DynamoDbTypeConverter<S, T> scalar) {
                return new MapTypeConverter(scalar);
            }

            <K, S, T> Map<K, S> convert(Map<K, T> o, DynamoDbTypeConverter<S, T> scalar) {
                LinkedHashMap<K, S> vector = new LinkedHashMap<K, S>();
                for (Map.Entry<K, T> t : o.entrySet()) {
                    vector.put(t.getKey(), scalar.convert(t.getValue()));
                }
                return vector;
            }

            <K, S, T> Map<K, T> unconvert(Map<K, S> o, DynamoDbTypeConverter<S, T> scalar) {
                LinkedHashMap<K, T> vector = new LinkedHashMap<K, T>();
                for (Map.Entry<K, S> s : o.entrySet()) {
                    vector.put(s.getKey(), scalar.unconvert(s.getValue()));
                }
                return vector;
            }

            @Override
            boolean is(Class<?> type) {
                return Map.class.isAssignableFrom(type);
            }

            private static class MapTypeConverter<K, S, T>
            implements DynamoDbTypeConverter<Map<K, S>, Map<K, T>> {
                private final DynamoDbTypeConverter<S, T> scalar;

                public MapTypeConverter(DynamoDbTypeConverter<S, T> scalar) {
                    this.scalar = scalar;
                }

                @Override
                public final Map<K, S> convert(Map<K, T> o) {
                    return MAP.convert(o, this.scalar);
                }

                @Override
                public final Map<K, T> unconvert(Map<K, S> o) {
                    return MAP.unconvert(o, this.scalar);
                }
            }
        }

        static final class ToList
        extends Vector {
            ToList() {
            }

            <S, T> DynamoDbTypeConverter<List<S>, List<T>> join(DynamoDbTypeConverter<S, T> scalar) {
                return new ListTypeConverter<S, T>(scalar);
            }

            <S, T> List<S> convert(Collection<T> o, DynamoDbTypeConverter<S, T> scalar) {
                ArrayList<S> vector = new ArrayList<S>(o.size());
                for (T t : o) {
                    vector.add(scalar.convert(t));
                }
                return vector;
            }

            <S, T> List<T> unconvert(Collection<S> o, DynamoDbTypeConverter<S, T> scalar) {
                ArrayList<T> vector = new ArrayList<T>(o.size());
                for (S s : o) {
                    vector.add(scalar.unconvert(s));
                }
                return vector;
            }

            @Override
            boolean is(Class<?> type) {
                return List.class.isAssignableFrom(type);
            }

            private static class ListTypeConverter<S, T>
            implements DynamoDbTypeConverter<List<S>, List<T>> {
                private final DynamoDbTypeConverter<S, T> scalar;

                public ListTypeConverter(DynamoDbTypeConverter<S, T> scalar) {
                    this.scalar = scalar;
                }

                @Override
                public final List<S> convert(List<T> o) {
                    return LIST.convert(o, this.scalar);
                }

                @Override
                public final List<T> unconvert(List<S> o) {
                    return LIST.unconvert(o, this.scalar);
                }
            }
        }
    }

    static enum Scalar {
        BIG_DECIMAL(ScalarAttributeType.N, ConverterMap.access$300(ConverterMap.access$300(new ConverterMap(BigDecimal.class, null), Number.class, ToBigDecimal.access$000().join(ToString.access$100())), String.class, ToBigDecimal.access$000())),
        BIG_INTEGER(ScalarAttributeType.N, ConverterMap.access$300(ConverterMap.access$300(new ConverterMap(BigInteger.class, null), Number.class, ToBigInteger.access$400().join(ToString.access$100())), String.class, ToBigInteger.access$400())),
        BOOLEAN(ScalarAttributeType.N, ConverterMap.access$300(ConverterMap.access$300(new ConverterMap(Boolean.class, Boolean.TYPE), Number.class, ToBoolean.access$500().join(ToString.access$100())), String.class, ToBoolean.access$500())),
        BYTE(ScalarAttributeType.N, ConverterMap.access$300(ConverterMap.access$300(new ConverterMap(Byte.class, Byte.TYPE), Number.class, ToByte.access$700()), String.class, ToByte.access$600())),
        BYTE_ARRAY(ScalarAttributeType.B, ConverterMap.access$300(ConverterMap.access$300(new ConverterMap(byte[].class, null), ByteBuffer.class, ToByteArray.access$900()), String.class, ToByteArray.access$800())),
        BYTE_BUFFER(ScalarAttributeType.B, ConverterMap.access$300(ConverterMap.access$300(ConverterMap.access$300(new ConverterMap(ByteBuffer.class, null), byte[].class, ToByteBuffer.access$1100()), String.class, ToByteBuffer.access$1100().join(ToByteArray.access$800())), UUID.class, ToByteBuffer.access$1000())),
        CALENDAR(ScalarAttributeType.S, ConverterMap.access$300(ConverterMap.access$300(ConverterMap.access$300(ConverterMap.access$300(new ConverterMap(Calendar.class, null), Date.class, ToCalendar.access$1300()), DateTime.class, ToCalendar.access$1300().join(ToDate.access$1500())), Long.class, ToCalendar.access$1300().join(ToDate.access$1400())), String.class, ToCalendar.access$1300().join(ToDate.access$1200()))),
        CHARACTER(ScalarAttributeType.S, ConverterMap.access$300(new ConverterMap(Character.class, Character.TYPE), String.class, ToCharacter.access$1600())),
        CURRENCY(ScalarAttributeType.S, ConverterMap.access$300(new ConverterMap(Currency.class, null), String.class, ToCurrency.access$1700())),
        DATE(ScalarAttributeType.S, ConverterMap.access$300(ConverterMap.access$300(ConverterMap.access$300(ConverterMap.access$300(new ConverterMap(Date.class, null), Calendar.class, ToDate.access$1800()), DateTime.class, ToDate.access$1500()), Long.class, ToDate.access$1400()), String.class, ToDate.access$1200())),
        DATE_TIME(null, ConverterMap.access$300(ConverterMap.access$300(ConverterMap.access$300(ConverterMap.access$300(new ConverterMap(DateTime.class, null), Calendar.class, ToDateTime.access$1900().join(ToDate.access$1800())), Date.class, ToDateTime.access$1900()), Long.class, ToDateTime.access$1900().join(ToDate.access$1400())), String.class, ToDateTime.access$1900().join(ToDate.access$1200()))),
        DOUBLE(ScalarAttributeType.N, ConverterMap.access$300(ConverterMap.access$300(new ConverterMap(Double.class, Double.TYPE), Number.class, ToDouble.access$2100()), String.class, ToDouble.access$2000())),
        FLOAT(ScalarAttributeType.N, ConverterMap.access$300(ConverterMap.access$300(new ConverterMap(Float.class, Float.TYPE), Number.class, ToFloat.access$2300()), String.class, ToFloat.access$2200())),
        INTEGER(ScalarAttributeType.N, ConverterMap.access$300(ConverterMap.access$300(new ConverterMap(Integer.class, Integer.TYPE), Number.class, ToInteger.access$2500()), String.class, ToInteger.access$2400())),
        LOCALE(ScalarAttributeType.S, ConverterMap.access$300(new ConverterMap(Locale.class, null), String.class, ToLocale.access$2600())),
        LONG(ScalarAttributeType.N, ConverterMap.access$300(ConverterMap.access$300(ConverterMap.access$300(ConverterMap.access$300(new ConverterMap(Long.class, Long.TYPE), Date.class, ToLong.access$2900()), DateTime.class, ToLong.access$2900().join(ToDate.access$1500())), Number.class, ToLong.access$2800()), String.class, ToLong.access$2700())),
        S3_LINK(ScalarAttributeType.S, new ConverterMap(S3Link.class, null)),
        SHORT(ScalarAttributeType.N, ConverterMap.access$300(ConverterMap.access$300(new ConverterMap(Short.class, Short.TYPE), Number.class, ToShort.access$3100()), String.class, ToShort.access$3000())),
        STRING(ScalarAttributeType.S, ConverterMap.access$300(ConverterMap.access$300(ConverterMap.access$300(ConverterMap.access$300(ConverterMap.access$300(ConverterMap.access$300(ConverterMap.access$300(ConverterMap.access$300(ConverterMap.access$300(new ConverterMap(String.class, null), Boolean.class, ToString.access$3800()), byte[].class, ToString.access$3700()), ByteBuffer.class, ToString.access$3700().join(ToByteArray.access$900())), Calendar.class, ToString.access$3600().join(ToDate.access$1800())), Date.class, ToString.access$3600()), Enum.class, ToString.access$3500()), Locale.class, ToString.access$3400()), TimeZone.class, ToString.access$3300()), Object.class, ToString.access$3200())),
        TIME_ZONE(ScalarAttributeType.S, ConverterMap.access$300(new ConverterMap(TimeZone.class, null), String.class, ToTimeZone.access$3900())),
        URL(ScalarAttributeType.S, ConverterMap.access$300(new ConverterMap(URL.class, null), String.class, ToUrl.access$4000())),
        URI(ScalarAttributeType.S, ConverterMap.access$300(new ConverterMap(URI.class, null), String.class, ToUri.access$4100())),
        UUID(ScalarAttributeType.S, ConverterMap.access$300(ConverterMap.access$300(new ConverterMap(UUID.class, null), ByteBuffer.class, ToUuid.access$4300()), String.class, ToUuid.access$4200())),
        DEFAULT(null, new ConverterMap(Object.class, null)){

            @Override
            <S, T> Converter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
                if (sourceType.isEnum() && STRING.map.isAssignableFrom(targetType)) {
                    return new ToEnum.FromString(sourceType);
                }
                return super.getConverter(sourceType, targetType);
            }
        };

        private final ScalarAttributeType scalarAttributeType;
        private final ConverterMap map;

        private Scalar(ScalarAttributeType scalarAttributeType, ConverterMap map) {
            this.scalarAttributeType = scalarAttributeType;
            this.map = map;
        }

        static Scalar of(Class<?> type) {
            for (Scalar scalar : Scalar.values()) {
                if (!scalar.is(type)) continue;
                return scalar;
            }
            return DEFAULT;
        }

        <S, T> Converter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
            return this.map.getConverter(targetType);
        }

        final <S> S convert(Object o) {
            return this.getConverter(this.type(), o.getClass()).convert(o);
        }

        final boolean is(ScalarAttributeType scalarAttributeType) {
            return this.scalarAttributeType == scalarAttributeType;
        }

        final boolean is(Class<?> type) {
            return this.map.isAssignableFrom(type);
        }

        final <S> Class<S> type() {
            return this.map.referenceType;
        }
    }
}

