/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import software.amazon.awssdk.services.dynamodb.datamodeling.unmarshallers.SsUnmarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.util.DateUtils;

public class CalendarSetUnmarshaller
extends SsUnmarshaller {
    private static final CalendarSetUnmarshaller INSTANCE = new CalendarSetUnmarshaller();

    private CalendarSetUnmarshaller() {
    }

    public static CalendarSetUnmarshaller instance() {
        return INSTANCE;
    }

    @Override
    public Object unmarshall(AttributeValue value) {
        HashSet<Calendar> result = new HashSet<Calendar>();
        for (String s : value.ss()) {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime(DateUtils.parseIso8601Date((String)s));
            result.add(cal);
        }
        return result;
    }
}

