/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.internal;

import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.document.TableCollection;
import software.amazon.awssdk.services.dynamodb.document.api.ListTablesApi;
import software.amazon.awssdk.services.dynamodb.document.internal.ListTablesCollection;
import software.amazon.awssdk.services.dynamodb.document.spec.ListTablesSpec;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;

public class ListTablesImpl
implements ListTablesApi {
    private final DynamoDBClient client;

    public ListTablesImpl(DynamoDBClient client) {
        this.client = client;
    }

    @Override
    public TableCollection<ListTablesResponse> listTables(ListTablesSpec spec) {
        return this.doList(spec);
    }

    @Override
    public TableCollection<ListTablesResponse> listTables() {
        return this.doList(new ListTablesSpec());
    }

    @Override
    public TableCollection<ListTablesResponse> listTables(String exclusiveStartTableName) {
        return this.doList(new ListTablesSpec().withExclusiveStartTableName(exclusiveStartTableName));
    }

    @Override
    public TableCollection<ListTablesResponse> listTables(String exclusiveStartTableName, int maxResultSize) {
        return this.doList(new ListTablesSpec().withExclusiveStartTableName(exclusiveStartTableName).withMaxResultSize(maxResultSize));
    }

    @Override
    public TableCollection<ListTablesResponse> listTables(int maxResultSize) {
        return this.doList(new ListTablesSpec().withMaxResultSize(maxResultSize));
    }

    private TableCollection<ListTablesResponse> doList(ListTablesSpec spec) {
        return new ListTablesCollection(this.client, spec);
    }
}

