/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.document.Item;
import software.amazon.awssdk.services.dynamodb.document.ItemCollection;
import software.amazon.awssdk.services.dynamodb.document.Page;
import software.amazon.awssdk.services.dynamodb.document.QueryOutcome;
import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;
import software.amazon.awssdk.services.dynamodb.document.internal.QueryPage;
import software.amazon.awssdk.services.dynamodb.document.spec.QuerySpec;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;

class QueryCollection
extends ItemCollection<QueryOutcome> {
    private final DynamoDBClient client;
    private final QuerySpec spec;
    private final Map<String, AttributeValue> startKey;

    public QueryCollection(DynamoDBClient client, QuerySpec spec) {
        this.client = client;
        this.spec = spec;
        Map<String, AttributeValue> startKey = ((QueryRequest)((Object)spec.getRequest())).exclusiveStartKey();
        this.startKey = startKey == null ? null : new LinkedHashMap<String, AttributeValue>(startKey);
    }

    @Override
    public Page<Item, QueryOutcome> firstPage() {
        QueryRequest request = (QueryRequest)((Object)((QueryRequest)((Object)this.spec.getRequest())).toBuilder().exclusiveStartKey(this.startKey).limit(InternalUtils.minimum(this.spec.maxResultSize(), this.spec.maxPageSize())).build());
        this.spec.setRequest(request);
        QueryResponse result = this.client.query(request);
        QueryOutcome outcome = new QueryOutcome(result);
        this.setLastLowLevelResult(outcome);
        return new QueryPage(this.client, this.spec, request, 0, outcome);
    }

    @Override
    public Integer getMaxResultSize() {
        return this.spec.maxResultSize();
    }

    @Override
    protected void setLastLowLevelResult(QueryOutcome lowLevelResult) {
        super.setLastLowLevelResult(lowLevelResult);
        QueryResponse result = lowLevelResult.getQueryResponse();
        this.accumulateStats(result.consumedCapacity(), result.count(), result.scannedCount());
    }
}

