/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.document.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.document.Item;
import software.amazon.awssdk.services.dynamodb.document.ItemCollection;
import software.amazon.awssdk.services.dynamodb.document.Page;
import software.amazon.awssdk.services.dynamodb.document.ScanOutcome;
import software.amazon.awssdk.services.dynamodb.document.internal.InternalUtils;
import software.amazon.awssdk.services.dynamodb.document.internal.ScanPage;
import software.amazon.awssdk.services.dynamodb.document.spec.ScanSpec;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

class ScanCollection
extends ItemCollection<ScanOutcome> {
    private final DynamoDBClient client;
    private final ScanSpec spec;
    private final Map<String, AttributeValue> startKey;

    public ScanCollection(DynamoDBClient client, ScanSpec spec) {
        this.client = client;
        this.spec = spec;
        Map<String, AttributeValue> startKey = ((ScanRequest)((Object)spec.getRequest())).exclusiveStartKey();
        this.startKey = startKey == null ? null : new LinkedHashMap<String, AttributeValue>(startKey);
    }

    @Override
    public Page<Item, ScanOutcome> firstPage() {
        ScanRequest request = (ScanRequest)((Object)this.spec.getRequest());
        request = (ScanRequest)((Object)request.toBuilder().exclusiveStartKey(this.startKey).limit(InternalUtils.minimum(this.spec.maxResultSize(), this.spec.maxPageSize())).build());
        this.spec.setRequest(request);
        ScanResponse result = this.client.scan(request);
        ScanOutcome outcome = new ScanOutcome(result);
        this.setLastLowLevelResult(outcome);
        return new ScanPage(this.client, this.spec, request, 0, outcome);
    }

    @Override
    public Integer getMaxResultSize() {
        return this.spec.maxResultSize();
    }

    @Override
    protected void setLastLowLevelResult(ScanOutcome lowLevelResult) {
        super.setLastLowLevelResult(lowLevelResult);
        ScanResponse result = lowLevelResult.scanResult();
        this.accumulateStats(result.consumedCapacity(), result.count(), result.scannedCount());
    }
}

