/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.NonKeyAttributeNameListCopier;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import software.amazon.awssdk.services.dynamodb.transform.ProjectionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Projection
implements StructuredPojo,
ToCopyableBuilder<Builder, Projection> {
    private final String projectionType;
    private final List<String> nonKeyAttributes;

    private Projection(BuilderImpl builder) {
        this.projectionType = builder.projectionType;
        this.nonKeyAttributes = builder.nonKeyAttributes;
    }

    public String projectionType() {
        return this.projectionType;
    }

    public List<String> nonKeyAttributes() {
        return this.nonKeyAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.projectionType() == null ? 0 : this.projectionType().hashCode());
        hashCode = 31 * hashCode + (this.nonKeyAttributes() == null ? 0 : this.nonKeyAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Projection)) {
            return false;
        }
        Projection other = (Projection)obj;
        if (other.projectionType() == null ^ this.projectionType() == null) {
            return false;
        }
        if (other.projectionType() != null && !other.projectionType().equals(this.projectionType())) {
            return false;
        }
        if (other.nonKeyAttributes() == null ^ this.nonKeyAttributes() == null) {
            return false;
        }
        return other.nonKeyAttributes() == null || other.nonKeyAttributes().equals(this.nonKeyAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.projectionType() != null) {
            sb.append("ProjectionType: ").append(this.projectionType()).append(",");
        }
        if (this.nonKeyAttributes() != null) {
            sb.append("NonKeyAttributes: ").append(this.nonKeyAttributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String projectionType;
        private List<String> nonKeyAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(Projection model) {
            this.setProjectionType(model.projectionType);
            this.setNonKeyAttributes(model.nonKeyAttributes);
        }

        public final String getProjectionType() {
            return this.projectionType;
        }

        @Override
        public final Builder projectionType(String projectionType) {
            this.projectionType = projectionType;
            return this;
        }

        @Override
        public final Builder projectionType(ProjectionType projectionType) {
            this.projectionType(projectionType.toString());
            return this;
        }

        public final void setProjectionType(String projectionType) {
            this.projectionType = projectionType;
        }

        public final void setProjectionType(ProjectionType projectionType) {
            this.projectionType(projectionType.toString());
        }

        public final Collection<String> getNonKeyAttributes() {
            return this.nonKeyAttributes;
        }

        @Override
        public final Builder nonKeyAttributes(Collection<String> nonKeyAttributes) {
            this.nonKeyAttributes = NonKeyAttributeNameListCopier.copy(nonKeyAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nonKeyAttributes(String ... nonKeyAttributes) {
            if (this.nonKeyAttributes == null) {
                this.nonKeyAttributes = new ArrayList<String>(nonKeyAttributes.length);
            }
            for (String e : nonKeyAttributes) {
                this.nonKeyAttributes.add(e);
            }
            return this;
        }

        public final void setNonKeyAttributes(Collection<String> nonKeyAttributes) {
            this.nonKeyAttributes = NonKeyAttributeNameListCopier.copy(nonKeyAttributes);
        }

        @SafeVarargs
        public final void setNonKeyAttributes(String ... nonKeyAttributes) {
            if (this.nonKeyAttributes == null) {
                this.nonKeyAttributes = new ArrayList<String>(nonKeyAttributes.length);
            }
            for (String e : nonKeyAttributes) {
                this.nonKeyAttributes.add(e);
            }
        }

        public Projection build() {
            return new Projection(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Projection> {
        public Builder projectionType(String var1);

        public Builder projectionType(ProjectionType var1);

        public Builder nonKeyAttributes(Collection<String> var1);

        public Builder nonKeyAttributes(String ... var1);
    }
}

