/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.PutItemInputAttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.transform.PutRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, PutRequest> {
    private final Map<String, AttributeValue> item;

    private PutRequest(BuilderImpl builder) {
        this.item = builder.item;
    }

    public Map<String, AttributeValue> item() {
        return this.item;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.item() == null ? 0 : this.item().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRequest)) {
            return false;
        }
        PutRequest other = (PutRequest)obj;
        if (other.item() == null ^ this.item() == null) {
            return false;
        }
        return other.item() == null || other.item().equals(this.item());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.item() != null) {
            sb.append("Item: ").append(this.item()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PutRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Map<String, AttributeValue> item;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRequest model) {
            this.setItem(model.item);
        }

        public final Map<String, AttributeValue> getItem() {
            return this.item;
        }

        @Override
        public final Builder item(Map<String, AttributeValue> item) {
            this.item = PutItemInputAttributeMapCopier.copy(item);
            return this;
        }

        public final void setItem(Map<String, AttributeValue> item) {
            this.item = PutItemInputAttributeMapCopier.copy(item);
        }

        public PutRequest build() {
            return new PutRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutRequest> {
        public Builder item(Map<String, AttributeValue> var1);
    }
}

