/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.SequenceNumberRangeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SequenceNumberRange
implements StructuredPojo,
ToCopyableBuilder<Builder, SequenceNumberRange> {
    private final String startingSequenceNumber;
    private final String endingSequenceNumber;

    private SequenceNumberRange(BuilderImpl builder) {
        this.startingSequenceNumber = builder.startingSequenceNumber;
        this.endingSequenceNumber = builder.endingSequenceNumber;
    }

    public String startingSequenceNumber() {
        return this.startingSequenceNumber;
    }

    public String endingSequenceNumber() {
        return this.endingSequenceNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.startingSequenceNumber() == null ? 0 : this.startingSequenceNumber().hashCode());
        hashCode = 31 * hashCode + (this.endingSequenceNumber() == null ? 0 : this.endingSequenceNumber().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SequenceNumberRange)) {
            return false;
        }
        SequenceNumberRange other = (SequenceNumberRange)obj;
        if (other.startingSequenceNumber() == null ^ this.startingSequenceNumber() == null) {
            return false;
        }
        if (other.startingSequenceNumber() != null && !other.startingSequenceNumber().equals(this.startingSequenceNumber())) {
            return false;
        }
        if (other.endingSequenceNumber() == null ^ this.endingSequenceNumber() == null) {
            return false;
        }
        return other.endingSequenceNumber() == null || other.endingSequenceNumber().equals(this.endingSequenceNumber());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.startingSequenceNumber() != null) {
            sb.append("StartingSequenceNumber: ").append(this.startingSequenceNumber()).append(",");
        }
        if (this.endingSequenceNumber() != null) {
            sb.append("EndingSequenceNumber: ").append(this.endingSequenceNumber()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SequenceNumberRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String startingSequenceNumber;
        private String endingSequenceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SequenceNumberRange model) {
            this.setStartingSequenceNumber(model.startingSequenceNumber);
            this.setEndingSequenceNumber(model.endingSequenceNumber);
        }

        public final String getStartingSequenceNumber() {
            return this.startingSequenceNumber;
        }

        @Override
        public final Builder startingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
            return this;
        }

        public final void setStartingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
        }

        public final String getEndingSequenceNumber() {
            return this.endingSequenceNumber;
        }

        @Override
        public final Builder endingSequenceNumber(String endingSequenceNumber) {
            this.endingSequenceNumber = endingSequenceNumber;
            return this;
        }

        public final void setEndingSequenceNumber(String endingSequenceNumber) {
            this.endingSequenceNumber = endingSequenceNumber;
        }

        public SequenceNumberRange build() {
            return new SequenceNumberRange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SequenceNumberRange> {
        public Builder startingSequenceNumber(String var1);

        public Builder endingSequenceNumber(String var1);
    }
}

