/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>ListStreams</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListStreamsResponse extends DynamoDBStreamsResponse implements
        ToCopyableBuilder<ListStreamsResponse.Builder, ListStreamsResponse> {
    private final List<Stream> streams;

    private final String lastEvaluatedStreamArn;

    private ListStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.streams = builder.streams;
        this.lastEvaluatedStreamArn = builder.lastEvaluatedStreamArn;
    }

    /**
     * <p>
     * A list of stream descriptors associated with the current account and endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of stream descriptors associated with the current account and endpoint.
     */
    public List<Stream> streams() {
        return streams;
    }

    /**
     * <p>
     * The stream ARN of the item where the operation stopped, inclusive of the previous result set. Use this value to
     * start a new operation, excluding this value in the new request.
     * </p>
     * <p>
     * If <code>LastEvaluatedStreamArn</code> is empty, then the "last page" of results has been processed and there is
     * no more data to be retrieved.
     * </p>
     * <p>
     * If <code>LastEvaluatedStreamArn</code> is not empty, it does not necessarily mean that there is more data in the
     * result set. The only way to know when you have reached the end of the result set is when
     * <code>LastEvaluatedStreamArn</code> is empty.
     * </p>
     * 
     * @return The stream ARN of the item where the operation stopped, inclusive of the previous result set. Use this
     *         value to start a new operation, excluding this value in the new request.</p>
     *         <p>
     *         If <code>LastEvaluatedStreamArn</code> is empty, then the "last page" of results has been processed and
     *         there is no more data to be retrieved.
     *         </p>
     *         <p>
     *         If <code>LastEvaluatedStreamArn</code> is not empty, it does not necessarily mean that there is more data
     *         in the result set. The only way to know when you have reached the end of the result set is when
     *         <code>LastEvaluatedStreamArn</code> is empty.
     */
    public String lastEvaluatedStreamArn() {
        return lastEvaluatedStreamArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streams());
        hashCode = 31 * hashCode + Objects.hashCode(lastEvaluatedStreamArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsResponse)) {
            return false;
        }
        ListStreamsResponse other = (ListStreamsResponse) obj;
        return Objects.equals(streams(), other.streams())
                && Objects.equals(lastEvaluatedStreamArn(), other.lastEvaluatedStreamArn());
    }

    @Override
    public String toString() {
        return ToString.builder("ListStreamsResponse").add("Streams", streams())
                .add("LastEvaluatedStreamArn", lastEvaluatedStreamArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Streams":
            return Optional.of(clazz.cast(streams()));
        case "LastEvaluatedStreamArn":
            return Optional.of(clazz.cast(lastEvaluatedStreamArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DynamoDBStreamsResponse.Builder, CopyableBuilder<Builder, ListStreamsResponse> {
        /**
         * <p>
         * A list of stream descriptors associated with the current account and endpoint.
         * </p>
         * 
         * @param streams
         *        A list of stream descriptors associated with the current account and endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streams(Collection<Stream> streams);

        /**
         * <p>
         * A list of stream descriptors associated with the current account and endpoint.
         * </p>
         * 
         * @param streams
         *        A list of stream descriptors associated with the current account and endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streams(Stream... streams);

        /**
         * <p>
         * A list of stream descriptors associated with the current account and endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Stream>.Builder} avoiding the need to
         * create one manually via {@link List<Stream>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Stream>.Builder#build()} is called immediately and its
         * result is passed to {@link #streams(List<Stream>)}.
         * 
         * @param streams
         *        a consumer that will call methods on {@link List<Stream>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streams(List<Stream>)
         */
        Builder streams(Consumer<Stream.Builder>... streams);

        /**
         * <p>
         * The stream ARN of the item where the operation stopped, inclusive of the previous result set. Use this value
         * to start a new operation, excluding this value in the new request.
         * </p>
         * <p>
         * If <code>LastEvaluatedStreamArn</code> is empty, then the "last page" of results has been processed and there
         * is no more data to be retrieved.
         * </p>
         * <p>
         * If <code>LastEvaluatedStreamArn</code> is not empty, it does not necessarily mean that there is more data in
         * the result set. The only way to know when you have reached the end of the result set is when
         * <code>LastEvaluatedStreamArn</code> is empty.
         * </p>
         * 
         * @param lastEvaluatedStreamArn
         *        The stream ARN of the item where the operation stopped, inclusive of the previous result set. Use this
         *        value to start a new operation, excluding this value in the new request.</p>
         *        <p>
         *        If <code>LastEvaluatedStreamArn</code> is empty, then the "last page" of results has been processed
         *        and there is no more data to be retrieved.
         *        </p>
         *        <p>
         *        If <code>LastEvaluatedStreamArn</code> is not empty, it does not necessarily mean that there is more
         *        data in the result set. The only way to know when you have reached the end of the result set is when
         *        <code>LastEvaluatedStreamArn</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluatedStreamArn(String lastEvaluatedStreamArn);
    }

    static final class BuilderImpl extends DynamoDBStreamsResponse.BuilderImpl implements Builder {
        private List<Stream> streams;

        private String lastEvaluatedStreamArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsResponse model) {
            super(model);
            streams(model.streams);
            lastEvaluatedStreamArn(model.lastEvaluatedStreamArn);
        }

        public final Collection<Stream.Builder> getStreams() {
            return streams != null ? streams.stream().map(Stream::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder streams(Collection<Stream> streams) {
            this.streams = StreamListCopier.copy(streams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(Stream... streams) {
            streams(Arrays.asList(streams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(Consumer<Stream.Builder>... streams) {
            streams(java.util.stream.Stream.of(streams).map(c -> Stream.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStreams(Collection<Stream.BuilderImpl> streams) {
            this.streams = StreamListCopier.copyFromBuilder(streams);
        }

        public final String getLastEvaluatedStreamArn() {
            return lastEvaluatedStreamArn;
        }

        @Override
        public final Builder lastEvaluatedStreamArn(String lastEvaluatedStreamArn) {
            this.lastEvaluatedStreamArn = lastEvaluatedStreamArn;
            return this;
        }

        public final void setLastEvaluatedStreamArn(String lastEvaluatedStreamArn) {
            this.lastEvaluatedStreamArn = lastEvaluatedStreamArn;
        }

        @Override
        public ListStreamsResponse build() {
            return new ListStreamsResponse(this);
        }
    }
}
