/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTagsOfResourceRequest extends DynamoDBRequest implements
        ToCopyableBuilder<ListTagsOfResourceRequest.Builder, ListTagsOfResourceRequest> {
    private final String resourceArn;

    private final String nextToken;

    private ListTagsOfResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon DynamoDB resource with tags to be listed. This value is an Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The Amazon DynamoDB resource with tags to be listed. This value is an Amazon Resource Name (ARN).
     */
    public String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * An optional string that, if supplied, must be copied from the output of a previous call to ListTagOfResource.
     * When provided in this manner, this API fetches the next page of results.
     * </p>
     * 
     * @return An optional string that, if supplied, must be copied from the output of a previous call to
     *         ListTagOfResource. When provided in this manner, this API fetches the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsOfResourceRequest)) {
            return false;
        }
        ListTagsOfResourceRequest other = (ListTagsOfResourceRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListTagsOfResourceRequest").add("ResourceArn", resourceArn()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.of(clazz.cast(resourceArn()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DynamoDBRequest.Builder, CopyableBuilder<Builder, ListTagsOfResourceRequest> {
        /**
         * <p>
         * The Amazon DynamoDB resource with tags to be listed. This value is an Amazon Resource Name (ARN).
         * </p>
         * 
         * @param resourceArn
         *        The Amazon DynamoDB resource with tags to be listed. This value is an Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * An optional string that, if supplied, must be copied from the output of a previous call to ListTagOfResource.
         * When provided in this manner, this API fetches the next page of results.
         * </p>
         * 
         * @param nextToken
         *        An optional string that, if supplied, must be copied from the output of a previous call to
         *        ListTagOfResource. When provided in this manner, this API fetches the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDBRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsOfResourceRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            nextToken(model.nextToken);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListTagsOfResourceRequest build() {
            return new ListTagsOfResourceRequest(this);
        }
    }
}
