/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.ProvisionedThroughputDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the provisioned throughput settings for the table, consisting of read and write capacity units, along with
 * data about increases and decreases.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ProvisionedThroughputDescription implements StructuredPojo,
        ToCopyableBuilder<ProvisionedThroughputDescription.Builder, ProvisionedThroughputDescription> {
    private final Instant lastIncreaseDateTime;

    private final Instant lastDecreaseDateTime;

    private final Long numberOfDecreasesToday;

    private final Long readCapacityUnits;

    private final Long writeCapacityUnits;

    private ProvisionedThroughputDescription(BuilderImpl builder) {
        this.lastIncreaseDateTime = builder.lastIncreaseDateTime;
        this.lastDecreaseDateTime = builder.lastDecreaseDateTime;
        this.numberOfDecreasesToday = builder.numberOfDecreasesToday;
        this.readCapacityUnits = builder.readCapacityUnits;
        this.writeCapacityUnits = builder.writeCapacityUnits;
    }

    /**
     * <p>
     * The date and time of the last provisioned throughput increase for this table.
     * </p>
     * 
     * @return The date and time of the last provisioned throughput increase for this table.
     */
    public Instant lastIncreaseDateTime() {
        return lastIncreaseDateTime;
    }

    /**
     * <p>
     * The date and time of the last provisioned throughput decrease for this table.
     * </p>
     * 
     * @return The date and time of the last provisioned throughput decrease for this table.
     */
    public Instant lastDecreaseDateTime() {
        return lastDecreaseDateTime;
    }

    /**
     * <p>
     * The number of provisioned throughput decreases for this table during this UTC calendar day. For current maximums
     * on provisioned throughput decreases, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the <i>Amazon
     * DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The number of provisioned throughput decreases for this table during this UTC calendar day. For current
     *         maximums on provisioned throughput decreases, see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
     *         <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Long numberOfDecreasesToday() {
        return numberOfDecreasesToday;
    }

    /**
     * <p>
     * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     * <code>ThrottlingException</code>. Eventually consistent reads require less effort than strongly consistent reads,
     * so a setting of 50 <code>ReadCapacityUnits</code> per second provides 100 eventually consistent
     * <code>ReadCapacityUnits</code> per second.
     * </p>
     * 
     * @return The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
     *         <code>ThrottlingException</code>. Eventually consistent reads require less effort than strongly
     *         consistent reads, so a setting of 50 <code>ReadCapacityUnits</code> per second provides 100 eventually
     *         consistent <code>ReadCapacityUnits</code> per second.
     */
    public Long readCapacityUnits() {
        return readCapacityUnits;
    }

    /**
     * <p>
     * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.
     * </p>
     * 
     * @return The maximum number of writes consumed per second before DynamoDB returns a
     *         <code>ThrottlingException</code>.
     */
    public Long writeCapacityUnits() {
        return writeCapacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastIncreaseDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastDecreaseDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDecreasesToday());
        hashCode = 31 * hashCode + Objects.hashCode(readCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(writeCapacityUnits());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedThroughputDescription)) {
            return false;
        }
        ProvisionedThroughputDescription other = (ProvisionedThroughputDescription) obj;
        return Objects.equals(lastIncreaseDateTime(), other.lastIncreaseDateTime())
                && Objects.equals(lastDecreaseDateTime(), other.lastDecreaseDateTime())
                && Objects.equals(numberOfDecreasesToday(), other.numberOfDecreasesToday())
                && Objects.equals(readCapacityUnits(), other.readCapacityUnits())
                && Objects.equals(writeCapacityUnits(), other.writeCapacityUnits());
    }

    @Override
    public String toString() {
        return ToString.builder("ProvisionedThroughputDescription").add("LastIncreaseDateTime", lastIncreaseDateTime())
                .add("LastDecreaseDateTime", lastDecreaseDateTime()).add("NumberOfDecreasesToday", numberOfDecreasesToday())
                .add("ReadCapacityUnits", readCapacityUnits()).add("WriteCapacityUnits", writeCapacityUnits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LastIncreaseDateTime":
            return Optional.of(clazz.cast(lastIncreaseDateTime()));
        case "LastDecreaseDateTime":
            return Optional.of(clazz.cast(lastDecreaseDateTime()));
        case "NumberOfDecreasesToday":
            return Optional.of(clazz.cast(numberOfDecreasesToday()));
        case "ReadCapacityUnits":
            return Optional.of(clazz.cast(readCapacityUnits()));
        case "WriteCapacityUnits":
            return Optional.of(clazz.cast(writeCapacityUnits()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProvisionedThroughputDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ProvisionedThroughputDescription> {
        /**
         * <p>
         * The date and time of the last provisioned throughput increase for this table.
         * </p>
         * 
         * @param lastIncreaseDateTime
         *        The date and time of the last provisioned throughput increase for this table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastIncreaseDateTime(Instant lastIncreaseDateTime);

        /**
         * <p>
         * The date and time of the last provisioned throughput decrease for this table.
         * </p>
         * 
         * @param lastDecreaseDateTime
         *        The date and time of the last provisioned throughput decrease for this table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDecreaseDateTime(Instant lastDecreaseDateTime);

        /**
         * <p>
         * The number of provisioned throughput decreases for this table during this UTC calendar day. For current
         * maximums on provisioned throughput decreases, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
         * <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param numberOfDecreasesToday
         *        The number of provisioned throughput decreases for this table during this UTC calendar day. For
         *        current maximums on provisioned throughput decreases, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Limits</a> in the
         *        <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDecreasesToday(Long numberOfDecreasesToday);

        /**
         * <p>
         * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         * <code>ThrottlingException</code>. Eventually consistent reads require less effort than strongly consistent
         * reads, so a setting of 50 <code>ReadCapacityUnits</code> per second provides 100 eventually consistent
         * <code>ReadCapacityUnits</code> per second.
         * </p>
         * 
         * @param readCapacityUnits
         *        The maximum number of strongly consistent reads consumed per second before DynamoDB returns a
         *        <code>ThrottlingException</code>. Eventually consistent reads require less effort than strongly
         *        consistent reads, so a setting of 50 <code>ReadCapacityUnits</code> per second provides 100 eventually
         *        consistent <code>ReadCapacityUnits</code> per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readCapacityUnits(Long readCapacityUnits);

        /**
         * <p>
         * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException</code>.
         * </p>
         * 
         * @param writeCapacityUnits
         *        The maximum number of writes consumed per second before DynamoDB returns a
         *        <code>ThrottlingException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder writeCapacityUnits(Long writeCapacityUnits);
    }

    static final class BuilderImpl implements Builder {
        private Instant lastIncreaseDateTime;

        private Instant lastDecreaseDateTime;

        private Long numberOfDecreasesToday;

        private Long readCapacityUnits;

        private Long writeCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedThroughputDescription model) {
            lastIncreaseDateTime(model.lastIncreaseDateTime);
            lastDecreaseDateTime(model.lastDecreaseDateTime);
            numberOfDecreasesToday(model.numberOfDecreasesToday);
            readCapacityUnits(model.readCapacityUnits);
            writeCapacityUnits(model.writeCapacityUnits);
        }

        public final Instant getLastIncreaseDateTime() {
            return lastIncreaseDateTime;
        }

        @Override
        public final Builder lastIncreaseDateTime(Instant lastIncreaseDateTime) {
            this.lastIncreaseDateTime = lastIncreaseDateTime;
            return this;
        }

        public final void setLastIncreaseDateTime(Instant lastIncreaseDateTime) {
            this.lastIncreaseDateTime = lastIncreaseDateTime;
        }

        public final Instant getLastDecreaseDateTime() {
            return lastDecreaseDateTime;
        }

        @Override
        public final Builder lastDecreaseDateTime(Instant lastDecreaseDateTime) {
            this.lastDecreaseDateTime = lastDecreaseDateTime;
            return this;
        }

        public final void setLastDecreaseDateTime(Instant lastDecreaseDateTime) {
            this.lastDecreaseDateTime = lastDecreaseDateTime;
        }

        public final Long getNumberOfDecreasesToday() {
            return numberOfDecreasesToday;
        }

        @Override
        public final Builder numberOfDecreasesToday(Long numberOfDecreasesToday) {
            this.numberOfDecreasesToday = numberOfDecreasesToday;
            return this;
        }

        public final void setNumberOfDecreasesToday(Long numberOfDecreasesToday) {
            this.numberOfDecreasesToday = numberOfDecreasesToday;
        }

        public final Long getReadCapacityUnits() {
            return readCapacityUnits;
        }

        @Override
        public final Builder readCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
            return this;
        }

        public final void setReadCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
        }

        public final Long getWriteCapacityUnits() {
            return writeCapacityUnits;
        }

        @Override
        public final Builder writeCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
            return this;
        }

        public final void setWriteCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
        }

        @Override
        public ProvisionedThroughputDescription build() {
            return new ProvisionedThroughputDescription(this);
        }
    }
}
