/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>PutItem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PutItemRequest extends DynamoDBRequest implements ToCopyableBuilder<PutItemRequest.Builder, PutItemRequest> {
    private final String tableName;

    private final Map<String, AttributeValue> item;

    private final Map<String, ExpectedAttributeValue> expected;

    private final String returnValues;

    private final String returnConsumedCapacity;

    private final String returnItemCollectionMetrics;

    private final String conditionalOperator;

    private final String conditionExpression;

    private final Map<String, String> expressionAttributeNames;

    private final Map<String, AttributeValue> expressionAttributeValues;

    private PutItemRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.item = builder.item;
        this.expected = builder.expected;
        this.returnValues = builder.returnValues;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.returnItemCollectionMetrics = builder.returnItemCollectionMetrics;
        this.conditionalOperator = builder.conditionalOperator;
        this.conditionExpression = builder.conditionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
    }

    /**
     * <p>
     * The name of the table to contain the item.
     * </p>
     * 
     * @return The name of the table to contain the item.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * A map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required; you
     * can optionally provide other attribute name-value pairs for the item.
     * </p>
     * <p>
     * You must provide all of the attributes for the primary key. For example, with a simple primary key, you only need
     * to provide a value for the partition key. For a composite primary key, you must provide both values for both the
     * partition key and the sort key.
     * </p>
     * <p>
     * If you specify any attributes that are part of an index key, then the data types for those attributes must match
     * those of the schema in the table's attribute definition.
     * </p>
     * <p>
     * For more information about primary keys, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey">Primary
     * Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Each element in the <code>Item</code> map is an <code>AttributeValue</code> object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of attribute name/value pairs, one for each attribute. Only the primary key attributes are
     *         required; you can optionally provide other attribute name-value pairs for the item.</p>
     *         <p>
     *         You must provide all of the attributes for the primary key. For example, with a simple primary key, you
     *         only need to provide a value for the partition key. For a composite primary key, you must provide both
     *         values for both the partition key and the sort key.
     *         </p>
     *         <p>
     *         If you specify any attributes that are part of an index key, then the data types for those attributes
     *         must match those of the schema in the table's attribute definition.
     *         </p>
     *         <p>
     *         For more information about primary keys, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey"
     *         >Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     *         </p>
     *         <p>
     *         Each element in the <code>Item</code> map is an <code>AttributeValue</code> object.
     */
    public Map<String, AttributeValue> item() {
        return item;
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href=
     * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html"
     * >Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a
     *         href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html"
     *         >Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, ExpectedAttributeValue> expected() {
        return expected;
    }

    /**
     * <p>
     * Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were updated
     * with the <code>PutItem</code> request. For <code>PutItem</code>, the valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then
     * nothing is returned. (This setting is the default for <code>ReturnValues</code>.)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL_OLD</code> - If <code>PutItem</code> overwrote an attribute name-value pair, then the content of the
     * old item is returned.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however, <code>PutItem</code>
     * does not recognize any values other than <code>NONE</code> or <code>ALL_OLD</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #returnValues} will
     * return {@link ReturnValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #returnValuesAsString}.
     * </p>
     * 
     * @return Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were
     *         updated with the <code>PutItem</code> request. For <code>PutItem</code>, the valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>,
     *         then nothing is returned. (This setting is the default for <code>ReturnValues</code>.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL_OLD</code> - If <code>PutItem</code> overwrote an attribute name-value pair, then the content
     *         of the old item is returned.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however,
     *         <code>PutItem</code> does not recognize any values other than <code>NONE</code> or <code>ALL_OLD</code>.
     *         </p>
     * @see ReturnValue
     */
    public ReturnValue returnValues() {
        return ReturnValue.fromValue(returnValues);
    }

    /**
     * <p>
     * Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were updated
     * with the <code>PutItem</code> request. For <code>PutItem</code>, the valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then
     * nothing is returned. (This setting is the default for <code>ReturnValues</code>.)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL_OLD</code> - If <code>PutItem</code> overwrote an attribute name-value pair, then the content of the
     * old item is returned.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however, <code>PutItem</code>
     * does not recognize any values other than <code>NONE</code> or <code>ALL_OLD</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #returnValues} will
     * return {@link ReturnValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #returnValuesAsString}.
     * </p>
     * 
     * @return Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were
     *         updated with the <code>PutItem</code> request. For <code>PutItem</code>, the valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>,
     *         then nothing is returned. (This setting is the default for <code>ReturnValues</code>.)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL_OLD</code> - If <code>PutItem</code> overwrote an attribute name-value pair, then the content
     *         of the old item is returned.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however,
     *         <code>PutItem</code> does not recognize any values other than <code>NONE</code> or <code>ALL_OLD</code>.
     *         </p>
     * @see ReturnValue
     */
    public String returnValuesAsString() {
        return returnValues;
    }

    /**
     * Returns the value of the ReturnConsumedCapacity property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnConsumedCapacity} will return {@link ReturnConsumedCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #returnConsumedCapacityAsString}.
     * </p>
     * 
     * @return The value of the ReturnConsumedCapacity property for this object.
     * @see ReturnConsumedCapacity
     */
    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(returnConsumedCapacity);
    }

    /**
     * Returns the value of the ReturnConsumedCapacity property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnConsumedCapacity} will return {@link ReturnConsumedCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #returnConsumedCapacityAsString}.
     * </p>
     * 
     * @return The value of the ReturnConsumedCapacity property for this object.
     * @see ReturnConsumedCapacity
     */
    public String returnConsumedCapacityAsString() {
        return returnConsumedCapacity;
    }

    /**
     * <p>
     * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
     * statistics about item collections, if any, that were modified during the operation are returned in the response.
     * If set to <code>NONE</code> (the default), no statistics are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnItemCollectionMetrics} will return {@link ReturnItemCollectionMetrics#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #returnItemCollectionMetricsAsString}.
     * </p>
     * 
     * @return Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
     *         includes statistics about item collections, if any, that were modified during the operation are returned
     *         in the response. If set to <code>NONE</code> (the default), no statistics are returned.
     * @see ReturnItemCollectionMetrics
     */
    public ReturnItemCollectionMetrics returnItemCollectionMetrics() {
        return ReturnItemCollectionMetrics.fromValue(returnItemCollectionMetrics);
    }

    /**
     * <p>
     * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
     * statistics about item collections, if any, that were modified during the operation are returned in the response.
     * If set to <code>NONE</code> (the default), no statistics are returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnItemCollectionMetrics} will return {@link ReturnItemCollectionMetrics#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #returnItemCollectionMetricsAsString}.
     * </p>
     * 
     * @return Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
     *         includes statistics about item collections, if any, that were modified during the operation are returned
     *         in the response. If set to <code>NONE</code> (the default), no statistics are returned.
     * @see ReturnItemCollectionMetrics
     */
    public String returnItemCollectionMetricsAsString() {
        return returnItemCollectionMetrics;
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href=
     * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conditionalOperator} will return {@link ConditionalOperator#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #conditionalOperatorAsString}.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a
     *         href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     *         >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @see ConditionalOperator
     */
    public ConditionalOperator conditionalOperator() {
        return ConditionalOperator.fromValue(conditionalOperator);
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href=
     * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #conditionalOperator} will return {@link ConditionalOperator#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #conditionalOperatorAsString}.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a
     *         href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
     *         >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @see ConditionalOperator
     */
    public String conditionalOperatorAsString() {
        return conditionalOperator;
    }

    /**
     * <p>
     * A condition that must be satisfied in order for a conditional <code>PutItem</code> operation to succeed.
     * </p>
     * <p>
     * An expression can contain any of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Functions: <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code>
     * </p>
     * <p>
     * These function names are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Logical operators: <code>AND | OR | NOT</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on condition expressions, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
     * >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return A condition that must be satisfied in order for a conditional <code>PutItem</code> operation to
     *         succeed.</p>
     *         <p>
     *         An expression can contain any of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Functions:
     *         <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code>
     *         </p>
     *         <p>
     *         These function names are case-sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Logical operators: <code>AND | OR | NOT</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information on condition expressions, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
     *         >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public String conditionExpression() {
        return conditionExpression;
    }

    /**
     * <p>
     * One or more substitution tokens for attribute names in an expression. The following are some use cases for using
     * <code>ExpressionAttributeNames</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To access an attribute whose name conflicts with a DynamoDB reserved word.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a placeholder for repeating occurrences of an attribute name in an expression.
     * </p>
     * </li>
     * <li>
     * <p>
     * To prevent special characters in an attribute name from being misinterpreted in an expression.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following
     * attribute name:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Percentile</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For
     * the complete list of reserved words, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for
     * <code>ExpressionAttributeNames</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>{"#P":"Percentile"}</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You could then use this substitution in an expression, as in this example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>#P = :val</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for
     * the actual value at runtime.
     * </p>
     * </note>
     * <p>
     * For more information on expression attribute names, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more substitution tokens for attribute names in an expression. The following are some use cases
     *         for using <code>ExpressionAttributeNames</code>:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         To access an attribute whose name conflicts with a DynamoDB reserved word.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To create a placeholder for repeating occurrences of an attribute name in an expression.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To prevent special characters in an attribute name from being misinterpreted in an expression.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the
     *         following attribute name:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Percentile</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The name of this attribute conflicts with a reserved word, so it cannot be used directly in an
     *         expression. (For the complete list of reserved words, see <a
     *         href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
     *         Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the
     *         following for <code>ExpressionAttributeNames</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>{"#P":"Percentile"}</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You could then use this substitution in an expression, as in this example:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>#P = :val</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are
     *         placeholders for the actual value at runtime.
     *         </p>
     *         </note>
     *         <p>
     *         For more information on expression attribute names, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     *         >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, String> expressionAttributeNames() {
        return expressionAttributeNames;
    }

    /**
     * <p>
     * One or more values that can be substituted in an expression.
     * </p>
     * <p>
     * Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose that
     * you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following:
     * </p>
     * <p>
     * <code>Available | Backordered | Discontinued</code>
     * </p>
     * <p>
     * You would first need to specify <code>ExpressionAttributeValues</code> as follows:
     * </p>
     * <p>
     * <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
     * </p>
     * <p>
     * You could then use these values in an expression, such as this:
     * </p>
     * <p>
     * <code>ProductStatus IN (:avail, :back, :disc)</code>
     * </p>
     * <p>
     * For more information on expression attribute values, see <a
     * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
     * >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more values that can be substituted in an expression.</p>
     *         <p>
     *         Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example,
     *         suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the
     *         following:
     *         </p>
     *         <p>
     *         <code>Available | Backordered | Discontinued</code>
     *         </p>
     *         <p>
     *         You would first need to specify <code>ExpressionAttributeValues</code> as follows:
     *         </p>
     *         <p>
     *         <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
     *         </p>
     *         <p>
     *         You could then use these values in an expression, such as this:
     *         </p>
     *         <p>
     *         <code>ProductStatus IN (:avail, :back, :disc)</code>
     *         </p>
     *         <p>
     *         For more information on expression attribute values, see <a href=
     *         "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
     *         >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public Map<String, AttributeValue> expressionAttributeValues() {
        return expressionAttributeValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(item());
        hashCode = 31 * hashCode + Objects.hashCode(expected());
        hashCode = 31 * hashCode + Objects.hashCode(returnValuesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(returnConsumedCapacityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(returnItemCollectionMetricsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(conditionalOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(conditionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(expressionAttributeNames());
        hashCode = 31 * hashCode + Objects.hashCode(expressionAttributeValues());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutItemRequest)) {
            return false;
        }
        PutItemRequest other = (PutItemRequest) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(item(), other.item())
                && Objects.equals(expected(), other.expected())
                && Objects.equals(returnValuesAsString(), other.returnValuesAsString())
                && Objects.equals(returnConsumedCapacityAsString(), other.returnConsumedCapacityAsString())
                && Objects.equals(returnItemCollectionMetricsAsString(), other.returnItemCollectionMetricsAsString())
                && Objects.equals(conditionalOperatorAsString(), other.conditionalOperatorAsString())
                && Objects.equals(conditionExpression(), other.conditionExpression())
                && Objects.equals(expressionAttributeNames(), other.expressionAttributeNames())
                && Objects.equals(expressionAttributeValues(), other.expressionAttributeValues());
    }

    @Override
    public String toString() {
        return ToString.builder("PutItemRequest").add("TableName", tableName()).add("Item", item()).add("Expected", expected())
                .add("ReturnValues", returnValuesAsString()).add("ReturnConsumedCapacity", returnConsumedCapacityAsString())
                .add("ReturnItemCollectionMetrics", returnItemCollectionMetricsAsString())
                .add("ConditionalOperator", conditionalOperatorAsString()).add("ConditionExpression", conditionExpression())
                .add("ExpressionAttributeNames", expressionAttributeNames())
                .add("ExpressionAttributeValues", expressionAttributeValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.of(clazz.cast(tableName()));
        case "Item":
            return Optional.of(clazz.cast(item()));
        case "Expected":
            return Optional.of(clazz.cast(expected()));
        case "ReturnValues":
            return Optional.of(clazz.cast(returnValuesAsString()));
        case "ReturnConsumedCapacity":
            return Optional.of(clazz.cast(returnConsumedCapacityAsString()));
        case "ReturnItemCollectionMetrics":
            return Optional.of(clazz.cast(returnItemCollectionMetricsAsString()));
        case "ConditionalOperator":
            return Optional.of(clazz.cast(conditionalOperatorAsString()));
        case "ConditionExpression":
            return Optional.of(clazz.cast(conditionExpression()));
        case "ExpressionAttributeNames":
            return Optional.of(clazz.cast(expressionAttributeNames()));
        case "ExpressionAttributeValues":
            return Optional.of(clazz.cast(expressionAttributeValues()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends DynamoDBRequest.Builder, CopyableBuilder<Builder, PutItemRequest> {
        /**
         * <p>
         * The name of the table to contain the item.
         * </p>
         * 
         * @param tableName
         *        The name of the table to contain the item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * A map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required;
         * you can optionally provide other attribute name-value pairs for the item.
         * </p>
         * <p>
         * You must provide all of the attributes for the primary key. For example, with a simple primary key, you only
         * need to provide a value for the partition key. For a composite primary key, you must provide both values for
         * both the partition key and the sort key.
         * </p>
         * <p>
         * If you specify any attributes that are part of an index key, then the data types for those attributes must
         * match those of the schema in the table's attribute definition.
         * </p>
         * <p>
         * For more information about primary keys, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey"
         * >Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * <p>
         * Each element in the <code>Item</code> map is an <code>AttributeValue</code> object.
         * </p>
         * 
         * @param item
         *        A map of attribute name/value pairs, one for each attribute. Only the primary key attributes are
         *        required; you can optionally provide other attribute name-value pairs for the item.</p>
         *        <p>
         *        You must provide all of the attributes for the primary key. For example, with a simple primary key,
         *        you only need to provide a value for the partition key. For a composite primary key, you must provide
         *        both values for both the partition key and the sort key.
         *        </p>
         *        <p>
         *        If you specify any attributes that are part of an index key, then the data types for those attributes
         *        must match those of the schema in the table's attribute definition.
         *        </p>
         *        <p>
         *        For more information about primary keys, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey"
         *        >Primary Key</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         *        </p>
         *        <p>
         *        Each element in the <code>Item</code> map is an <code>AttributeValue</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(Map<String, AttributeValue> item);

        /**
         * <p>
         * This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html"
         * >Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param expected
         *        This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a
         *        href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html"
         *        >Expected</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expected(Map<String, ExpectedAttributeValue> expected);

        /**
         * <p>
         * Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were
         * updated with the <code>PutItem</code> request. For <code>PutItem</code>, the valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then
         * nothing is returned. (This setting is the default for <code>ReturnValues</code>.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL_OLD</code> - If <code>PutItem</code> overwrote an attribute name-value pair, then the content of
         * the old item is returned.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however, <code>PutItem</code>
         * does not recognize any values other than <code>NONE</code> or <code>ALL_OLD</code>.
         * </p>
         * </note>
         * 
         * @param returnValues
         *        Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were
         *        updated with the <code>PutItem</code> request. For <code>PutItem</code>, the valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is
         *        <code>NONE</code>, then nothing is returned. (This setting is the default for
         *        <code>ReturnValues</code>.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL_OLD</code> - If <code>PutItem</code> overwrote an attribute name-value pair, then the
         *        content of the old item is returned.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however,
         *        <code>PutItem</code> does not recognize any values other than <code>NONE</code> or
         *        <code>ALL_OLD</code>.
         *        </p>
         * @see ReturnValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnValue
         */
        Builder returnValues(String returnValues);

        /**
         * <p>
         * Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were
         * updated with the <code>PutItem</code> request. For <code>PutItem</code>, the valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is <code>NONE</code>, then
         * nothing is returned. (This setting is the default for <code>ReturnValues</code>.)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL_OLD</code> - If <code>PutItem</code> overwrote an attribute name-value pair, then the content of
         * the old item is returned.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however, <code>PutItem</code>
         * does not recognize any values other than <code>NONE</code> or <code>ALL_OLD</code>.
         * </p>
         * </note>
         * 
         * @param returnValues
         *        Use <code>ReturnValues</code> if you want to get the item attributes as they appeared before they were
         *        updated with the <code>PutItem</code> request. For <code>PutItem</code>, the valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code> - If <code>ReturnValues</code> is not specified, or if its value is
         *        <code>NONE</code>, then nothing is returned. (This setting is the default for
         *        <code>ReturnValues</code>.)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL_OLD</code> - If <code>PutItem</code> overwrote an attribute name-value pair, then the
         *        content of the old item is returned.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>ReturnValues</code> parameter is used by several DynamoDB operations; however,
         *        <code>PutItem</code> does not recognize any values other than <code>NONE</code> or
         *        <code>ALL_OLD</code>.
         *        </p>
         * @see ReturnValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnValue
         */
        Builder returnValues(ReturnValue returnValues);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(String returnConsumedCapacity);

        /**
         * Sets the value of the ReturnConsumedCapacity property for this object.
         *
         * @param returnConsumedCapacity
         *        The new value for the ReturnConsumedCapacity property for this object.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity);

        /**
         * <p>
         * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
         * statistics about item collections, if any, that were modified during the operation are returned in the
         * response. If set to <code>NONE</code> (the default), no statistics are returned.
         * </p>
         * 
         * @param returnItemCollectionMetrics
         *        Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
         *        includes statistics about item collections, if any, that were modified during the operation are
         *        returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.
         * @see ReturnItemCollectionMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnItemCollectionMetrics
         */
        Builder returnItemCollectionMetrics(String returnItemCollectionMetrics);

        /**
         * <p>
         * Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response includes
         * statistics about item collections, if any, that were modified during the operation are returned in the
         * response. If set to <code>NONE</code> (the default), no statistics are returned.
         * </p>
         * 
         * @param returnItemCollectionMetrics
         *        Determines whether item collection metrics are returned. If set to <code>SIZE</code>, the response
         *        includes statistics about item collections, if any, that were modified during the operation are
         *        returned in the response. If set to <code>NONE</code> (the default), no statistics are returned.
         * @see ReturnItemCollectionMetrics
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnItemCollectionMetrics
         */
        Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics);

        /**
         * <p>
         * This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param conditionalOperator
         *        This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a
         *        href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         *        >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @see ConditionalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionalOperator
         */
        Builder conditionalOperator(String conditionalOperator);

        /**
         * <p>
         * This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         * >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param conditionalOperator
         *        This is a legacy parameter. Use <code>ConditionExpression</code> instead. For more information, see <a
         *        href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html"
         *        >ConditionalOperator</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @see ConditionalOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionalOperator
         */
        Builder conditionalOperator(ConditionalOperator conditionalOperator);

        /**
         * <p>
         * A condition that must be satisfied in order for a conditional <code>PutItem</code> operation to succeed.
         * </p>
         * <p>
         * An expression can contain any of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Functions:
         * <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code>
         * </p>
         * <p>
         * These function names are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Logical operators: <code>AND | OR | NOT</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information on condition expressions, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
         * >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param conditionExpression
         *        A condition that must be satisfied in order for a conditional <code>PutItem</code> operation to
         *        succeed.</p>
         *        <p>
         *        An expression can contain any of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Functions:
         *        <code>attribute_exists | attribute_not_exists | attribute_type | contains | begins_with | size</code>
         *        </p>
         *        <p>
         *        These function names are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Comparison operators: <code>= | &lt;&gt; | &lt; | &gt; | &lt;= | &gt;= | BETWEEN | IN </code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Logical operators: <code>AND | OR | NOT</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information on condition expressions, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
         *        >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditionExpression(String conditionExpression);

        /**
         * <p>
         * One or more substitution tokens for attribute names in an expression. The following are some use cases for
         * using <code>ExpressionAttributeNames</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To access an attribute whose name conflicts with a DynamoDB reserved word.
         * </p>
         * </li>
         * <li>
         * <p>
         * To create a placeholder for repeating occurrences of an attribute name in an expression.
         * </p>
         * </li>
         * <li>
         * <p>
         * To prevent special characters in an attribute name from being misinterpreted in an expression.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the
         * following attribute name:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Percentile</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression.
         * (For the complete list of reserved words, see <a
         * href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a>
         * in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for
         * <code>ExpressionAttributeNames</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>{"#P":"Percentile"}</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You could then use this substitution in an expression, as in this example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>#P = :val</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders
         * for the actual value at runtime.
         * </p>
         * </note>
         * <p>
         * For more information on expression attribute names, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param expressionAttributeNames
         *        One or more substitution tokens for attribute names in an expression. The following are some use cases
         *        for using <code>ExpressionAttributeNames</code>:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        To access an attribute whose name conflicts with a DynamoDB reserved word.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To create a placeholder for repeating occurrences of an attribute name in an expression.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To prevent special characters in an attribute name from being misinterpreted in an expression.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider
         *        the following attribute name:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Percentile</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The name of this attribute conflicts with a reserved word, so it cannot be used directly in an
         *        expression. (For the complete list of reserved words, see <a
         *        href="http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
         *        Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the
         *        following for <code>ExpressionAttributeNames</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>{"#P":"Percentile"}</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You could then use this substitution in an expression, as in this example:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>#P = :val</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are
         *        placeholders for the actual value at runtime.
         *        </p>
         *        </note>
         *        <p>
         *        For more information on expression attribute names, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         *        >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionAttributeNames(Map<String, String> expressionAttributeNames);

        /**
         * <p>
         * One or more values that can be substituted in an expression.
         * </p>
         * <p>
         * Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example, suppose
         * that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of the following:
         * </p>
         * <p>
         * <code>Available | Backordered | Discontinued</code>
         * </p>
         * <p>
         * You would first need to specify <code>ExpressionAttributeValues</code> as follows:
         * </p>
         * <p>
         * <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
         * </p>
         * <p>
         * You could then use these values in an expression, such as this:
         * </p>
         * <p>
         * <code>ProductStatus IN (:avail, :back, :disc)</code>
         * </p>
         * <p>
         * For more information on expression attribute values, see <a href=
         * "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
         * >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param expressionAttributeValues
         *        One or more values that can be substituted in an expression.</p>
         *        <p>
         *        Use the <b>:</b> (colon) character in an expression to dereference an attribute value. For example,
         *        suppose that you wanted to check whether the value of the <i>ProductStatus</i> attribute was one of
         *        the following:
         *        </p>
         *        <p>
         *        <code>Available | Backordered | Discontinued</code>
         *        </p>
         *        <p>
         *        You would first need to specify <code>ExpressionAttributeValues</code> as follows:
         *        </p>
         *        <p>
         *        <code>{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }</code>
         *        </p>
         *        <p>
         *        You could then use these values in an expression, such as this:
         *        </p>
         *        <p>
         *        <code>ProductStatus IN (:avail, :back, :disc)</code>
         *        </p>
         *        <p>
         *        For more information on expression attribute values, see <a href=
         *        "http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html"
         *        >Specifying Conditions</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDBRequest.BuilderImpl implements Builder {
        private String tableName;

        private Map<String, AttributeValue> item;

        private Map<String, ExpectedAttributeValue> expected;

        private String returnValues;

        private String returnConsumedCapacity;

        private String returnItemCollectionMetrics;

        private String conditionalOperator;

        private String conditionExpression;

        private Map<String, String> expressionAttributeNames;

        private Map<String, AttributeValue> expressionAttributeValues;

        private BuilderImpl() {
        }

        private BuilderImpl(PutItemRequest model) {
            super(model);
            tableName(model.tableName);
            item(model.item);
            expected(model.expected);
            returnValues(model.returnValues);
            returnConsumedCapacity(model.returnConsumedCapacity);
            returnItemCollectionMetrics(model.returnItemCollectionMetrics);
            conditionalOperator(model.conditionalOperator);
            conditionExpression(model.conditionExpression);
            expressionAttributeNames(model.expressionAttributeNames);
            expressionAttributeValues(model.expressionAttributeValues);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Map<String, AttributeValue.Builder> getItem() {
            return item != null ? CollectionUtils.mapValues(item, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder item(Map<String, AttributeValue> item) {
            this.item = PutItemInputAttributeMapCopier.copy(item);
            return this;
        }

        public final void setItem(Map<String, AttributeValue.BuilderImpl> item) {
            this.item = PutItemInputAttributeMapCopier.copyFromBuilder(item);
        }

        public final Map<String, ExpectedAttributeValue.Builder> getExpected() {
            return expected != null ? CollectionUtils.mapValues(expected, ExpectedAttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder expected(Map<String, ExpectedAttributeValue> expected) {
            this.expected = ExpectedAttributeMapCopier.copy(expected);
            return this;
        }

        public final void setExpected(Map<String, ExpectedAttributeValue.BuilderImpl> expected) {
            this.expected = ExpectedAttributeMapCopier.copyFromBuilder(expected);
        }

        public final String getReturnValues() {
            return returnValues;
        }

        @Override
        public final Builder returnValues(String returnValues) {
            this.returnValues = returnValues;
            return this;
        }

        @Override
        public final Builder returnValues(ReturnValue returnValues) {
            this.returnValues(returnValues.toString());
            return this;
        }

        public final void setReturnValues(String returnValues) {
            this.returnValues = returnValues;
        }

        public final String getReturnConsumedCapacity() {
            return returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final String getReturnItemCollectionMetrics() {
            return returnItemCollectionMetrics;
        }

        @Override
        public final Builder returnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        @Override
        public final Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics(returnItemCollectionMetrics.toString());
            return this;
        }

        public final void setReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
        }

        public final String getConditionalOperator() {
            return conditionalOperator;
        }

        @Override
        public final Builder conditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
            return this;
        }

        @Override
        public final Builder conditionalOperator(ConditionalOperator conditionalOperator) {
            this.conditionalOperator(conditionalOperator.toString());
            return this;
        }

        public final void setConditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
        }

        public final String getConditionExpression() {
            return conditionExpression;
        }

        @Override
        public final Builder conditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public final void setConditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public final Map<String, AttributeValue.Builder> getExpressionAttributeValues() {
            return expressionAttributeValues != null ? CollectionUtils.mapValues(expressionAttributeValues,
                    AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue.BuilderImpl> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copyFromBuilder(expressionAttributeValues);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutItemRequest build() {
            return new PutItemRequest(this);
        }
    }
}
