/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.Record;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link Record} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class RecordMarshaller {
    private static final MarshallingInfo<String> EVENTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventID").isBinary(false).build();

    private static final MarshallingInfo<String> EVENTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventName").isBinary(false).build();

    private static final MarshallingInfo<String> EVENTVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventVersion").isBinary(false).build();

    private static final MarshallingInfo<String> EVENTSOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventSource").isBinary(false).build();

    private static final MarshallingInfo<String> AWSREGION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsRegion").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> DYNAMODB_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dynamodb").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> USERIDENTITY_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("userIdentity")
            .isBinary(false).build();

    private static final RecordMarshaller INSTANCE = new RecordMarshaller();

    private RecordMarshaller() {
    }

    public static RecordMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(Record record, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(record, "record");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(record.eventID(), EVENTID_BINDING);
            protocolMarshaller.marshall(record.eventNameAsString(), EVENTNAME_BINDING);
            protocolMarshaller.marshall(record.eventVersion(), EVENTVERSION_BINDING);
            protocolMarshaller.marshall(record.eventSource(), EVENTSOURCE_BINDING);
            protocolMarshaller.marshall(record.awsRegion(), AWSREGION_BINDING);
            protocolMarshaller.marshall(record.dynamodb(), DYNAMODB_BINDING);
            protocolMarshaller.marshall(record.userIdentity(), USERIDENTITY_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
