/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.transform.AttributeDefinitionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttributeDefinition
implements StructuredPojo,
ToCopyableBuilder<Builder, AttributeDefinition> {
    private final String attributeName;
    private final String attributeType;

    private AttributeDefinition(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.attributeType = builder.attributeType;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public ScalarAttributeType attributeType() {
        return ScalarAttributeType.fromValue(this.attributeType);
    }

    public String attributeTypeAsString() {
        return this.attributeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeDefinition)) {
            return false;
        }
        AttributeDefinition other = (AttributeDefinition)obj;
        return Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.attributeTypeAsString(), other.attributeTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"AttributeDefinition").add("AttributeName", (Object)this.attributeName()).add("AttributeType", (Object)this.attributeTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeName": {
                return Optional.of(clazz.cast(this.attributeName()));
            }
            case "AttributeType": {
                return Optional.of(clazz.cast(this.attributeTypeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributeDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private String attributeType;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeDefinition model) {
            this.attributeName(model.attributeName);
            this.attributeType(model.attributeType);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getAttributeType() {
            return this.attributeType;
        }

        @Override
        public final Builder attributeType(String attributeType) {
            this.attributeType = attributeType;
            return this;
        }

        @Override
        public final Builder attributeType(ScalarAttributeType attributeType) {
            this.attributeType(attributeType.toString());
            return this;
        }

        public final void setAttributeType(String attributeType) {
            this.attributeType = attributeType;
        }

        public AttributeDefinition build() {
            return new AttributeDefinition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttributeDefinition> {
        public Builder attributeName(String var1);

        public Builder attributeType(String var1);

        public Builder attributeType(ScalarAttributeType var1);
    }
}

